/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.F7SelectedList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PrivacySchemeFieldSelectorPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
SearchEnterListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_IDENT = "fieldident";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_TYPE = "fieldtype";
    private static final String ENTITY_NAME = "entityname";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String LABEL_ID = "labelid";
    private static final String KEY_SEARCH = "searchap";
    private static final String NO = "NO";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        if (null != grid) {
            grid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getEntryState().getSelectedRows();
        if (selRows == null || selRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5!", (String)"PrivacySchemeFieldSelectorPlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection selectData = new DynamicObjectCollection();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int selRow : selRows) {
            selectData.add(entryEntity.get(selRow));
        }
        this.getView().returnDataToParent((Object)selectData);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection data = this.getDecryptData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        DynamicObjectCollection newData = new DynamicObjectCollection();
        HashSet<String> filterSet = new HashSet<String>(8);
        HashMap<String, String> strategyMap = new HashMap<String, String>(1);
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"privacy_desen_rules", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)NO)});
        for (DynamicObject value : dataMap.values()) {
            String number = value.getString("number");
            strategyMap.put(value.getString("id"), number);
        }
        for (DynamicObject row : data) {
            String rule = row.getString("fdesen_rule_basedata_id");
            if (NO.equals(rule = strategyMap.getOrDefault(rule, rule)) || "FOLLOW".equals(rule)) continue;
            String fdense_field_ident = row.getString("fdense_field_ident");
            String fdense_entity_number = row.getString("fdense_entity_number");
            String str = fdense_field_ident + "!" + fdense_entity_number;
            if (!filterSet.add(str)) continue;
            int newEntryRow = this.getModel().createNewEntryRow(ENTRY_ENTITY);
            this.getModel().setValue(LABEL_ID, row.get("denselabelid"), newEntryRow);
            this.getModel().setValue(FIELD_IDENT, (Object)fdense_field_ident, newEntryRow);
            this.getModel().setValue(FIELD_NAME, row.get("fdense_field_desc"), newEntryRow);
            this.getModel().setValue(FIELD_TYPE, row.get("fdense_field_type"), newEntryRow);
            this.getModel().setValue(ENTITY_NAME, row.get("fdense_entity_name"), newEntryRow);
            this.getModel().setValue(ENTITY_NUMBER, (Object)fdense_entity_number, newEntryRow);
            newData.add(row);
        }
        this.getView().getPageCache().put("entryData", SerializationUtils.toJsonString((Object)this.getModel().getEntryEntity(ENTRY_ENTITY)));
    }

    private DynamicObjectCollection getDecryptData() {
        String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
        if (StringUtils.isBlank((CharSequence)mainPageId)) {
            return null;
        }
        IFormView parentView = this.getView().getViewNoPlugin(mainPageId);
        return parentView.getModel().getEntryEntity("t_privacy_scheme_desen");
    }

    public void entryRowClick(RowClickEvent evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selRows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(selRows.length);
        for (int selRow : selRows) {
            DynamicObject row = (DynamicObject)entryEntity.get(selRow);
            String text = String.format("%s(%s)", row.getString(FIELD_NAME), row.getString(ENTITY_NAME));
            valueTextItems.add(new ValueTextItem(text, text));
        }
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        f7SelectedList.addItems(valueTextItems);
    }

    private List<ValueTextItem> getF7SelectedItems(DynamicObjectCollection entryEntity) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        for (DynamicObject row : entryEntity) {
            String text = String.format("%s(%s)", row.getString(FIELD_NAME), row.getString(ENTITY_NAME));
            valueTextItems.add(new ValueTextItem(text, text));
        }
        if (!valueTextItems.isEmpty()) {
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
            f7SelectedList.addItems(valueTextItems);
        }
        return valueTextItems;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String searchText = evt.getText();
        if (!StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            return;
        }
        List data = (List)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("entryData"), List.class);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        List<Map> newData = new ArrayList(data.size());
        if (StringUtils.isBlank((CharSequence)searchText)) {
            newData = data;
        } else {
            List fieldNames = evt.getFieldNames();
            for (Map row : data) {
                for (String fieldName : fieldNames) {
                    String field = row.getOrDefault(fieldName, "").toString();
                    if (!field.contains(searchText)) continue;
                    newData.add(row);
                }
            }
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty(newData)) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, newData.size());
            for (int i = 0; i < newData.size(); ++i) {
                Map row = (Map)newData.get(i);
                this.getModel().setValue(LABEL_ID, row.get(LABEL_ID), i);
                this.getModel().setValue(FIELD_IDENT, row.get(FIELD_IDENT), i);
                this.getModel().setValue(FIELD_NAME, row.get(FIELD_NAME), i);
                this.getModel().setValue(FIELD_TYPE, row.get(FIELD_TYPE), i);
                this.getModel().setValue(ENTITY_NAME, row.get(ENTITY_NAME), i);
                this.getModel().setValue(ENTITY_NUMBER, row.get(ENTITY_NUMBER), i);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }
}

