/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListCardView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.privacy.plugin.PrivacyPluginUtil;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PrivacySchemeListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(PrivacySchemeListPlugin.class);
    private static final String KEY_BTN_DELETE = "labelap_del";
    private static final String SCHEME_ENTRY = "t_privacy_scheme_config";
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";
    private static Set<Long> schemeIds = new HashSet<Long>(1);

    public void initialize() {
        super.initialize();
        if (!ISVServiceHelper.isKingdeeISV()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblexport"});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTN_DELETE});
        super.registerListener(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PrivacySchemeListDataProvider());
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey().toLowerCase();
        if (KEY_BTN_DELETE.equals(key)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            HashSet<Object> idSets = new HashSet<Object>(rows.size());
            for (ListSelectedRow row : rows) {
                idSets.add(row.getPrimaryKeyValue());
            }
            QFilter filter = new QFilter("id", "in", idSets);
            QFilter encryptFilter = new QFilter("t_privacy_scheme_encrypt.fencrypt_status", "=", (Object)Character.valueOf('0')).or(new QFilter("t_privacy_scheme_encrypt.fencrypt_algorithm", "!=", (Object)"NO"));
            QFilter[] filters = new QFilter[]{filter, encryptFilter};
            DynamicObject config = QueryServiceHelper.queryOne((String)SCHEME_ENTRY, (String)"id,t_privacy_scheme_encrypt.fencrypt_algorithm,t_privacy_scheme_encrypt.fencrypt_status", (QFilter[])filters);
            if (config != null) {
                if ("0".equals(config.getString("t_privacy_scheme_encrypt.fencrypt_status"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PrivacySchemeListPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9690\u79c1\u65b9\u6848\u4e2d\u5df2\u6709\u6570\u636e\u88ab\u52a0\u5bc6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PrivacySchemeListPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                }
                evt.setCancel(true);
                return;
            }
        }
        super.beforeClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("delete".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey())) {
            PrivacyDataCenterManager.clearCache();
        } else if ("tblexport".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.showPrivacySchemeExport();
        } else if ("bar_add_tempalte".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.showPrivacySchemeTemplate();
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("fscheme_status".equalsIgnoreCase(columnDesc.getFieldKey())) {
            e.setFormatValue((Object)Character.valueOf(schemeIds.contains(rowData.get("id")) ? (char)'0' : '1'));
        }
        super.packageData(e);
    }

    private void showPrivacySchemeExport() {
        this.getModel().getEntryEntity(SCHEME_ENTRY);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("schemeIds", schemeIds);
        parameter.setFormId("privacy_scheme_export");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showPrivacySchemeTemplate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("privacy_scheme_add_temp");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void afterCreateNewData(EventObject e) {
        if (!PrivacyDataCenterManager.isEnable()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9690\u79c1\u4e2d\u5fc3\u672a\u542f\u7528\uff0c\u914d\u7f6e\u6570\u636e\u5c06\u4e0d\u4f1a\u751f\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u542f\u3002", (String)"PrivacySchemeListPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void createNewData(BizDataEventArgs e) {
        LicenseCheckResult checkResult = PrivacyPluginUtil.getLicenseCheckResult();
        if (checkResult != null && !checkResult.getHasLicense().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
            ListCardView cardView = (ListCardView)this.getControl("cardview");
            Map clientMeta = cardView.getClientMeta();
            this.invisibleLabelap_del((List)clientMeta.get("items"));
            log.info("no license, button [add,delete] setVisible false ");
        }
    }

    private void invisibleLabelap_del(List<Map<String, Object>> items) {
        if (items == null) {
            return;
        }
        for (Map<String, Object> item : items) {
            if (KEY_BTN_DELETE.equals(item.get("id"))) {
                item.put("vi", 0);
                break;
            }
            this.invisibleLabelap_del((List)item.get("items"));
        }
    }

    static class PrivacySchemeListDataProvider
    extends ListDataProvider {
        PrivacySchemeListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int end) {
            DynamicObjectCollection rows = super.getData(start, end);
            if (rows.isEmpty()) {
                return rows;
            }
            HashSet<Object> idSets = new HashSet<Object>(rows.size());
            for (DynamicObject row : rows) {
                idSets.add(row.getPkValue());
            }
            String sql = String.format("select fid from t_privacy_scheme_encrypt where fid in (%s) and fencrypt_status != '%s'", StringUtils.join((Object[])idSets.toArray(), (String)","), Character.valueOf('1'));
            try {
                schemeIds = (Set)DB.query((DBRoute)new DBRoute("sys"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws SQLException {
                        HashSet<Long> schemeIds = new HashSet<Long>(6);
                        while (rs.next()) {
                            schemeIds.add(rs.getLong(1));
                        }
                        return schemeIds;
                    }
                });
            }
            catch (Exception e) {
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            return rows;
        }
    }
}

