/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.privacy.DesensitizeStrategyFactory;
import kd.bos.privacy.IDesensitizeStrategy;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.strategy.RegularDesenStrategy;
import kd.bos.util.StringUtils;

public class PrivacySimulatedOperationPlugin
extends AbstractBillPlugIn {
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void registerListener(EventObject e) {
        Button run = (Button)this.getControl("run");
        run.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("run".equals(key)) {
            String desenValue;
            Object value = this.getModel().getValue("value");
            if (value == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6d4b\u8bd5\u503c\u3002", (String)"PrivacySimulatedOperationPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                return;
            }
            try {
                Object pk = this.getView().getFormShowParameter().getCustomParam("strategy");
                IDesensitizeStrategy strategy = null;
                if (pk instanceof String && StringUtils.isNotEmpty((String)pk.toString())) {
                    strategy = DesensitizeStrategyFactory.getStrategy((String)pk.toString());
                }
                if (strategy == null) {
                    String matchRules = (String)this.getView().getFormShowParameter().getCustomParam("matchrules");
                    String replacement = (String)this.getView().getFormShowParameter().getCustomParam("replacement");
                    strategy = new RegularDesenStrategy(matchRules, replacement);
                }
                PrivacyEncryptModel encryptModel = new PrivacyEncryptModel();
                encryptModel.setFieldType("12");
                desenValue = strategy.desensitize(encryptModel, value);
            }
            catch (Exception e) {
                desenValue = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u8fd4\u56de\u4fee\u6539\u3002", (String)"PrivacySimulatedOperationPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"PrivacySimulatedOperationPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), e.getMessage());
            }
            this.getModel().setValue("desenvalue", (Object)desenValue);
            this.getView().updateView();
        }
    }
}

