/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.utils.PrivacyTaskUtils;

public class PrivacyTaskSplitPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PrivacyTaskSplitPlugin.class);
    private static final String FENCRYPT_ALGORITHM = "fencrypt_algorithm";
    private static final String FENCRYPT_TABLE_NAME = "fencrypt_table_name";
    private static final String FENCRYPT_FIELD_NAME = "fencrypt_field_name";
    private static final String FENCRYPT_ENTITY_NUMBER = "fencrypt_entity_number";
    private static final String FENCRYPT_STATUS = "fencrypt_status";
    private static final String NO = "NO";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        if (entities.length <= 0) {
            return;
        }
        this.existMigrateTask(entities[0].get("id"), e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject dataEntity;
        DynamicObjectCollection encryptList;
        DynamicObject[] entities = e.getDataEntities();
        if (entities.length <= 0) {
            return;
        }
        Long schemeId = (Long)entities[0].get("id");
        HashMap<String, Set<Integer>> encryptMaps = new HashMap<String, Set<Integer>>(entities.length);
        DynamicObject[] dynamicObjectArray = entities;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n && (encryptList = (dataEntity = dynamicObjectArray[i]).getDynamicObjectCollection("t_privacy_scheme_encrypt")) != null && encryptList.size() > 0; ++i) {
            HashSet<String> filterSet = new HashSet<String>(encryptList.size());
            DynamicObjectCollection changeData = new DynamicObjectCollection();
            ArrayList<SqlParameter[]> sqlParams = new ArrayList<SqlParameter[]>(encryptList.size());
            HashSet<String> entityNumberSet = new HashSet<String>(encryptList.size());
            Map allData = PrivacyTaskUtils.queryAllEncryptData((Object)schemeId, (DynamicObjectCollection)encryptList);
            PrivacyEncryptService service = new PrivacyEncryptService();
            for (DynamicObject newObj : encryptList) {
                String key = PrivacyTaskUtils.buildEncryptConstaintKey((String)newObj.getString(FENCRYPT_TABLE_NAME), (String)newObj.getString(FENCRYPT_FIELD_NAME));
                if (!filterSet.add(key)) continue;
                Map oldObj = (Map)allData.get(key);
                if (oldObj == null && newObj.getString(FENCRYPT_ALGORITHM).equals(NO) || oldObj != null && oldObj.get(FENCRYPT_ALGORITHM).toString().equals(newObj.get(FENCRYPT_ALGORITHM).toString())) {
                    newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('1'));
                    continue;
                }
                changeData.add((Object)newObj);
                newObj.set(FENCRYPT_STATUS, (Object)Character.valueOf('0'));
                int taskType = 1;
                String oldEncryptType = newObj.get(FENCRYPT_ALGORITHM).toString();
                if (oldObj == null && !newObj.getString(FENCRYPT_ALGORITHM).equals(NO) || oldObj != null && oldObj.get(FENCRYPT_ALGORITHM).toString().equals(NO) && !newObj.get(FENCRYPT_ALGORITHM).toString().equals(NO)) {
                    entityNumberSet.add(newObj.getString(FENCRYPT_ENTITY_NUMBER));
                    allData.remove(key);
                } else if (oldObj != null && !oldObj.get(FENCRYPT_ALGORITHM).toString().equals(newObj.get(FENCRYPT_ALGORITHM).toString())) {
                    if (newObj.get(FENCRYPT_ALGORITHM).toString().equals(NO)) {
                        entityNumberSet.add(newObj.getString(FENCRYPT_ENTITY_NUMBER));
                        taskType = 2;
                    } else {
                        taskType = 3;
                    }
                    oldEncryptType = oldObj.get(FENCRYPT_ALGORITHM).toString();
                }
                this.checkEncryptService(service, taskType, newObj.getString(FENCRYPT_ALGORITHM), oldEncryptType, encryptMaps);
                SqlParameter[] parameter = PrivacyTaskUtils.buildSqlParameter((Long)schemeId, (DynamicObject)newObj, (int)taskType, (String)oldEncryptType);
                sqlParams.add(parameter);
                this.addOperateInfo(parameter);
                PrivacyTaskUtils.printTaskLog((SqlParameter[])parameter, (int)taskType);
            }
            PrivacyTaskUtils.updateEncryptAlgorithmField((DynamicObjectCollection)changeData);
            PrivacyTaskUtils.buildPrivacyTable(entityNumberSet);
            BaseTask.batchSave(sqlParams);
        }
    }

    private void checkTask(DynamicObject newObj, BeforeOperationArgs e) {
        String sql = "select count(1) as counter from t_privacy_task where ftable_name = ? and ffield_name = ? and ftask_status in ('1','2','4')";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":ftable_name", 12, (Object)newObj.getString(FENCRYPT_TABLE_NAME)), new SqlParameter(":ffield_name", 12, (Object)newObj.getString(FENCRYPT_FIELD_NAME))};
        try (DataSet ds = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.checkTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            Row row;
            if (ds != null && ds.hasNext() && (row = ds.next()).getInteger("counter") > 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210,\u4e0d\u80fd\u8fdb\u884c\u518d\u6b21\u8fc1\u79fb", (String)"PrivacyTaskSplitPlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void existMigrateTask(Object schemeId, BeforeOperationArgs e) {
        String sql = "select count(1) as counter from t_privacy_task where fschemeid=? and ftask_status in ('0','1','2','4')";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fschemeid", -5, schemeId)};
        try (DataSet ds = DB.queryDataSet((String)"PrivacyTaskSplitPlugin.checkTask", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);){
            Row row;
            if (ds != null && ds.hasNext() && (row = ds.next()).getInteger("counter") > 0) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\u6570\u636e\u8fc1\u79fb\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210,\u4e0d\u80fd\u8fdb\u884c\u52a0\u5bc6\u53d8\u66f4\u3002", (String)"PrivacyTaskSplitPlugin_1", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void addOperateInfo(SqlParameter[] sqlParameter) {
        OperateErrorInfo opInfo = new OperateErrorInfo();
        opInfo.setMessage(String.format(ResManager.loadKDString((String)"ID\uff1a%1$s\u3002\u5b9e\u4f53\u540d\uff1a%2$s\u3002\u5b57\u6bb5\u6807\u8bc6\uff1a%3$s\u3002", (String)"PrivacyTaskSplitPlugin_6", (String)"bos-privacy-plugin", (Object[])new Object[0]), sqlParameter[0], sqlParameter[13], sqlParameter[21]));
        opInfo.setLevel(ErrorLevel.Info);
        this.getOperationResult().getAllErrorInfo().add(opInfo);
    }

    private void checkEncryptService(PrivacyEncryptService service, int taskType, String encryptType, String oldEncryptType, Map<String, Set<Integer>> encryptMaps) {
        if (taskType == 3) {
            boolean checked = this.checkEncryptService(service, 2, oldEncryptType, encryptMaps);
            if (checked) {
                this.checkEncryptService(service, 1, encryptType, encryptMaps);
            }
        } else if (taskType == 1) {
            this.checkEncryptService(service, taskType, encryptType, encryptMaps);
        } else if (taskType == 2) {
            this.checkEncryptService(service, taskType, oldEncryptType, encryptMaps);
        }
    }

    private boolean checkEncryptService(PrivacyEncryptService service, int taskType, String encryptType, Map<String, Set<Integer>> encryptMaps) {
        Set<Integer> types = encryptMaps.get(encryptType);
        if (types == null) {
            types = new HashSet<Integer>(2);
            encryptMaps.put(encryptType, types);
        }
        if (types.contains(taskType)) {
            return true;
        }
        JSONObject result = null;
        if (taskType == 1 || taskType == 2) {
            result = service.encryptData(Long.parseLong(encryptType), "test");
        }
        if (taskType == 2 && result != null && result.getBoolean("success").booleanValue()) {
            result = service.decryptData(Long.parseLong(encryptType), result.getString("data"));
        }
        if (result != null) {
            boolean checked = result.getBoolean("success");
            if (checked) {
                types.add(taskType);
            } else {
                logger.error(String.format("encryptData error schemeId: %s, taskType: %s, result: %s", encryptType, taskType, result.toJSONString()));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u53d1\u5e03\u5931\u8d25\uff0c%s", (String)"PrivacyTaskSplitPlugin_7", (String)"bos-privacy-plugin", (Object[])new Object[0]), result.getString("description")));
            }
        }
        return true;
    }
}

