/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class SchemeEncryptRulePlugin
extends AbstractFormPlugin {
    private static final String FORMID_DATA_DESENT_RULES = "privacy_data_desent_rules";

    public void afterCreateNewData(EventObject e) {
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("pkid");
        this.fillEncryptType(pkId);
        this.fillDesensitizeRules(pkId);
    }

    public void afterBindData(EventObject e) {
    }

    private void fillEncryptType(Long pkId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select top 1 fencrypt_algorithm from t_privacy_scheme_encrypt where ", new Object[0]);
        sb.append("fscheme_id =" + pkId, new Object[0]);
        try (DataSet rs = DB.queryDataSet((String)"SchemeRuleSettingPlugin.fillEncryptType", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);){
            if (rs != null && rs.hasNext()) {
                this.getView().getModel().setValue("combofield", rs.next().get("fencrypt_algorithm"));
            }
        }
    }

    private void fillDesensitizeRules(Long pkId) {
        DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
        entryRows.clear();
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fscheme_id,fplugin,fdata_classify,fid,fdesensitize_type,fdesensitize_code,fdesensitize_desc from t_privacy_scheme_desensitize where ", new Object[0]);
        sb.append("fscheme_id =" + pkId, new Object[0]);
        try (DataSet rs = DB.queryDataSet((String)"SchemeRuleSettingPlugin.fillDesensitizeRules", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);){
            while (rs.hasNext()) {
                Row row = rs.next();
                DynamicObject entryRow = entryRows.addNew();
                entryRow.set("dataclassify", (Object)row.getString("fdata_classify"));
                entryRow.set("desensitizetype", (Object)row.getString("fdesensitize_type"));
                entryRow.set("desensitizecode", (Object)row.getString("fdesensitize_code"));
                entryRow.set("desensitizedesc", (Object)row.getString("fdesensitize_desc"));
                entryRow.set("plugin", (Object)row.getString("fplugin"));
                entryRow.set("fid", (Object)row.getLong("fid"));
            }
        }
    }

    private void saveEncryptType(Long pkId) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select top 1 fencrypt_algorithm from t_privacy_scheme_encrypt where ", new Object[0]);
        sb.append("fscheme_id =" + pkId, new Object[0]);
        try (DataSet rs = DB.queryDataSet((String)"SchemeRuleSettingPlugin.fillEncryptType", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);){
            ComboEdit cbField = (ComboEdit)this.getView().getControl("combofield");
            String newValue = cbField.getModel().getDataEntity().getString(0);
            if (rs != null) {
                if (rs.hasNext()) {
                    Row row = rs.next();
                    String oldValue = row.getString("fencrypt_algorithm");
                    if (StringUtils.isEmpty((String)newValue)) {
                        Object[] paras = new SqlParameter[]{new SqlParameter(":fscheme_id", -5, (Object)pkId)};
                        String sql = "delete t_privacy_scheme_encrypt  where fscheme_id =? ";
                        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])paras);
                    } else if (!newValue.equals(oldValue)) {
                        Object[] paras = new SqlParameter[]{new SqlParameter(":fencrypt_algorithm", 12, (Object)newValue), new SqlParameter(":fscheme_id", -5, (Object)pkId)};
                        String sql = "update t_privacy_scheme_encrypt set fencrypt_algorithm = ? where fscheme_id =? ";
                        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])paras);
                    }
                } else if (!StringUtils.isEmpty((String)newValue)) {
                    Object[] paras = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"t_privacy_scheme_encrypt")), new SqlParameter(":FSCHEME_ID", -5, (Object)pkId), new SqlParameter(":FENCRYPT_ALGORITHM", 12, (Object)newValue), new SqlParameter(":FENCRYPT_SYS", 12, (Object)"MC")};
                    String sql = "insert into t_privacy_scheme_encrypt(fid,fscheme_id,fencrypt_algorithm,fencrypt_sys) values (?,?,?,?);";
                    DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])paras);
                }
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SchemeEncryptRulePlugin_0", (String)"bos-privacy-plugin", (Object[])new Object[0]));
    }

    private void saveDesensitizeRules(Long pkId) {
        this.delAllDesensitize(pkId);
        this.batchInsertDesensitize(pkId);
    }

    private void delAllDesensitize(Long pkId) {
        Object[] paras = new SqlParameter[]{new SqlParameter(":fscheme_id", -5, (Object)pkId)};
        String sql = "delete t_privacy_scheme_desensitize  where fscheme_id =? ";
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])paras);
    }

    private void batchInsertDesensitize(Long pkId) {
        DynamicObjectCollection dos = this.getView().getModel().getEntryEntity("entryentity");
        String sql = "insert into t_privacy_scheme_desensitize(fscheme_id,fplugin,fdata_classify,fid,fdesensitize_desc,fdesensitize_code,fdesensitize_type) values (?,?,?,?,?,?,?);";
        for (DynamicObject dObj : dos) {
            Object[] paras = new SqlParameter[]{new SqlParameter(":FSCHEME_ID", -5, (Object)pkId), new SqlParameter(":FPLUGIN", 12, dObj.get("plugin")), new SqlParameter(":FDATA_CLASSIFY", 12, dObj.get("dataClassify")), new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"t_privacy_scheme_desensitize")), new SqlParameter(":FDESENSITIZE_DESC", 12, dObj.get("desensitizedesc")), new SqlParameter(":FDESENSITIZE_CODE", 12, dObj.get("desensitizeCode")), new SqlParameter(":FDESENSITIZE_TYPE", 12, dObj.get("desensitizeType"))};
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])paras);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        super.registerListener(e);
    }

    /*
     * Unable to fully structure code
     */
    public void itemClick(ItemClickEvent evt) {
        pkId = null;
        var3_3 = evt.getItemKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1147676899: {
                if (!var3_3.equals("addrule")) break;
                var4_4 = 0;
                break;
            }
            case -782215183: {
                if (!var3_3.equals("btnsettingsave")) break;
                var4_4 = 1;
            }
        }
        switch (var4_4) {
            case 0: {
                pkId = (Long)((Toolbar)evt.getSource()).getView().getFormShowParameter().getCustomParam("pkid");
                para = new HashMap<String, Object>();
                para.put("formId", "privacy_data_desent_rules");
                para.put("pkid", pkId);
                showParameter = FormShowParameter.createFormShowParameter(para);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addrule"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
            case 1: {
                pkId = (Long)((Toolbar)evt.getSource()).getView().getFormShowParameter().getCustomParam("pkid");
                tx = TX.requiresNew((String)"saveDesensitizeRules");
                var8_8 = null;
                this.saveEncryptType(pkId);
                this.saveDesensitizeRules(pkId);
                if (tx == null) break;
                if (var8_8 == null) ** GOTO lbl40
                try {
                    tx.close();
                }
                catch (Throwable var9_9) {
                    var8_8.addSuppressed(var9_9);
                }
                break;
lbl40:
                // 1 sources

                tx.close();
                break;
                catch (Throwable var9_10) {
                    try {
                        var8_8 = var9_10;
                        throw var9_10;
                    }
                    catch (Throwable var10_11) {
                        if (tx != null) {
                            if (var8_8 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable var11_12) {
                                    var8_8.addSuppressed(var11_12);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        throw var10_11;
                    }
                }
            }
        }
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("addrule".equalsIgnoreCase(actionId)) {
            Map ret = (Map)closedCallBackEvent.getReturnData();
            if (ret == null) {
                return;
            }
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("dataclassify", ret.get("dataclassify"), rowIndex);
            this.getModel().setValue("desensitizetype", ret.get("desensitizetype"), rowIndex);
            this.getModel().setValue("desensitizecode", ret.get("desensitizecode"), rowIndex);
            this.getModel().setValue("desensitizedesc", ret.get("desensitizedesc"), rowIndex);
            this.getModel().setValue("plugin", ret.get("plugin"), rowIndex);
        }
    }
}

