/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.Html;
import kd.bos.privacy.plugin.upgrade.AbstractUpgradePlugin;
import kd.bos.privacy.plugin.upgrade.UpgradeUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class PrivacyAgreementPlugin
extends AbstractUpgradePlugin {
    private static final String BOS_PRIVACY_PLUGIN = "bos-privacy-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"agree", "disagree"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initHtml();
        this.getModel().setValue("starttimetxt", (Object)ResManager.loadKDString((String)"\u6b64\u523b", (String)"PrivacyAgreementPlugin_18", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
    }

    private void initHtml() {
        Html html = (Html)this.getControl("html");
        html.setConent(this.getHtmlContent());
    }

    private String getHtmlContent() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div style=\"       font-family: MicrosoftYaHei;\n        font-size: 14px;\n        color: #111111;\n        letter-spacing: 0;\n        line-height: 31px;\n        font-weight: 400;\n        text-indent:2em;\n        max-width:1180px;\">");
        builder.append("<p>").append(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6b27\u76df\u300a\u901a\u7528\u6570\u636e\u4fdd\u62a4\u6761\u4f8b\u300b\uff08GDPR\uff09\u3001\u65b0\u52a0\u5761\u300a\u4e2a\u4eba\u6570\u636e\u4fdd\u62a4\u6cd5\u300b\uff08PDPA\uff09\u3001\u4e2d\u56fd\u300a\u4e2a\u4eba\u6570\u636e\u4fdd\u62a4\u6cd5\u300b\uff08PIPL\uff09\u7b49\u591a\u4e2a\u56fd\u5bb6\u7684\u9690\u79c1\u4fdd\u62a4\u6cd5\u5f8b\u8981\u6c42\uff0c\u4f01\u4e1a\u9700\u8981\u5bf9\u5176\u6536\u96c6\u3001\u5b58\u50a8\u3001\u5904\u7406\u7684%1$S\u654f\u611f\u4e2a\u4eba\u4fe1\u606f%2$S\u91c7\u53d6\u52a0\u5bc6\u3001\u8131\u654f\u7b49\u5b89\u5168\u4fdd\u62a4\u6280\u672f\u63aa\u65bd\uff0c\u4ee5\u9632\u6b62\u4e2a\u4eba\u4fe1\u606f\u88ab\u672a\u6388\u6743\u8bbf\u95ee\u3001\u6cc4\u9732\u3001\u7be1\u6539\u7b49\u3002", (String)"PrivacyAgreementPlugin_2", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), "<strong style=\"font-weight:700;\">", "</strong>")).append("</p>");
        builder.append("<p>").append(String.format(ResManager.loadKDString((String)"\u672c\u4ea7\u54c1\u5df2\u63d0\u4f9b\u6570\u636e\u52a0\u5bc6\u5b58\u50a8\u3001\u8131\u654f\u5c55\u793a\u7b49\u9690\u79c1\u7ba1\u7406\u529f\u80fd\uff0c\u5e76\u5728\u4ea7\u54c1\u4f7f\u7528\u65b9\uff08\u6307\u7528\u6237\u201c\u60a8\u201d\u6216\u60a8\u6240\u4ee3\u8868\u7684\u4f01\u4e1a/\u5355\u4f4d\uff09\u5bf9\u672c\u98ce\u9669\u544a\u77e5\u4e66\u70b9\u51fb%1S\u540c\u610f%2S\uff0c\u540c\u65f6\u9009\u62e9\u76f8\u5173\u914d\u7f6e\u540e\u5bf9\u5404\u56fd\u6cd5\u5f8b\u5f3a\u5236\u8981\u6c42\u52a0\u5bc6\u3001\u8131\u654f\u7684\u654f\u611f\u4e2a\u4eba\u4fe1\u606f\uff08\u8eab\u4efd\u8bc1\u53f7\u3001\u4e2a\u4eba\u94f6\u884c\u5361\u53f7\u7801\u7b49\u5b57\u6bb5\uff09\u8fdb\u884c\u9ed8\u8ba4\u9884\u7f6e\u52a0\u5bc6\u53ca\u8131\u654f\u5c55\u793a\u5904\u7406\u3002", (String)"PrivacyAgreementPlugin_3", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), "<strong style=\"font-weight:700;\">", "</strong>")).append("</p>");
        builder.append("<p>").append(ResManager.loadKDString((String)"\u5728\u5b8c\u6210\u9884\u7f6e\u52a0\u5bc6\u4efb\u52a1\u540e\uff0c\u4ea7\u54c1\u4f7f\u7528\u65b9\uff08\u6307\u7528\u6237\u201c\u60a8\u201d\u6216\u60a8\u6240\u4ee3\u8868\u7684\u4f01\u4e1a/\u5355\u4f4d\uff09\u4ecd\u9700\u8981\u6839\u636e\u4e1a\u52a1\u6240\u5728\u56fd\u5bb6/\u5730\u533a\u7684\u6cd5\u5f8b\u6cd5\u89c4\u8981\u6c42\uff0c\u7ed3\u5408\u5b9e\u9645\u4f01\u4e1a\u4e1a\u52a1\u9700\u8981\uff0c\u4f7f\u7528\u9690\u79c1\u7ba1\u7406\u529f\u80fd\u8fdb\u884c\u8fdb\u4e00\u6b65\u7684\u52a0\u5bc6\u53ca\u8131\u654f\u914d\u7f6e\uff0c\u4ee5\u6ee1\u8db3\u76f8\u5173\u6570\u636e\u5408\u89c4\u53ca\u4e1a\u52a1\u8981\u6c42\u3002", (String)"PrivacyAgreementPlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("</p>");
        builder.append("</br>");
        builder.append("<p>").append(String.format(ResManager.loadKDString((String)"%1$S\u8bf7\u6ce8\u610f\uff1a\u5f53\u524d\u6570\u636e\u52a0\u5bc6\u529f\u80fd\u4f1a\u5bf9\u6570\u636e\u5e93\u4e2d\u7684\u4e2a\u4eba\u4fe1\u606f\u8fdb\u884c\u52a0\u5bc6\u5904\u7406\uff0c%2$S\u53ef\u80fd\u4f1a\u5f71\u54cd\u5230\u60a8\u5bf9\u7cfb\u7edf\u7684\u90e8\u5206\u529f\u80fd\u7684\u4f7f\u7528\uff0c\u4f8b\u5982\u5bf9\u52a0\u5bc6\u5b57\u6bb5\u7684\u6a21\u7cca\u641c\u7d22\u548c\u90e8\u5206SQL\u67e5\u8be2\u529f\u80fd\u3002\u5982\u60a8\u7684\u7cfb\u7edf\u4e0e\u7b2c\u4e09\u65b9\u4ea4\u4e92\u7684\u7cfb\u7edf\u5b58\u5728\u5f15\u7528\u5df2\u914d\u7f6e\u52a0\u5bc6\u7684\u4e2a\u4eba\u4fe1\u606f\u5b57\u6bb5\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u76f8\u5173\u4ea4\u4e92\u9875\u9762\u51fa\u73b0\u62a5\u9519\uff0c\u5177\u4f53\u7684\u914d\u7f6e\u542f\u7528\u6548\u679c\u53ca\u62a5\u9519\u89e3\u51b3\u63aa\u65bd\uff0c\u8be6\u89c1\u793e\u533a\u6307\u5f15\u6587\u6863\uff1a%3$S", (String)"PrivacyAgreementPlugin_5", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), "<span style=\"color: #FF0000;\">*</span>", "<strong  style=\"font-weight:700;\">", "</strong><span style=\"color: rgb(14, 95, 216); font-weight: 700; \"><a href=\"https://vip.kingdee.com/article/461173747643414016\" target=\"_blank\">https://vip.kingdee.com/article/461173747643414016</a></span>")).append("</p>");
        builder.append("<p>").append(ResManager.loadKDString((String)"\u8bf7\u60a8\u786e\u8ba4\u5e76\u77e5\u6089\uff0c\u654f\u611f\u4e2a\u4eba\u4fe1\u606f\u7684\u5408\u89c4\u5904\u7406\u662f\u6cd5\u5f8b\u6cd5\u89c4\u8d4b\u4e88\u60a8\u53ca\u60a8\u6240\u5728\u4f01\u4e1a/\u5355\u4f4d\u7684\u76f8\u5173\u4e49\u52a1\uff0c\u91d1\u8776\u5c06\u5c3d\u6700\u5927\u52aa\u529b\u63d0\u4f9b\u9690\u79c1\u7ba1\u7406\u5de5\u5177\u4fc3\u4f7f\u60a8\u7684\u654f\u611f\u4e2a\u4eba\u4fe1\u606f\u5904\u7406\u7b26\u5408\u76f8\u5173\u89c4\u5b9a\u3002", (String)"PrivacyAgreementPlugin_17", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("</p>");
        builder.append("</p>");
        builder.append("</div>");
        return builder.toString();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object ctl = evt.getSource();
        if (ctl instanceof Button) {
            if ("agree".equals(((Button)ctl).getKey())) {
                if (!this.firstValid()) {
                    return;
                }
                HashMap<String, Object> data = new HashMap<String, Object>(10);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                RequestContext rc = RequestContext.get();
                data.put("accountId", rc.getAccountId());
                data.put("tenantId", rc.getTenantId());
                data.put("ver", "1.0");
                data.put("userId", rc.getCurrUserId());
                data.put("signatureDate", df.format(new Date()));
                data.put("status", "1");
                data.put("comments", ResManager.loadKDString((String)"\u540c\u610f\u9690\u79c1\u65b9\u6848\u81ea\u52a8\u65b9\u6848\u5347\u7ea7", (String)"PrivacyAgreementPlugin_0", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
                data.put("protocol", this.getProtocol());
                this.saveAgreement(data);
                String msgChannels = (String)this.getModel().getValue("msgchannels");
                Long notifierId = RequestContext.get().getCurrUserId();
                Date start = new Date();
                String algorithm = (String)this.getModel().getValue("algorithm");
                this.generateScheduleTask(notifierId, msgChannels, start, algorithm);
                this.showSuccessMsg(this.getView().getFormShowParameter().getParentPageId());
                this.getView().close();
            } else if ("disagree".equals(((Button)ctl).getKey())) {
                this.logOff();
            }
        }
    }

    private void logOff() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(6);
        String logoutUrl = "auth/logout.do";
        if (RequestContext.get() != null && RequestContext.get().getLang() != null) {
            logoutUrl = logoutUrl + "?language=" + RequestContext.get().getLang().name();
        }
        mpURL.put("url", logoutUrl);
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private void saveAgreement(Map<String, Object> data) {
        if (!UpgradeUtils.existAgreement()) {
            String sql = "insert into T_PRIVACY_UPGRADEPROTOCOL(FID,FUSERID,FDATA,FSTATUS,FCREATETIME) VALUES(?,?,?,?,?)";
            Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genGlobalLongId()), new SqlParameter(":FUSERID", -5, (Object)RequestContext.get().getCurrUserId()), new SqlParameter(":FDATA", 2011, (Object)SerializationUtils.toJsonString(data)), new SqlParameter(":FSTATUS", 1, (Object)Character.valueOf('1')), new SqlParameter(":FCREATETIME", 93, (Object)new Date())};
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
            UpgradeUtils.addOpLog(this.getView().getFormShowParameter().getFormId(), "saveAgreement", ResManager.loadKDString((String)"\u7b7e\u7f72\u534f\u8bae", (String)"PrivacyAgreementPlugin_1", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), "");
        }
    }

    private String getProtocol() {
        StringBuilder builder = new StringBuilder();
        builder.append("   ").append(ResManager.loadKDString((String)"\u6839\u636e\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u6570\u636e\u5b89\u5168\u6cd5\u300b\u3001\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4e2a\u4eba\u4fe1\u606f\u4fdd\u62a4\u6cd5\u300b\u7b49\u6cd5\u89c4\u8981\u6c42\uff0c\u4f01\u4e1a\u9700\u5bf9\u5176\u6536\u96c6\u3001\u5904\u7406\u7684\u4e2a\u4eba\u4fe1\u606f\u91c7\u53d6\u52a0\u5bc6\u3001\u53bb\u6807\u8bc6\u5316\u7b49\u5b89\u5168\n", (String)"PrivacyAgreementPlugin_6", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u6280\u672f\u63aa\u65bd\uff0c\u4ee5\u9632\u6b62\u4e2a\u4eba\u4fe1\u606f\u88ab\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u6216\u53d1\u751f\u4e2a\u4eba\u4fe1\u606f\u6cc4\u9732\u3001\u7be1\u6539\u3001\u4e22\u5931\u7b49\u7f51\u7edc\u5b89\u5168\u4e8b\u4ef6\u3002\n", (String)"PrivacyAgreementPlugin_7", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u672c\u4ea7\u54c1\u5df2\u63d0\u4f9b\u6570\u636e\u52a0\u5bc6\u5b58\u50a8\u3001\u8131\u654f\u5c55\u793a\u7b49\u9690\u79c1\u7ba1\u7406\u529f\u80fd\uff0c\u5e76\u5728\u4ea7\u54c1\u4f7f\u7528\u65b9\uff08\u6307\u7528\u6237\u201c\u60a8\u201d\u6216\u60a8\u6240\u4ee3\u8868\u7684\u4f01\u4e1a/\u5355\u4f4d\uff09\u5bf9\u672c\u98ce\u9669\u544a\u77e5\u4e66\u70b9\u51fb\u201c\u540c\u610f\u201d\uff0c\u540c\u65f6\n", (String)"PrivacyAgreementPlugin_8", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u9009\u62e9\u76f8\u5173\u914d\u7f6e\u540e\u5bf9\u4e2d\u56fd\u6cd5\u5f8b\u5f3a\u5236\u8981\u6c42\u52a0\u5bc6\u3001\u53bb\u6807\u8bc6\u5316\u7684\u654f\u611f\u4e2a\u4eba\u4fe1\u606f\uff08\u8eab\u4efd\u8bc1\u53f7\u3001\u4e2a\u4eba\u94f6\u884c\u5361\u53f7\u7b49\u5b57\u6bb5\uff09\u8fdb\u884c\u9ed8\u8ba4\u9884\u7f6e\u52a0\u5bc6\u53ca\u8131\u654f\u5904\u7406\u3002\n", (String)"PrivacyAgreementPlugin_9", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u5728\u5b8c\u6210\u9884\u7f6e\u52a0\u5bc6\u4efb\u52a1\u4e4b\u540e\uff0c\u4ea7\u54c1\u4f7f\u7528\u65b9\uff08\u6307\u7528\u6237\u201c\u60a8\u201d\u6216\u60a8\u6240\u4ee3\u8868\u7684\u4f01\u4e1a/\u5355\u4f4d\uff09\u4ecd\u9700\u6839\u636e\u4e1a\u52a1\u6240\u5728\u56fd\u5bb6/\u5730\u533a\u7684\u6cd5\u5f8b\u6cd5\u89c4\u8981\u6c42\uff0c\u7ed3\u5408\u5b9e\u9645\u4f01\u4e1a\u4e1a\u52a1\u9700\n", (String)"PrivacyAgreementPlugin_10", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u8981\uff0c\u4f7f\u7528\u9690\u79c1\u7ba1\u7406\u529f\u80fd\u8fdb\u884c\u8fdb\u4e00\u6b65\u7684\u52a0\u5bc6\u53ca\u8131\u654f\u914d\u7f6e\uff0c\u4ee5\u6ee1\u8db3\u6709\u5173\u6570\u636e\u5408\u89c4\u53ca\u4e1a\u52a1\u8981\u6c42\u3002\n", (String)"PrivacyAgreementPlugin_11", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u5f53\u524d\u6570\u636e\u52a0\u5bc6\u529f\u80fd\u4f1a\u5bf9\u6570\u636e\u5e93\u4e2d\u7684\u4e2a\u4eba\u4fe1\u606f\u8fdb\u884c\u52a0\u5bc6\u5904\u7406\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u5230\u60a8\u5bf9\u7cfb\u7edf\u7684\u90e8\u5206\u529f\u80fd\u7684\u4f7f\u7528\uff0c\u4f8b\u5982\u5bf9\u52a0\u5bc6\u5b57\u6bb5\u7684\u6a21\u7cca\u641c\u7d22\u548c\u90e8\u5206SQL\n", (String)"PrivacyAgreementPlugin_12", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u67e5\u8be2\u529f\u80fd\u3002\u5982\u60a8\u7684\u7cfb\u7edf\u4e0e\u7b2c\u4e09\u65b9\u4ea4\u4e92\u7684\u7cfb\u7edf\u5b58\u5728\u5f15\u7528\u5df2\u914d\u7f6e\u52a0\u5bc6\u7684\u4e2a\u4eba\u4fe1\u606f\u5b57\u6bb5\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u76f8\u5173\u4ea4\u4e92\u9875\u9762\u51fa\u73b0\u62a5\u9519\uff0c\u5177\u4f53\u7684\u914d\u7f6e\u542f\u7528\u6548\u679c\u53ca\u62a5\u9519\u89e3\u51b3\u63aa\n", (String)"PrivacyAgreementPlugin_13", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u65bd\uff0c\u8be6\u89c1\u793e\u533a\u6307\u5f15\u6587\u6863\uff1a https://vip.kingdee.com/article/461173747643414016\n", (String)"PrivacyAgreementPlugin_14", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u8bf7\u60a8\u786e\u8ba4\u5e76\u77e5\u6089\uff0c\u4e2a\u4eba\u4fe1\u606f\u7684\u5408\u89c4\u5904\u7406\u662f\u6cd5\u5f8b\u6cd5\u89c4\u8d4b\u4e88\u60a8\u53ca\u60a8\u6240\u5728\u4f01\u4e1a/\u5355\u4f4d\u7684\u76f8\u5173\u4e49\u52a1\uff0c\u91d1\u8776\u5df2\u5c3d\u6700\u5927\u52aa\u529b\u63d0\u4f9b\u9690\u79c1\u7ba1\u7406\u5de5\u5177\u4fc3\u4f7f\u60a8\u7684\u4e2a\u4eba\u4fe1\u606f\u5904\u7406\u7b26\n", (String)"PrivacyAgreementPlugin_15", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0])).append("        ").append(ResManager.loadKDString((String)"\u5408\u6709\u5173\u89c4\u5b9a\uff0c\u5982\u60a8\u62d2\u7edd\u9690\u79c1\u7ba1\u7406\u914d\u7f6e\uff0c\u7531\u6b64\u5bfc\u81f4\u7684\u5b89\u5168\u98ce\u9669\u4e0e\u8d23\u4efb\uff0c\u5c06\u7531\u60a8\u53ca\u60a8\u6240\u4ee3\u8868\u7684\u4f01\u4e1a / \u5355\u4f4d\u81ea\u884c\u627f\u62c5\u3002\n", (String)"PrivacyAgreementPlugin_16", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]));
        return builder.toString();
    }

    @Override
    protected void generateScheduleTask(Long notifierId, String msgChannels, Date startTime, String algorithm) {
        ArrayList<String> msgChannelList = new ArrayList<String>(3);
        for (String it : msgChannels.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            msgChannelList.add(it);
        }
        JobInfo jobInfo = this.createJob(notifierId, msgChannelList, algorithm);
        String taskid = ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        UpgradeUtils.addOpLog(this.getView().getFormShowParameter().getFormId(), "createSchedule", ResManager.loadKDString((String)"\u751f\u6210\u9690\u79c1\u5347\u7ea7\u5b9a\u65f6\u4efb\u52a1", (String)"AbstractUpgradePlugin_4", (String)BOS_PRIVACY_PLUGIN, (Object[])new Object[0]), taskid);
    }
}

