/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.privacy.plugin.upgrade.SingleHandler;
import kd.bos.privacy.plugin.upgrade.TaskContainer;
import kd.bos.privacy.plugin.upgrade.UpgradeUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class PrivacyUpgradeJob
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PrivacyUpgradeJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(RequestContext rc, Map<String, Object> map) throws KDException {
        String key = String.format("%s_%s_%s", rc.getTenantId(), rc.getAccountId(), "privacy_autoupgrade_job");
        DLock lock = DLock.create((String)key, (String)String.valueOf(this.taskId));
        log.info("PrivacyUpgradeJob:  begin upgrade");
        if (lock.tryLock()) {
            Long notifierId = Long.parseLong(String.valueOf(map.get("notifierId")));
            String msgChannels = (String)map.get("msgChannels");
            try {
                QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)"1")};
                List tagIds = QueryServiceHelper.queryPrimaryKeys((String)"privacy_data_tags_temp", (QFilter[])filters, (String)"id", (int)-1);
                if (tagIds.isEmpty()) return;
                TaskContainer taskContainer = new TaskContainer(notifierId, (String)map.get("msgChannels"));
                for (Object tagId : tagIds) {
                    SingleHandler singleHandler = new SingleHandler((Long)tagId, (String)map.get("algorithm"));
                    taskContainer.addAnalyzer(singleHandler);
                }
                taskContainer.run();
                return;
            }
            catch (Exception e) {
                log.error((Throwable)e);
                DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)notifierId, (String)"bos_user", (String)"name");
                String content = ResManager.loadKDString((String)"%1$s \u60a8\u597d\u3002\n    \u9690\u79c1\u65b9\u6848\u4efb\u52a1\u521b\u5efa\u5931\u8d25\u4e86\uff0c\u9700\u8981\u8054\u7cfb\u76f8\u5173\u6280\u672f\u4eba\u5458\u5206\u6790\u5904\u7406\u540e\uff0c\u4f7f\u7528administrator\u8d26\u53f7\u767b\u5f55\u540e\u518d\u6b21\u786e\u8ba4\uff0c\u8c22\u8c22\u3002\n    \u9519\u8bef\u6807\u8bc6\uff1a%2$s\u3002", (String)"PrivacyUpgradeJob_1", (String)"bos-privacy-plugin", (Object[])new Object[]{user == null ? notifierId : user.getString("name"), rc.getTraceId()});
                ArrayList<Long> receiverIds = new ArrayList<Long>(1);
                receiverIds.add(notifierId);
                ArrayList<MessageInfo> msgs = new ArrayList<MessageInfo>(3);
                for (String type : msgChannels.split(",")) {
                    if (StringUtils.isBlank((CharSequence)type)) continue;
                    MessageInfo info = new MessageInfo();
                    info.setType("message");
                    info.setContent(content);
                    info.setUserIds(receiverIds);
                    info.setNestAppid("privacy");
                    info.setSource("privacy");
                    info.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
                    info.setTitle(ResManager.loadKDString((String)"\u9690\u79c1\u65b9\u6848\u5347\u7ea7\u5931\u8d25\u63d0\u9192", (String)"PrivacyUpgradeMonitorJob_1", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                    info.setTag(ResManager.loadKDString((String)"\u9690\u79c1\u4e2d\u5fc3", (String)"PrivacyUpgradeMonitorJob_2", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                    info.setNotifyType(type);
                    msgs.add(info);
                }
                MessageCenterServiceHelper.batchSendMessages(msgs);
                return;
            }
            finally {
                lock.unlock();
            }
        } else {
            DLockInfo lockInfo = DLock.getLockInfo((String)key);
            HashMap<String, String> detail = new HashMap<String, String>(3);
            detail.put("msg", ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u8fd0\u884c\uff0c\u5f53\u524d\u4efb\u52a1\u8df3\u8fc7", (String)"PrivacyUpgradeJob_0", (String)"bos-privacy-implement", (Object[])new Object[0]));
            detail.put("runningTaskId", lockInfo.getDesc());
            detail.put("currentTaskId", this.taskId);
            UpgradeUtils.addOpLog("t_privacy_scheme_config", "skiptask", this.taskId, SerializationUtils.toJsonString(detail));
            this.stop();
        }
    }
}

