/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class PrivacyUpgradeMonitorJob
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PrivacyUpgradeMonitorJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ArrayList msgChannels = new ArrayList(3);
        String channels = (String)map.get("msgChannels");
        String[] channel = channels.split(",");
        if (channel.length > 0) {
            Collections.addAll(msgChannels, channel);
        }
        Long notifierId = Long.parseLong(map.get("notifierId").toString());
        List taskIds = SerializationUtils.fromJsonStringToList((String)((String)map.get("taskIds")), Object.class);
        DynamicObject[] taskObjs = BusinessDataServiceHelper.load((Object[])taskIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"t_privacy_task"));
        boolean error = false;
        for (DynamicObject obj : taskObjs) {
            if (!"4".equals(obj.getString("ftask_status"))) continue;
            error = true;
            break;
        }
        if (error) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)notifierId, (String)"bos_user", (String)"name");
            String content = ResManager.loadKDString((String)"%s \u60a8\u597d\u3002\n        \u9690\u79c1\u65b9\u6848\u6267\u884c\u7684\u52a0\u89e3\u5bc6\u4efb\u52a1\u5904\u7406\u5931\u8d25\u4e86\uff0c\u4e3a\u4e86\u907f\u514d\u5f71\u54cd\u7528\u6237\u7684\u6b63\u5e38\u4f7f\u7528\uff0c\u8bf7\u767b\u5f55\u5e73\u53f0\u8fdb\u5165\u3010\u7cfb\u7edf\u670d\u52a1\u4e91-\u5b89\u5168\u7ba1\u7406-\u9690\u79c1\u7ba1\u7406-\u6570\u636e\u5904\u7406\u3011\u6a21\u5757\u8fdb\u884c\u5904\u7406\uff0c\u8c22\u8c22\u3002", (String)"PrivacyUpgradeMonitorJob_0", (String)"bos-privacy-plugin", (Object[])new Object[]{user == null ? notifierId : user.getString("name")});
            ArrayList<Long> receiverIds = new ArrayList<Long>(1);
            receiverIds.add(notifierId);
            ArrayList<MessageInfo> msgs = new ArrayList<MessageInfo>(msgChannels.size());
            for (String type : msgChannels) {
                MessageInfo info = new MessageInfo();
                info.setType("message");
                info.setContent(content);
                info.setUserIds(receiverIds);
                info.setNestAppid("privacy");
                info.setSource("privacy");
                info.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
                info.setTitle(ResManager.loadKDString((String)"\u9690\u79c1\u65b9\u6848\u5347\u7ea7\u5931\u8d25\u63d0\u9192", (String)"PrivacyUpgradeMonitorJob_1", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                info.setTag(ResManager.loadKDString((String)"\u9690\u79c1\u4e2d\u5fc3", (String)"PrivacyUpgradeMonitorJob_2", (String)"bos-privacy-plugin", (Object[])new Object[0]));
                info.setNotifyType(type);
                msgs.add(info);
            }
            if (!msgs.isEmpty()) {
                MessageCenterServiceHelper.batchSendMessages(msgs);
            } else {
                log.info("msgChannels is empty");
            }
        }
    }
}

