/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.AdminType;
import kd.bos.portal.model.PortalFormShowInfo;
import kd.bos.portal.service.IExtPrivacyStatementService;
import kd.bos.privacy.plugin.upgrade.UpgradeUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ShowUpgradeGuidePlugin
implements IExtPrivacyStatementService {
    private static final Log log = LogFactory.getLog(ShowUpgradeGuidePlugin.class);

    public PortalFormShowInfo getExtPsmtFormShowInfo() {
        if (!UpgradeUtils.isEnableUpgrade()) {
            return null;
        }
        long userId = RequestContext.get().getCurrUserId();
        boolean isSuperAdmin = userId == 1L;
        boolean isBizAdmin = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId(), (AdminType)AdminType.Administrator);
        PortalFormShowInfo showInfo = new PortalFormShowInfo();
        showInfo.setIsShowForm(false);
        if (!isBizAdmin && !isSuperAdmin) {
            return showInfo;
        }
        if (UpgradeUtils.existWaitingExecTask()) {
            showInfo.setIsShowForm(false);
            log.info("exist upgrade_schedule");
            return showInfo;
        }
        List<String> entityNumber = this.getExistEntity();
        SqlBuilder desensSql = new SqlBuilder();
        if (entityNumber.isEmpty()) {
            log.info("filter tag_tpl entityNumber, result is null");
            return null;
        }
        desensSql.append("select fentryid from t_privacy_desen_tpl where fentryid not in (select ftplentryrowid from t_privacy_upgrade_history where fstatus = '1' and fdatatype = '1') and ", new Object[0]).appendIn("fdense_entity_number", entityNumber.toArray());
        boolean exist = (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)desensSql, ResultSet::next);
        if (!exist) {
            SqlBuilder encryptSql = new SqlBuilder();
            encryptSql.append("select fentryid from t_privacy_encrypt_tpl where fentryid not in (select ftplentryrowid from t_privacy_upgrade_history where fstatus = '1' and fdatatype ='2') and ", new Object[0]).appendIn("fencrypt_entity_number", entityNumber.toArray());
            exist = (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)encryptSql, ResultSet::next);
        }
        if (!exist) {
            showInfo.setIsShowForm(false);
            return showInfo;
        }
        if (isSuperAdmin) {
            showInfo.setIsShowForm(true);
            if (UpgradeUtils.existAgreement()) {
                showInfo.setFormId("privacy_autoupgrade");
            } else {
                showInfo.setShowClose(false);
                showInfo.setFormId("privacy_upgradeagreement");
            }
            return showInfo;
        }
        if (isBizAdmin) {
            showInfo.setIsShowForm(true);
            showInfo.setFormId("privacy_upgradetips");
        }
        return showInfo;
    }

    private List<String> getExistEntity() {
        String sql = "select distinct a.fentity_number from t_privacy_data_field_tpl a inner join t_privacy_data_tag_tpl b on a.fid = b.fid where b.ftype = '1'";
        List nums = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            ArrayList<String> entityNumbers = new ArrayList<String>(10);
            while (rs.next()) {
                String num = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)num)) continue;
                entityNumbers.add(num);
            }
            return entityNumbers;
        });
        if (nums.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existsEntityNumber = new ArrayList<String>(nums.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)nums)}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                existsEntityNumber.add(row.getString("number"));
            }
        }
        return existsEntityNumber;
    }
}

