/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.privacy.plugin.upgrade.DataTagFieldRowSetter;
import kd.bos.privacy.plugin.upgrade.HistoryPrivacyUpgradeData;
import kd.bos.privacy.plugin.upgrade.RecordDataType;
import kd.bos.privacy.plugin.upgrade.SchemeDesenEntryRowSetter;
import kd.bos.privacy.plugin.upgrade.SchemeEncryptEntryRowSetter;
import kd.bos.privacy.plugin.upgrade.TaskContainer;
import kd.bos.privacy.plugin.upgrade.TplDataTagFieldRowWarpper;
import kd.bos.privacy.plugin.upgrade.TplSchemeDesenRowWarpper;
import kd.bos.privacy.plugin.upgrade.TplSchemeEncryptRowWarpper;
import kd.bos.privacy.plugin.upgrade.UpgradeUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class SingleHandler {
    private static final Log log = LogFactory.getLog(SingleHandler.class);
    private static final String LOGPREFIX = "##privacyupgrade##";
    private static final String ENTITYNUMBER_TAGTPL = "privacy_data_tags_temp";
    private static final String ENTITYNUMBER_SCHEMETPL = "t_privacy_config_temp";
    private static final String ENTITYNUMBER_TAGDATA = "privacy_data_tags";
    private static final String ENTITYNUMBER_SCHEMECONFIG = "t_privacy_scheme_config";
    private final Long currentTplTagId;
    private final String targetAlgorithm;
    private final Map<String, DynamicObject> changedDataTagObjs = new LinkedHashMap<String, DynamicObject>(3);
    private final Map<String, DynamicObject> changedSchemeObjs = new LinkedHashMap<String, DynamicObject>(3);
    private final List<Object> encryptTaskList = new ArrayList<Object>(10);
    private Map<String, List<HistoryPrivacyUpgradeData>> newInsertHisList = new HashMap<String, List<HistoryPrivacyUpgradeData>>(10);
    private TaskContainer container;
    private AtomicBoolean success = new AtomicBoolean(false);
    private String errorCode = "";
    private Map<String, Long> tagRefSchemeIndex = new HashMap<String, Long>(10);
    private Function<String, Boolean> entityValidator;

    public SingleHandler(Long tplTagId, String tAlgorithm) {
        this.currentTplTagId = tplTagId;
        this.targetAlgorithm = tAlgorithm;
    }

    protected void setContainer(TaskContainer container) {
        this.container = container;
    }

    public void run() {
        this.analyse();
        this.saveChanges();
    }

    protected boolean isSuccess() {
        return this.success.get();
    }

    protected String getErrorCode() {
        return this.errorCode;
    }

    private DynamicObject getOrCreateDataLabelObj(DynamicObject tplTagData, StringBuilder info) {
        DynamicObject dataLableObj;
        List tagPkIds = QueryServiceHelper.queryPrimaryKeys((String)ENTITYNUMBER_TAGDATA, (QFilter[])new QFilter[]{new QFilter("templateid", "=", (Object)this.currentTplTagId)}, null, (int)-1);
        if (!tagPkIds.isEmpty()) {
            Long tagPkId = (Long)tagPkIds.get(0);
            info.append(", found existing tags data , pk is ").append(tagPkId);
            dataLableObj = BusinessDataServiceHelper.loadSingleFromCache((Object)tagPkId, (String)ENTITYNUMBER_TAGDATA);
        } else {
            Long tagPkId = DB.genLongId((String)"t_privacy_data_tag");
            info.append(", create new tags data , pk is ").append(tagPkId);
            dataLableObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNUMBER_TAGDATA);
            dataLableObj.set("id", (Object)tagPkId);
            dataLableObj.set("fnumber", tplTagData.get("fnumber"));
            dataLableObj.set("fname", tplTagData.get("fname"));
            dataLableObj.set("creater_id", (Object)RequestContext.get().getCurrUserId());
            dataLableObj.set("templateid_id", (Object)this.currentTplTagId);
            dataLableObj.set("status", (Object)"C");
            this.changedDataTagObjs.putIfAbsent(dataLableObj.getPkValue().toString(), dataLableObj);
        }
        return dataLableObj;
    }

    private DynamicObject getOrCreateSchemeObj(DynamicObject dataLabelObj, DynamicObject tplScheme, StringBuilder info) {
        Object tagPkId = dataLabelObj.getPkValue();
        DynamicObject schemeConfig = BusinessDataServiceHelper.loadSingle((String)ENTITYNUMBER_SCHEMECONFIG, (QFilter[])new QFilter[]{new QFilter("fdatalabelid", "=", tagPkId)});
        if (schemeConfig == null) {
            schemeConfig = BusinessDataServiceHelper.newDynamicObject((String)ENTITYNUMBER_SCHEMECONFIG);
            schemeConfig.set("id", (Object)DB.genGlobalLongId());
            schemeConfig.set("fscheme_code", tplScheme.get("fscheme_code"));
            schemeConfig.set("fdatalabelid_id", dataLabelObj.getPkValue());
            schemeConfig.set("templateid_id", tplScheme.getPkValue());
            schemeConfig.set("fscheme_name", tplScheme.get("fscheme_name"));
            schemeConfig.set("fscheme_desc", tplScheme.get("fscheme_desc"));
            schemeConfig.set("fscheme_status", (Object)Character.valueOf('0'));
            this.changedSchemeObjs.putIfAbsent(schemeConfig.getPkValue().toString(), schemeConfig);
            info.append(", create new scheme_config , pk is ").append(schemeConfig.getPkValue());
        }
        schemeConfig.set("denselocale", (Object)"default");
        return schemeConfig;
    }

    private Map<String, Set<String>> loadHisRecordByType(RecordDataType type) {
        SqlBuilder hisRecordQuery = new SqlBuilder();
        hisRecordQuery.append("select ftplentryrowid,fentitynumber,fdatatype,ffieldkey,ftablename,ffieldname,flocaleid,fdbroute from t_privacy_upgrade_history where fstatus = '1' and ", new Object[0]).appendIn("fdatatype", (Object[])new String[]{type.getValue()});
        Map fixed = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)hisRecordQuery, rs -> {
            HashMap v = new HashMap(10);
            while (rs.next()) {
                String tplentryrowid = rs.getString("ftplentryrowid");
                String entityNumber = rs.getString("fentitynumber");
                String fieldKey = rs.getString("ffieldkey");
                String tableName = rs.getString("ftablename");
                String fieldName = rs.getString("ffieldname");
                String localeId = rs.getString("flocaleid");
                String route = rs.getString("fdbroute");
                String uniqueKey = "";
                switch (type) {
                    case DESEN: {
                        uniqueKey = this.buildDesenUniqueConsKey(entityNumber, fieldKey, localeId);
                        break;
                    }
                    case DATATAG: {
                        uniqueKey = this.buildTagUniqueConsKey(entityNumber, fieldKey);
                        break;
                    }
                    case ENCRYPT: {
                        uniqueKey = this.buildEncryptUniqueConsKey(entityNumber, fieldKey, tableName, fieldName, route);
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)uniqueKey)) continue;
                v.putIfAbsent(uniqueKey, new HashSet());
                ((Set)v.get(uniqueKey)).add(tplentryrowid);
            }
            return v;
        });
        return fixed;
    }

    private void addHisRecordEntity(HistoryPrivacyUpgradeData data) {
        String type = data.getFdatatype();
        List list = this.newInsertHisList.getOrDefault(type, new ArrayList(10));
        list.add(data);
        this.newInsertHisList.put(type, list);
    }

    private Map<String, Map<String, Object>> loadOtherDesenDatas(Long excludeSchemeId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,fentryid,fdense_field_ident,fdense_entity_number,fdesensitize_rule,fdensefieldlocale from t_privacy_scheme_desen", new Object[0]).append(" where fid <> ?", (Object[])new SqlParameter[]{new SqlParameter(":FID", -5, (Object)excludeSchemeId)});
        Map existDesenConfig = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)builder, rs -> {
            HashMap v = new HashMap(10);
            while (rs.next()) {
                Long schemeId = rs.getLong("fid");
                String entityNumber = rs.getString("fdense_entity_number");
                String fieldKey = rs.getString("fdense_field_ident");
                String ruleId = rs.getString("fdesensitize_rule");
                String localeId = rs.getString("fdensefieldlocale");
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("schemeId", schemeId);
                info.put("entityNumber", entityNumber);
                info.put("fieldKey", fieldKey);
                info.put("ruleId", ruleId);
                info.put("fentryid", rs.getLong("fentryid"));
                v.put(this.buildDesenUniqueConsKey(entityNumber, fieldKey, localeId), info);
            }
            return v;
        });
        return existDesenConfig;
    }

    private Map<String, Map<String, Object>> loadOtherEncryptIndexDatas(Long excludeSchemeId) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fid,fentryid,fencrypt_field_name,fencrypt_table_name,fencrypt_algorithm,fapp_route from t_privacy_scheme_encrypt", new Object[0]).append(" where fid <> ?", (Object[])new SqlParameter[]{new SqlParameter(":FID", -5, (Object)excludeSchemeId)});
        Map existDesenConfig = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)builder, rs -> {
            HashMap v = new HashMap(10);
            while (rs.next()) {
                Long schemeId = rs.getLong("fid");
                String tableName = rs.getString("fencrypt_table_name");
                String fieldName = rs.getString("fencrypt_field_name");
                String algorithm = rs.getString("fencrypt_algorithm");
                String appRoute = rs.getString("fapp_route");
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("schemeId", schemeId);
                info.put("tableName", tableName);
                info.put("fieldName", fieldName);
                info.put("algorithm", algorithm);
                info.put("approute", appRoute);
                info.put("fentryid", rs.getLong("fentryid"));
                v.put(this.buildEncryptIndexKey(tableName, fieldName, appRoute), info);
            }
            return v;
        });
        return existDesenConfig;
    }

    private void assembleDataLabelObjs(DynamicObject dataLableObj, Map<String, Set<String>> hisRecords, DynamicObject tplTagData, Long tplSchemePK, Long schemeConfigPk) {
        HashMap<String, Long> existTagField = new HashMap<String, Long>(10);
        HashSet<String> distinctTagFields = new HashSet<String>(10);
        DynamicObjectCollection dataLableCols = dataLableObj.getDynamicObjectCollection("ffeildsentry");
        dataLableCols.forEach(t -> {
            String fieldKey = t.getString("ffield_ident");
            String entityNumber = t.getString("fentity_number");
            distinctTagFields.add(this.buildTagUniqueConsKey(entityNumber, fieldKey));
        });
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fentity_number,ffield_ident,fid from t_privacy_data_tag_fields where fid != ?", new Object[]{new SqlParameter(":fid", -5, dataLableObj.getPkValue())});
        DataSet ds = DB.queryDataSet((String)"PrivacyUpgrade", (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sql);
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                String key = this.buildTagUniqueConsKey(row.getString("fentity_number"), row.getString("ffield_ident"));
                existTagField.put(key, row.getLong("fid"));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap duplicateTagFields = new HashMap(10);
        for (DynamicObject it : tplTagData.getDynamicObjectCollection("t_privacy_data_field_temp")) {
            TplDataTagFieldRowWarpper warpper = new TplDataTagFieldRowWarpper(it);
            if (!this.entityValidator.apply(warpper.getEntityNumber()).booleanValue()) {
                log.info("the entity does not exist, and the current row data is not processed," + warpper);
                continue;
            }
            String string = this.buildTagUniqueConsKey(warpper.getEntityNumber(), warpper.getFieldKey());
            HistoryPrivacyUpgradeData historyData = this.createHistoryRecord(RecordDataType.DATATAG, warpper.getAppRoute(), warpper.getTableName(), warpper.getEntityNumber(), warpper.getFieldKey(), warpper.getFieldName(), schemeConfigPk, tplSchemePK, (Long)it.getPkValue(), (Long)dataLableObj.getPkValue(), "");
            Set<String> hisEntryPks = hisRecords.get(string);
            if (hisEntryPks != null && hisEntryPks.size() > 0) {
                log.info(String.format("%s, create new scheme_config , pk is %s", LOGPREFIX, schemeConfigPk));
                if (hisEntryPks.contains(it.getPkValue().toString())) continue;
                this.addHisRecordEntity(historyData);
                continue;
            }
            this.addHisRecordEntity(historyData);
            Long refTag = (Long)existTagField.get(string);
            if (refTag != null) {
                duplicateTagFields.putIfAbsent(refTag, new HashMap(3));
                ((Map)duplicateTagFields.get(refTag)).putIfAbsent(string, warpper);
                continue;
            }
            if (distinctTagFields.contains(string)) {
                log.info(String.format("%s, exist duplicate data in tag template , identity is %s", LOGPREFIX, string));
            } else {
                DynamicObject newFieldRow = dataLableObj.getDynamicObjectCollection("ffeildsentry").addNew();
                this.setSeq(newFieldRow, dataLableObj.getDynamicObjectCollection("ffeildsentry").size());
                DataTagFieldRowSetter setter = new DataTagFieldRowSetter(newFieldRow);
                setter.fill(warpper);
                this.changedDataTagObjs.putIfAbsent(dataLableObj.getPkValue().toString(), dataLableObj);
                log.info("new label line,info=" + warpper);
            }
            distinctTagFields.add(string);
        }
        if (!duplicateTagFields.isEmpty()) {
            String entityNumber;
            HashSet<Long> schemePks = new HashSet<Long>(duplicateTagFields.size());
            DataSet refIdDs = QueryServiceHelper.queryDataSet((String)"PrivacyUpgrade", (String)ENTITYNUMBER_SCHEMECONFIG, (String)"id", (QFilter[])new QFilter[]{new QFilter("fdatalabelid", "in", (Object)duplicateTagFields.keySet().toArray())}, null);
            Object object2 = null;
            try {
                while (refIdDs.hasNext()) {
                    Row row = refIdDs.next();
                    Long refSchemeId = row.getLong("id");
                    schemePks.add(refSchemeId);
                }
            }
            catch (Throwable object3) {
                object2 = object3;
                throw object3;
            }
            finally {
                if (refIdDs != null) {
                    if (object2 != null) {
                        try {
                            refIdDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        refIdDs.close();
                    }
                }
            }
            if (!schemePks.isEmpty()) {
                DynamicObject[] refSchemeObjs = BusinessDataServiceHelper.load((Object[])schemePks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITYNUMBER_SCHEMECONFIG));
                for (DynamicObject it : refSchemeObjs) {
                    Object row2;
                    Long refSchemeId = it.getLong("id");
                    Long refTagId = it.getLong("fdatalabelid_id");
                    Map datas = duplicateTagFields.getOrDefault(refTagId, new HashMap(3));
                    if (datas.isEmpty()) continue;
                    DynamicObjectCollection desenCols = it.getDynamicObjectCollection("t_privacy_scheme_desen");
                    for (Object row2 : desenCols) {
                        String fieldKey;
                        String entityNumber2 = row2.getString("fdense_entity_number");
                        String uniqueId = this.buildTagUniqueConsKey(entityNumber2, fieldKey = row2.getString("fdense_field_ident"));
                        TplDataTagFieldRowWarpper warpper = (TplDataTagFieldRowWarpper)datas.remove(uniqueId);
                        if (warpper == null) continue;
                        this.tagRefSchemeIndex.put(uniqueId, refSchemeId);
                    }
                    if (datas.isEmpty()) continue;
                    DynamicObjectCollection encryptCols = it.getDynamicObjectCollection("t_privacy_scheme_encrypt");
                    row2 = encryptCols.iterator();
                    while (row2.hasNext()) {
                        String fieldKey;
                        DynamicObject row3 = (DynamicObject)row2.next();
                        entityNumber = row3.getString("fencrypt_entity_number");
                        String uniqueId = this.buildTagUniqueConsKey(entityNumber, fieldKey = row3.getString("fencrypt_field_ident"));
                        TplDataTagFieldRowWarpper warpper = (TplDataTagFieldRowWarpper)datas.remove(uniqueId);
                        if (warpper == null) continue;
                        this.tagRefSchemeIndex.put(uniqueId, refSchemeId);
                    }
                }
            }
            if (!duplicateTagFields.isEmpty()) {
                DynamicObject[] tagObjs = BusinessDataServiceHelper.load((Object[])duplicateTagFields.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITYNUMBER_TAGDATA));
                for (DynamicObject it : tagObjs) {
                    Long id = (Long)it.getPkValue();
                    Map removeDatas = (Map)duplicateTagFields.get(id);
                    if (removeDatas.isEmpty()) continue;
                    DynamicObjectCollection cols = it.getDynamicObjectCollection("ffeildsentry");
                    ArrayList<DynamicObject> toDelRows = new ArrayList<DynamicObject>();
                    for (DynamicObject row2 : cols) {
                        String fieldKey = row2.getString("ffield_ident");
                        entityNumber = row2.getString("fentity_number");
                        if (!removeDatas.containsKey(this.buildTagUniqueConsKey(entityNumber, fieldKey))) continue;
                        toDelRows.add(row2);
                    }
                    if (toDelRows.isEmpty()) continue;
                    toDelRows.forEach(t -> cols.remove(t));
                    this.changedDataTagObjs.put(it.getPkValue().toString(), it);
                }
                for (Map.Entry entry : duplicateTagFields.entrySet()) {
                    for (Map.Entry subIt : ((Map)entry.getValue()).entrySet()) {
                        DynamicObject newFieldRow = dataLableObj.getDynamicObjectCollection("ffeildsentry").addNew();
                        this.setSeq(newFieldRow, dataLableObj.getDynamicObjectCollection("ffeildsentry").size());
                        DataTagFieldRowSetter setter = new DataTagFieldRowSetter(newFieldRow);
                        setter.fill((TplDataTagFieldRowWarpper)subIt.getValue());
                        this.changedDataTagObjs.putIfAbsent(dataLableObj.getPkValue().toString(), dataLableObj);
                        log.info("new label line,info=" + subIt.getValue());
                    }
                }
            }
        }
    }

    private void analyse() {
        List<String> existEntityNumbers = this.getExistEntity();
        if (existEntityNumbers.isEmpty()) {
            log.info("{} tplTagId={},the related entity does not exist and does not process template data", (Object)LOGPREFIX, (Object)this.currentTplTagId);
            return;
        }
        StringBuilder info = new StringBuilder();
        info.append(LOGPREFIX).append(" tplTagId=").append(this.currentTplTagId);
        this.entityValidator = s -> existEntityNumbers.contains(s);
        DynamicObject tplTagData = BusinessDataServiceHelper.loadSingle((Object)this.currentTplTagId, (String)ENTITYNUMBER_TAGTPL);
        DynamicObject dataLableObj = this.getOrCreateDataLabelObj(tplTagData, info);
        List pkids = QueryServiceHelper.queryPrimaryKeys((String)ENTITYNUMBER_SCHEMETPL, (QFilter[])new QFilter[]{new QFilter("fdatalabelid", "=", (Object)this.currentTplTagId)}, null, (int)-1);
        DynamicObject tplScheme = null;
        if (!pkids.isEmpty()) {
            tplScheme = BusinessDataServiceHelper.loadSingle(pkids.get(0), (String)ENTITYNUMBER_SCHEMETPL);
        }
        if (tplScheme == null) {
            HashMap<String, Object> logDetail = new HashMap<String, Object>(2);
            logDetail.put("templateTagId", this.currentTplTagId);
            logDetail.put("msg", "no exist system privacy scheme config");
            String logMsg = SerializationUtils.toJsonString(logDetail);
            UpgradeUtils.addOpLog(ENTITYNUMBER_SCHEMECONFIG, "autoUpgrade", "autoUpgrade-" + this.currentTplTagId, logMsg);
            throw new RuntimeException(logMsg);
        }
        info.append(", load scheme template , pk is ").append(tplScheme.getPkValue());
        DynamicObject schemeConfig = this.getOrCreateSchemeObj(dataLableObj, tplScheme, info);
        this.assembleDataLabelObjs(dataLableObj, this.loadHisRecordByType(RecordDataType.DATATAG), tplTagData, (Long)tplScheme.getPkValue(), (Long)schemeConfig.getPkValue());
        this.autoSetPrimaryKey(dataLableObj, (MainEntityType)dataLableObj.getDataEntityType());
        info.append(", other label association information,info=").append(this.tagRefSchemeIndex);
        log.info(info.toString());
        HashMap<String, Long> desenTagRowIdIndex = new HashMap<String, Long>(10);
        HashMap<String, Long> encryptTagRowIdIndex = new HashMap<String, Long>(10);
        HashSet<String> distinctTagFields = new HashSet<String>(10);
        DynamicObjectCollection dataLableCols = dataLableObj.getDynamicObjectCollection("ffeildsentry");
        dataLableCols.forEach(t -> {
            String tableName = t.getString("ftable_name");
            String fieldName = t.getString("ffield_name");
            String fieldKey = t.getString("ffield_ident");
            String entityNumber = t.getString("fentity_number");
            String dbroute = t.getString("approute");
            Long entryId = (Long)t.getPkValue();
            desenTagRowIdIndex.putIfAbsent(this.buildTagUniqueConsKey(entityNumber, fieldKey), entryId);
            encryptTagRowIdIndex.putIfAbsent(this.buildEncryptUniqueConsKey(entityNumber, fieldKey, tableName, fieldName, dbroute), entryId);
            distinctTagFields.add(this.buildTagUniqueConsKey(entityNumber, fieldKey));
        });
        this.assembleDesenEntryData(schemeConfig, tplScheme, dataLableObj, this.loadHisRecordByType(RecordDataType.DESEN), distinctTagFields, desenTagRowIdIndex);
        this.assembleEncryptEntryData(schemeConfig, tplScheme, dataLableObj, this.loadHisRecordByType(RecordDataType.ENCRYPT), distinctTagFields, encryptTagRowIdIndex);
    }

    private void assembleDesenEntryData(DynamicObject schemeConfig, DynamicObject tplScheme, DynamicObject dataLabelObj, Map<String, Set<String>> hisDesens, Set<String> distinctTagFields, Map<String, Long> desenTagRowIdIndex) {
        DynamicObject[] otherSchemes;
        DynamicObjectCollection tplDesenCols = tplScheme.getDynamicObjectCollection("t_privacy_desen_template");
        String qtPkid = "";
        HashSet<String> desenRuleIds = new HashSet<String>(10);
        String noRulePkid = "";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PrivacyUpgrade", (String)"privacy_desen_rules", (String)"id,number", null, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String ruleNumber = row.getString("number");
                if ("QT".equals(ruleNumber)) {
                    qtPkid = row.getString("id");
                } else if ("NO".equals(ruleNumber)) {
                    noRulePkid = row.getString("id");
                }
                desenRuleIds.add(row.getString("id"));
            }
        }
        desenRuleIds.add("NO");
        desenRuleIds.add("QT");
        desenRuleIds.add("FL");
        desenRuleIds.add("GD");
        desenRuleIds.add("FOLLOW");
        desenRuleIds.add("TP");
        desenRuleIds.add("NM");
        desenRuleIds.add("IDCARD");
        desenRuleIds.add("BC");
        Map<String, Map<String, Object>> existDesenConfig = this.loadOtherDesenDatas((Long)schemeConfig.getPkValue());
        HashSet<String> distinctEntryRows = new HashSet<String>(10);
        schemeConfig.getDynamicObjectCollection("t_privacy_scheme_desen").forEach(t -> {
            String itEntityNum = t.getString("fdense_entity_number");
            String itFieldkey = t.getString("fdense_field_ident");
            String itLocaleId = t.getString("fdensefieldlocale");
            distinctEntryRows.add(this.buildDesenUniqueConsKey(itEntityNum, itFieldkey, itLocaleId));
        });
        HashMap other = new HashMap(10);
        for (DynamicObject it : tplDesenCols) {
            Long refScheme;
            TplSchemeDesenRowWarpper warpper = new TplSchemeDesenRowWarpper(it);
            if (!this.entityValidator.apply(warpper.getEntityNumber()).booleanValue()) {
                log.info("the entity does not exist and the current number of rows is not processed," + warpper);
                continue;
            }
            String desenIdentity = this.buildDesenUniqueConsKey(warpper.getEntityNumber(), warpper.getFieldKey(), warpper.getLocaleId());
            String tagIdentity = this.buildTagUniqueConsKey(warpper.getEntityNumber(), warpper.getFieldKey());
            HistoryPrivacyUpgradeData historyData = this.createHistoryRecord(RecordDataType.DESEN, "", warpper.getTableName(), warpper.getEntityNumber(), warpper.getFieldKey(), warpper.getFieldName(), (Long)schemeConfig.getPkValue(), (Long)tplScheme.getPkValue(), (Long)it.getPkValue(), (Long)dataLabelObj.getPkValue(), warpper.getLocaleId());
            Set<String> hisEntryPks = hisDesens.get(desenIdentity);
            if (hisEntryPks != null && hisEntryPks.size() > 0) {
                log.info(String.format("%s, skip desen entryrow data ,because history has been processed  , identity is %s , row info is %s", LOGPREFIX, desenIdentity, warpper));
                if (hisEntryPks.contains(it.getPkValue().toString())) continue;
                this.addHisRecordEntity(historyData);
                continue;
            }
            this.addHisRecordEntity(historyData);
            String ruleId = warpper.getFdesensitizeRule();
            if (!desenRuleIds.contains(ruleId)) {
                ruleId = qtPkid;
                log.info(String.format("%s replace qtpkId, orgin is %s , info is %s", LOGPREFIX, ruleId, warpper));
            }
            if ((refScheme = this.tagRefSchemeIndex.get(tagIdentity)) != null) {
                other.putIfAbsent(refScheme, new ArrayList(10));
                ((List)other.get(refScheme)).add(warpper);
                continue;
            }
            if (!distinctTagFields.contains(tagIdentity) || existDesenConfig.get(desenIdentity) != null) {
                throw new RuntimeException("tplscheme error, info : " + warpper);
            }
            if (distinctEntryRows.contains(desenIdentity)) {
                log.info("scheme template repeat desensitized entry data,info = " + warpper);
                continue;
            }
            distinctEntryRows.add(desenIdentity);
            DynamicObjectCollection denseRows = schemeConfig.getDynamicObjectCollection("t_privacy_scheme_desen");
            DynamicObject row = denseRows.addNew();
            this.setSeq(row, denseRows.size());
            SchemeDesenEntryRowSetter setter = new SchemeDesenEntryRowSetter(row);
            setter.fill(warpper);
            setter.setDesenLabelId(desenTagRowIdIndex.get(tagIdentity));
            setter.setDesenRuleBaseDataPk(ruleId);
            this.changedSchemeObjs.putIfAbsent(schemeConfig.getPkValue().toString(), schemeConfig);
        }
        if (other.isEmpty()) {
            return;
        }
        for (DynamicObject it : otherSchemes = BusinessDataServiceHelper.load((Object[])other.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITYNUMBER_SCHEMECONFIG))) {
            it.set("denselocale", (Object)"default");
            List warpperLists = other.getOrDefault(it.getPkValue(), new ArrayList(10));
            if (warpperLists.isEmpty()) continue;
            DynamicObject targetObjs = this.changedSchemeObjs.get(it.getPkValue().toString());
            if (targetObjs == null) {
                targetObjs = it;
            }
            this.updateOtherDesenConfig(targetObjs, warpperLists, desenRuleIds, qtPkid, noRulePkid);
        }
    }

    private void assembleEncryptEntryData(DynamicObject schemeConfig, DynamicObject tplScheme, DynamicObject dataLabelObj, Map<String, Set<String>> hisEncrypts, Set<String> distinctTagFields, Map<String, Long> encryptTagRowIdIndex) {
        DynamicObjectCollection tplEncryptCols = tplScheme.getDynamicObjectCollection("t_privacy_encrypt_temp");
        Map<String, Map<String, Object>> existEncryptIndex = this.loadOtherEncryptIndexDatas((Long)schemeConfig.getPkValue());
        HashSet<String> distinctEntryRows = new HashSet<String>(10);
        schemeConfig.getDynamicObjectCollection("t_privacy_scheme_encrypt").forEach(t -> {
            String itRoute = t.getString("approute");
            String itTableName = t.getString("fencrypt_table_name");
            String itFieldName = t.getString("fencrypt_field_name");
            String itEntityNumber = t.getString("fencrypt_entity_number");
            String itFieldKey = t.getString("fencrypt_field_ident");
            distinctEntryRows.add(this.buildEncryptUniqueConsKey(itEntityNumber, itFieldKey, itTableName, itFieldName, itRoute));
        });
        HashMap other = new HashMap(10);
        for (DynamicObject it : tplEncryptCols) {
            boolean needEncrypt;
            TplSchemeEncryptRowWarpper warpper = new TplSchemeEncryptRowWarpper(it);
            if (!this.entityValidator.apply(warpper.getEntityNumber()).booleanValue()) {
                log.info("the entity does not exist and the current number of rows is not processed," + warpper);
                continue;
            }
            String tableName = warpper.getTableName();
            String fieldName = warpper.getFieldName();
            String entityNumber = warpper.getEntityNumber();
            String fieldKey = warpper.getFieldKey();
            String encryptIdentity = this.buildEncryptUniqueConsKey(entityNumber, fieldKey, tableName, fieldName, warpper.getAppRoute());
            String encryptIndex = this.buildEncryptIndexKey(tableName, fieldName, warpper.getAppRoute());
            String tagIdentity = this.buildTagUniqueConsKey(entityNumber, fieldKey);
            HistoryPrivacyUpgradeData historyData = this.createHistoryRecord(RecordDataType.ENCRYPT, warpper.getAppRoute(), tableName, warpper.getEntityNumber(), warpper.getFieldKey(), fieldName, (Long)schemeConfig.getPkValue(), (Long)tplScheme.getPkValue(), (Long)it.getPkValue(), (Long)dataLabelObj.getPkValue(), "");
            Set<String> hisEntryPks = hisEncrypts.get(encryptIdentity);
            if (hisEntryPks != null && hisEntryPks.size() > 0) {
                log.info(String.format("%s, skip encrypt entryrow data ,because history has been processed  , row is %s", LOGPREFIX, warpper));
                if (hisEntryPks.contains(it.getPkValue().toString())) continue;
                this.addHisRecordEntity(historyData);
                continue;
            }
            this.addHisRecordEntity(historyData);
            Long refScheme = this.tagRefSchemeIndex.get(tagIdentity);
            if (refScheme != null) {
                other.putIfAbsent(refScheme, new ArrayList(10));
                ((List)other.get(refScheme)).add(warpper);
                continue;
            }
            if (!distinctTagFields.contains(tagIdentity)) {
                throw new RuntimeException("scheme error,info=" + warpper);
            }
            if (distinctEntryRows.contains(encryptIdentity)) {
                log.info("duplicate encryption of entry data, no processing, info=" + warpper);
                continue;
            }
            StringBuilder info = new StringBuilder();
            info.append("add upgradescheme encrypt row,").append(warpper);
            distinctEntryRows.add(encryptIdentity);
            DynamicObjectCollection encryptRows = schemeConfig.getDynamicObjectCollection("t_privacy_scheme_encrypt");
            DynamicObject row = encryptRows.addNew();
            this.setSeq(row, encryptRows.size());
            SchemeEncryptEntryRowSetter setter = new SchemeEncryptEntryRowSetter(row);
            setter.fill(warpper);
            Long tagEntryRowId = encryptTagRowIdIndex.get(encryptIdentity);
            info.append(String.format(", added encrypted entries, tagentryid=%s, info =%s", tagEntryRowId, warpper));
            setter.setEncryptLabelId(tagEntryRowId);
            Map<String, Object> existInfo = existEncryptIndex.get(encryptIndex);
            String tplEncryptCfg = warpper.getEncryptAlgorithm();
            boolean bl = needEncrypt = StringUtils.isNotBlank((CharSequence)tplEncryptCfg) && !StringUtils.equalsIgnoreCase((CharSequence)"NO", (CharSequence)tplEncryptCfg);
            if (existInfo != null) {
                setter.setEncryptStatus("1");
                setter.setEncryptVersion(1);
                info.append(", the same field has been configured in other schemes,").append(existInfo);
                String otherAlgorithm = (String)existInfo.get("algorithm");
                if (needEncrypt) {
                    boolean otherIsEncrypt = StringUtils.isNotBlank((CharSequence)otherAlgorithm) && !StringUtils.equals((CharSequence)otherAlgorithm, (CharSequence)"NO");
                    String target = otherIsEncrypt ? otherAlgorithm : this.targetAlgorithm;
                    setter.setEncryptStatus(otherIsEncrypt ? "1" : "0");
                    setter.setEncryptAlgorithm(target);
                } else {
                    info.append(", the same field has been configured in other schemes");
                    setter.setEncryptAlgorithm(existInfo.get("algorithm"));
                }
            } else {
                setter.setEncryptStatus("0");
                setter.setEncryptVersion(1);
                setter.setEncryptAlgorithm(needEncrypt ? this.targetAlgorithm : "NO");
            }
            this.changedSchemeObjs.putIfAbsent(schemeConfig.getPkValue().toString(), schemeConfig);
            log.info(info.toString());
        }
        if (other.isEmpty()) {
            return;
        }
        DynamicObject[] otherSchemes = BusinessDataServiceHelper.load((Object[])other.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITYNUMBER_SCHEMECONFIG));
        log.info("---modify other schemes---");
        for (DynamicObject it : otherSchemes) {
            List warpperLists = other.getOrDefault(it.getPkValue(), new ArrayList(10));
            if (warpperLists.isEmpty()) continue;
            DynamicObject targetObj = this.changedSchemeObjs.get(it.getPkValue().toString());
            if (targetObj == null) {
                targetObj = it;
            }
            this.updateOtherEncryptConfig(targetObj, warpperLists);
        }
    }

    private void updateOtherDesenConfig(DynamicObject object, List<TplSchemeDesenRowWarpper> warpperLists, Set<String> allRuleIds, String replaceRuleId, String noRuleId) {
        String newRuleId;
        HashMap warpperMap = new HashMap(warpperLists.size());
        warpperLists.forEach(t -> warpperMap.put(this.buildDesenUniqueConsKey(t.getEntityNumber(), t.getFieldKey(), t.getLocaleId()), t));
        DynamicObjectCollection denseRows = object.getDynamicObjectCollection("t_privacy_scheme_desen");
        boolean changed = false;
        for (DynamicObject row : denseRows) {
            String entityNumber = row.getString("fdense_entity_number");
            String fieldKey = row.getString("fdense_field_ident");
            String localeId = row.getString("fdensefieldlocale");
            String ruleId = row.getString("fdesen_rule_basedata_id");
            String uniqueId = this.buildDesenUniqueConsKey(entityNumber, fieldKey, localeId);
            TplSchemeDesenRowWarpper warpper = (TplSchemeDesenRowWarpper)warpperMap.remove(uniqueId);
            if (warpper == null || !StringUtils.equals((CharSequence)ruleId, (CharSequence)noRuleId) && !StringUtils.equals((CharSequence)ruleId, (CharSequence)"NO")) continue;
            newRuleId = warpper.getFdesensitizeRule();
            if (!allRuleIds.contains(newRuleId)) {
                newRuleId = replaceRuleId;
            }
            row.set("fdesen_rule_basedata_id", (Object)newRuleId);
            changed = true;
        }
        if (!warpperMap.isEmpty()) {
            DynamicObject tagObj = BusinessDataServiceHelper.loadSingle((Object)object.getLong("fdatalabelid_id"), (String)ENTITYNUMBER_TAGDATA);
            DynamicObjectCollection tagFieldcols = tagObj.getDynamicObjectCollection("ffeildsentry");
            HashMap index = new HashMap(10);
            tagFieldcols.forEach(t -> {
                String fieldKey = t.getString("ffield_ident");
                String entityNumber = t.getString("fentity_number");
                index.put(this.buildTagUniqueConsKey(entityNumber, fieldKey), (Long)t.getPkValue());
            });
            for (Map.Entry it : warpperMap.entrySet()) {
                String tagIdentity = this.buildTagUniqueConsKey(((TplSchemeDesenRowWarpper)it.getValue()).getEntityNumber(), ((TplSchemeDesenRowWarpper)it.getValue()).getFieldKey());
                DynamicObject row = denseRows.addNew();
                this.setSeq(row, denseRows.size());
                SchemeDesenEntryRowSetter setter = new SchemeDesenEntryRowSetter(row);
                setter.fill((TplSchemeDesenRowWarpper)it.getValue());
                newRuleId = ((TplSchemeDesenRowWarpper)it.getValue()).getFdesensitizeRule();
                if (!allRuleIds.contains(newRuleId)) {
                    newRuleId = replaceRuleId;
                }
                Long tagEntryRowId = (Long)index.get(tagIdentity);
                log.info(String.format("added desensitized line data,scheme %s,tagrow %s,info: %s", object.getPkValue(), tagEntryRowId, it.getValue()));
                setter.setDesenLabelId(tagEntryRowId);
                setter.setDesenRuleBaseDataPk(newRuleId);
                changed = true;
            }
        }
        if (changed) {
            BusinessDataServiceHelper.loadRefence((Object[])new DynamicObject[]{object}, (IDataEntityType)object.getDataEntityType());
            this.changedSchemeObjs.putIfAbsent(object.getPkValue().toString(), object);
        }
    }

    private void updateOtherEncryptConfig(DynamicObject object, List<TplSchemeEncryptRowWarpper> warpperLists) {
        log.info("match to update other schemes,schemeid = " + object.getPkValue() + ",info=" + warpperLists);
        HashMap warpperMap = new HashMap(warpperLists.size());
        warpperLists.forEach(t -> warpperMap.put(this.buildEncryptUniqueConsKey(t.getEntityNumber(), t.getFieldKey(), t.getTableName(), t.getFieldName(), t.getAppRoute()), t));
        DynamicObjectCollection encryptRows = object.getDynamicObjectCollection("t_privacy_scheme_encrypt");
        boolean changed = false;
        for (DynamicObject row : encryptRows) {
            boolean needEncrypt;
            String entityNumber = row.getString("fencrypt_entity_number");
            String fieldKey = row.getString("fencrypt_field_ident");
            String tableName = row.getString("fencrypt_table_name");
            String fieldName = row.getString("fencrypt_field_name");
            String algorithm = row.getString("fencrypt_algorithm");
            String dbroute = row.getString("approute");
            String index = this.buildEncryptUniqueConsKey(entityNumber, fieldKey, tableName, fieldName, dbroute);
            TplSchemeEncryptRowWarpper warpper = (TplSchemeEncryptRowWarpper)warpperMap.remove(index);
            if (warpper == null) continue;
            String tplEncryptCfg = warpper.getEncryptAlgorithm();
            boolean bl = needEncrypt = (StringUtils.isBlank((CharSequence)algorithm) || StringUtils.equals((CharSequence)"NO", (CharSequence)algorithm)) && StringUtils.isNotBlank((CharSequence)tplEncryptCfg) && !StringUtils.equalsIgnoreCase((CharSequence)"NO", (CharSequence)tplEncryptCfg);
            if (needEncrypt) {
                row.set("fencrypt_status", (Object)"0");
                row.set("fencrypt_version", (Object)1);
                row.set("fencrypt_algorithm", (Object)this.targetAlgorithm);
                changed = true;
                log.info("match updates to encrypted entries in other schemes," + warpper);
                continue;
            }
            log.info("Skip processing,encryption entries in other schemes are configured to be encrypted," + warpper);
        }
        if (!warpperMap.isEmpty()) {
            DynamicObject tagObj = BusinessDataServiceHelper.loadSingle((Object)object.getLong("fdatalabelid_id"), (String)ENTITYNUMBER_TAGDATA);
            DynamicObjectCollection tagFieldcols = tagObj.getDynamicObjectCollection("ffeildsentry");
            HashMap tagEntryRowIdIndex = new HashMap(10);
            tagFieldcols.forEach(t -> {
                String itTableName = t.getString("ftable_name");
                String itFieldName = t.getString("ffield_name");
                String itFieldKey = t.getString("ffield_ident");
                String itEntityNumber = t.getString("fentity_number");
                String itDbroute = t.getString("approute");
                tagEntryRowIdIndex.put(this.buildEncryptUniqueConsKey(itEntityNumber, itFieldKey, itTableName, itFieldName, itDbroute), (Long)t.getPkValue());
            });
            for (Map.Entry it : warpperMap.entrySet()) {
                TplSchemeEncryptRowWarpper warpper = (TplSchemeEncryptRowWarpper)it.getValue();
                DynamicObject row = encryptRows.addNew();
                this.setSeq(row, encryptRows.size());
                SchemeEncryptEntryRowSetter setter = new SchemeEncryptEntryRowSetter(row);
                setter.fill((TplSchemeEncryptRowWarpper)it.getValue());
                String tplEncryptCfg = warpper.getEncryptAlgorithm();
                boolean needEncrypt = StringUtils.isNotBlank((CharSequence)tplEncryptCfg) && !StringUtils.equalsIgnoreCase((CharSequence)"NO", (CharSequence)tplEncryptCfg);
                setter.setEncryptStatus(needEncrypt ? "0" : "1");
                setter.setEncryptVersion(1);
                setter.setEncryptLabelId(tagEntryRowIdIndex.get(this.buildEncryptUniqueConsKey(warpper.getEntityNumber(), warpper.getFieldKey(), warpper.getTableName(), warpper.getFieldName(), warpper.getAppRoute())));
                setter.setEncryptAlgorithm(needEncrypt ? this.targetAlgorithm : "NO");
                changed = true;
                log.info("added encryption entries for other schemes," + warpper);
            }
        }
        if (changed) {
            object.set("denselocale", (Object)"default");
            this.changedSchemeObjs.putIfAbsent(object.getPkValue().toString(), object);
        }
    }

    private void setSeq(DynamicObject object, int seq) {
        if (object == null || object.getDynamicObjectType() == null) {
            return;
        }
        if (object.getDynamicObjectType().getProperty("seq") != null) {
            object.set("seq", (Object)seq);
        }
    }

    private void saveChanges() {
        try (TXHandle h = TX.required();){
            boolean tagResult = this.saveDataTag();
            if (tagResult) {
                this.saveAndPublishScheme();
            }
        }
    }

    protected List<Object> getPrivacyTaskIds() {
        return this.encryptTaskList;
    }

    private boolean saveDataTag() {
        DynamicObject[] tagObjs = this.changedDataTagObjs.values().toArray(new DynamicObject[this.changedDataTagObjs.size()]);
        boolean success = true;
        for (DynamicObject obj : tagObjs) {
            if (obj == null) continue;
            OperateOption option = OperateOption.create();
            option.setVariableValue("appnumber", "privacy");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITYNUMBER_TAGDATA, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)option);
            if (result.isSuccess()) continue;
            success = false;
        }
        if (success) {
            this.saveHisRecord(RecordDataType.DATATAG);
        } else {
            this.errorCode = "002";
        }
        return success;
    }

    private void saveAllHisRecord() {
        if (this.newInsertHisList.isEmpty()) {
            return;
        }
        ArrayList<HistoryPrivacyUpgradeData> datas = new ArrayList<HistoryPrivacyUpgradeData>(10);
        this.newInsertHisList.forEach((k, v) -> datas.addAll((Collection<HistoryPrivacyUpgradeData>)v));
        this.save(datas);
    }

    private void saveHisRecord(RecordDataType type) {
        if (this.newInsertHisList.isEmpty()) {
            return;
        }
        List<HistoryPrivacyUpgradeData> datas = this.newInsertHisList.remove(type.getValue());
        if (datas != null && datas.size() > 0) {
            this.save(datas);
        }
    }

    private void save(List<HistoryPrivacyUpgradeData> datas) {
        String sql = "insert into t_privacy_upgrade_history(fid,fentitynumber,ffieldkey,ftablename,ffieldname,fdbroute,fschematplid,ftagtplid,fdatatype,ftplentryrowid,ftagid,fschemaid,fcreatetime,fmodifytime,fcreatorid,fmodifierid,fstatus,flocaleid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>(datas.size());
        long[] ids = DB.genGlobalLongIds((int)datas.size());
        int i = 0;
        for (HistoryPrivacyUpgradeData it : datas) {
            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)ids[i++]), new SqlParameter(":fentitynumber", 12, (Object)it.getFentitynumber()), new SqlParameter(":ffieldkey", 12, (Object)it.getFfieldkey()), new SqlParameter(":ftablename", 12, (Object)it.getFtablename()), new SqlParameter(":ffieldname", 12, (Object)it.getFfieldname()), new SqlParameter(":fdbroute", 12, (Object)it.getFdbroute()), new SqlParameter(":fschematplid", -5, (Object)it.getFschematplid()), new SqlParameter(":ftagtplid", -5, (Object)it.getFtagtplid()), new SqlParameter(":fdatatype", 1, (Object)it.getFdatatype()), new SqlParameter(":ftplentryrowid", -5, (Object)it.getFtplentryrowid()), new SqlParameter(":ftagid", -5, (Object)it.getFtagid()), new SqlParameter(":fschemaid", -5, (Object)it.getFschemaid()), new SqlParameter(":fcreatetime", 93, (Object)it.getFcreatetime()), new SqlParameter(":fmodifytime", 93, (Object)it.getFmodifytime()), new SqlParameter(":fcreatorid", -5, (Object)it.getFcreatorid()), new SqlParameter(":fmodifierid", -5, (Object)it.getFmodifierid()), new SqlParameter(":fstatus", 1, (Object)Character.valueOf('1')), new SqlParameter(":flocaleid", 12, (Object)(it.getFlocaleId() == null ? "" : it.getFlocaleId()))};
            params.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
    }

    private void autoSetPrimaryKey(DynamicObject object, MainEntityType type) {
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(new Object[]{object}, (IDataEntityType)type);
    }

    private HistoryPrivacyUpgradeData createHistoryRecord(RecordDataType dataType, String routeKey, String tableName, String entityNumber, String fieldKey, String fieldName, Long schemaId, Long tplSchemeId, Long tplEntryRowId, Long tagId, String localeId) {
        HistoryPrivacyUpgradeData historyData = new HistoryPrivacyUpgradeData();
        historyData.setFcreatetime(new Date());
        historyData.setFcreatorid(RequestContext.get().getCurrUserId());
        historyData.setFdatatype(dataType.getValue());
        historyData.setFdbroute(routeKey);
        historyData.setFtablename(tableName);
        historyData.setFentitynumber(entityNumber);
        historyData.setFfieldkey(fieldKey);
        historyData.setFfieldname(fieldName);
        historyData.setFmodifierid(RequestContext.get().getCurrUserId());
        historyData.setFmodifytime(new Date());
        historyData.setFschemaid(schemaId);
        historyData.setFschematplid(tplSchemeId);
        historyData.setFtplentryrowid(tplEntryRowId);
        historyData.setFtagtplid(this.currentTplTagId);
        historyData.setFtagid(tagId);
        historyData.setFstatus("1");
        historyData.setFlocaleId(localeId);
        return historyData;
    }

    private static String buildConstaintKey(String ... strs) {
        return String.join((CharSequence)"@@", strs).toLowerCase();
    }

    private void saveAndPublishScheme() {
        DynamicObject[] objs = this.changedSchemeObjs.values().toArray(new DynamicObject[this.changedSchemeObjs.size()]);
        boolean success = true;
        for (DynamicObject obj : objs) {
            if (obj == null) continue;
            OperateOption option = OperateOption.create();
            option.setVariableValue("appnumber", "privacy");
            OperationResult result = OperationServiceHelper.executeOperate((String)"savesplittask", (String)ENTITYNUMBER_SCHEMECONFIG, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)option);
            if (result.isSuccess()) {
                QFilter filter = new QFilter("ftask_status", "in", (Object)new String[]{"0"}).and(new QFilter("fschemeid", "=", obj.getPkValue()));
                List pkids = QueryServiceHelper.queryPrimaryKeys((String)"t_privacy_task", (QFilter[])new QFilter[]{filter}, null, (int)-1);
                this.encryptTaskList.addAll(pkids);
                continue;
            }
            success = false;
        }
        PrivacyDataCenterManager.clearCache();
        if (success) {
            this.saveAllHisRecord();
        } else {
            this.errorCode = "003";
        }
        this.success.set(success);
    }

    private List<String> getExistEntity() {
        String sql = "select distinct a.fentity_number from t_privacy_data_field_tpl a inner join t_privacy_data_tag_tpl b on a.fid = b.fid where b.ftype = '1' and b.fid = " + this.currentTplTagId;
        List nums = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            ArrayList<String> entityNumbers = new ArrayList<String>(10);
            while (rs.next()) {
                String num = rs.getString(1);
                if (!StringUtils.isNotBlank((CharSequence)num)) continue;
                entityNumbers.add(num);
            }
            return entityNumbers;
        });
        if (nums.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> existsEntityNumber = new ArrayList<String>(nums.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"bos_formmeta", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)nums)}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                existsEntityNumber.add(row.getString("number"));
            }
        }
        return existsEntityNumber;
    }

    private String buildTagUniqueConsKey(String entityNumber, String fieldKey) {
        return SingleHandler.buildConstaintKey(entityNumber, fieldKey);
    }

    private String buildDesenUniqueConsKey(String entityNumber, String fieldKey, String localeId) {
        return SingleHandler.buildConstaintKey(entityNumber, fieldKey, localeId == null ? "" : localeId);
    }

    private String buildEncryptUniqueConsKey(String entityNumber, String fieldKey, String tableName, String fieldName, String dbRoute) {
        return SingleHandler.buildConstaintKey(entityNumber, fieldKey, tableName, fieldName);
    }

    private String buildEncryptIndexKey(String tableName, String fieldName, String dbRoute) {
        return SingleHandler.buildConstaintKey(tableName, fieldName);
    }
}

