/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.plugin.upgrade;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.privacy.plugin.upgrade.PrivacyUpgradeMonitorJob;
import kd.bos.privacy.plugin.upgrade.SingleHandler;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class TaskContainer {
    public static final String ERRORCODE_SAVETAGERROR = "002";
    public static final String ERRORCODE_SAVESCHEMEERROR = "003";
    public static final String ERRORCODE_PUBLISHENCRYPTTASK = "004";
    public static final String ERRORCODE_UNKNOWN = "001";
    private List<SingleHandler> analyzers = new ArrayList<SingleHandler>(10);
    private Long notifierId = null;
    private String msgChannels = "";

    public void addAnalyzer(SingleHandler analyzer) {
        this.analyzers.add(analyzer);
        analyzer.setContainer(this);
    }

    public TaskContainer(Long notifierId, String msgChannels) {
        this.notifierId = notifierId;
        this.msgChannels = msgChannels;
    }

    public void run() {
        ArrayList<Object> taskIds = new ArrayList<Object>(10);
        boolean succes = true;
        for (SingleHandler it : this.analyzers) {
            it.run();
            if (!it.isSuccess()) {
                succes = false;
                throw new RuntimeException(it.getErrorCode());
            }
            taskIds.addAll(it.getPrivacyTaskIds());
        }
        if (succes) {
            if (!taskIds.isEmpty()) {
                OperationServiceHelper.executeOperate((String)"btnpublish", (String)"t_privacy_task", (Object[])taskIds.toArray());
            }
            this.startEncryptMonitorTask(this.notifierId, this.msgChannels, taskIds);
        }
    }

    private void startEncryptMonitorTask(Long notifierId, String msgChannels, List<Object> taskIds) {
        JobInfo jobInfo = this.createJob(notifierId, msgChannels, taskIds);
        String jobId = ScheduleServiceHelper.createJob((JobInfo)jobInfo);
        PlanInfo scheduleInfo = this.createSchedule(jobInfo, new Date());
        scheduleInfo.setJobId(jobId);
        String schId = ScheduleServiceHelper.createPlan((PlanInfo)scheduleInfo);
        ArrayList<String> schIds = new ArrayList<String>(1);
        schIds.add(schId);
        try {
            ScheduleServiceHelper.enableSchedule(schIds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PlanInfo createSchedule(JobInfo jobInfo, Date startTime) {
        PlanInfo scheduleInfo = new PlanInfo();
        scheduleInfo.setId(DB.genGlobalLongId() + "");
        scheduleInfo.setJobId(jobInfo.getId());
        scheduleInfo.setName(jobInfo.getName());
        scheduleInfo.setNumber(jobInfo.getNumber());
        scheduleInfo.setEnable(true);
        scheduleInfo.setRepeatMode(RepeatModeEnum.ByDays);
        scheduleInfo.setEnable(true);
        Calendar start = Calendar.getInstance();
        start.setTime(new Date());
        scheduleInfo.setStartTime(start);
        Calendar end = Calendar.getInstance();
        end.setTime(startTime);
        end.add(5, 30);
        scheduleInfo.setEndTime(end);
        scheduleInfo.setCronExpression("0 0 12 * * ?");
        return scheduleInfo;
    }

    private JobInfo createJob(Long notifierId, String msgChannels, List<Object> encryptTaskList) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("msgChannels", msgChannels);
        params.put("notifierId", notifierId);
        params.put("taskIds", SerializationUtils.toJsonString(encryptTaskList));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(DB.genGlobalLongId() + "");
        jobInfo.setRunConcurrently(false);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskDefineId("3RQMCHWP9T2H");
        jobInfo.setTaskClassname(PrivacyUpgradeMonitorJob.class.getName());
        jobInfo.setParams(params);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdf.format(time);
        jobInfo.setName("PRI_PRESET_MONITOR" + dateStr);
        jobInfo.setNumber("PRI_PRESET_MONITOR" + dateStr);
        return jobInfo;
    }
}

