/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade.plugin.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class BillTypeFldCtlUpgradeService
implements IUpgradeService {
    private static final String KEY_BILLFORMID = "billformid";
    private static final String KEY_STATUS = "status";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_CREATORID = "creatorid";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_MODIFIERID = "modifierid";
    private static final String KEY_MODIFYTIME = "modifytime";
    private static final String KEY_MASTERID = "masterid";
    private static final String KEY_LAYOUT_SOLUTION = "layoutsolution";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("upgradeBillLayoutSchemeAssign - info:");
            String ret1 = this.upgradeBillLayoutSchemeAssign();
            sb.append(ret1).append(System.lineSeparator());
            sb.append("upgradeBillLayoutFldCtl - info:");
            String ret2 = this.upgradeBillLayoutFldCtl();
            sb.append(ret2).append(System.lineSeparator());
            result.setSuccess(true);
            sb.append("The BillTypeFldCtlUpgradeService execution was completed and the upgrade was successful!");
            result.setLog(sb.toString());
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setEl("error");
            String msg = "BillTypeFldCtlUpgradeService upgrade failed! error:" + e.getMessage();
            result.setErrorInfo(msg);
            result.setLog(msg);
        }
        return result;
    }

    private String upgradeBillLayoutSchemeAssign() {
        String sql = "  select fid, fbillformid, fstatus, fenable, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fmasterid from T_BAS_BILLTYPE where fid not in (select fid from t_cts_layoutschemeassign)";
        List list = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    Long id = rs.getLong(1);
                    map.put("id", id);
                    map.put(BillTypeFldCtlUpgradeService.KEY_BILLFORMID, rs.getString(2));
                    map.put(BillTypeFldCtlUpgradeService.KEY_STATUS, rs.getString(3));
                    map.put(BillTypeFldCtlUpgradeService.KEY_ENABLE, rs.getString(4));
                    map.put(BillTypeFldCtlUpgradeService.KEY_CREATORID, rs.getLong(5));
                    map.put(BillTypeFldCtlUpgradeService.KEY_CREATETIME, rs.getDate(6));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MODIFIERID, rs.getLong(7));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MODIFYTIME, rs.getDate(8));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MASTERID, rs.getLong(9));
                    list.add(map);
                }
                return list;
            }
        });
        ArrayList<String> formnumbers = new ArrayList<String>();
        for (Map map : list) {
            String formnumber = (String)map.get(KEY_BILLFORMID);
            if (formnumbers.contains(formnumber)) continue;
            formnumbers.add(formnumber);
        }
        if (formnumbers.isEmpty()) {
            return "T_BAS_BILLTYPE not found fid in t_cts_layoutschemeassign.";
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select a.fid, a.fnumber, b.fbizcloudid, b.fid  from t_meta_formdesign a inner join t_meta_bizapp b on a.fbizappid = b.fid where ", new Object[0]).appendIn("a.fnumber", formnumbers);
        Map metaNumberMap = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<String, String[]>>(){

            public Map<String, String[]> handle(ResultSet rs) throws Exception {
                HashMap<String, String[]> map = new HashMap<String, String[]>(16);
                while (rs.next()) {
                    String[] strs = new String[]{rs.getString(3), rs.getString(4)};
                    map.put(rs.getString(2), strs);
                }
                return map;
            }
        });
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (Map map : list) {
            String formNumber = (String)map.get(KEY_BILLFORMID);
            String[] strs = (String[])metaNumberMap.get(formNumber);
            if (strs == null) continue;
            Object[] vals = new Object[15];
            Long id = (Long)map.get("id");
            vals[0] = id;
            vals[1] = id;
            vals[2] = id;
            vals[3] = "2";
            vals[4] = 0;
            vals[5] = strs[0];
            vals[6] = strs[1];
            vals[7] = map.get(KEY_STATUS);
            vals[8] = map.get(KEY_ENABLE);
            vals[9] = map.get(KEY_CREATORID);
            Object createDate = map.get("createdate");
            vals[10] = createDate == null ? new Date() : createDate;
            vals[11] = map.get(KEY_MODIFIERID);
            vals[12] = map.get("modifydate");
            vals[13] = map.get(KEY_MASTERID);
            vals[14] = "0";
            if (!StringUtils.isNotBlank((CharSequence)formNumber)) continue;
            values.add(vals);
        }
        String inssql = "insert into t_cts_layoutschemeassign (fid, flayoutschemeid, fbilltypeid, ftype, forgid, fcloudid, fappid, fstatus, fenable, fcreatorid, fcreatedate, fmodifierid, fmodifydate, fmasterid, fincludesuborg) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        if (!values.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)inssql, values);
        }
        return "T_BAS_BILLTYPE into t_cts_layoutschemeassign count:" + values.size();
    }

    private String upgradeBillLayoutFldCtl() {
        String sql = "select fid, fnumber, fbillformid, fstatus, fenable, fcreatorid, fcreatetime, fmodifierid, fmodifytime, fmasterid, flayoutsolution from T_BAS_BILLTYPE where fid not in (select fid from T_CTS_LAYOUTSCHEME)";
        List list = (List)DB.query((DBRoute)DBRoute.base, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(16);
                    map.put("id", rs.getLong(1));
                    map.put("number", rs.getString(2));
                    map.put(BillTypeFldCtlUpgradeService.KEY_BILLFORMID, rs.getString(3));
                    map.put(BillTypeFldCtlUpgradeService.KEY_STATUS, rs.getString(4));
                    map.put(BillTypeFldCtlUpgradeService.KEY_ENABLE, rs.getString(5));
                    map.put(BillTypeFldCtlUpgradeService.KEY_CREATORID, rs.getLong(6));
                    map.put(BillTypeFldCtlUpgradeService.KEY_CREATETIME, rs.getDate(7));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MODIFIERID, rs.getLong(8));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MODIFYTIME, rs.getDate(9));
                    map.put(BillTypeFldCtlUpgradeService.KEY_MASTERID, rs.getLong(10));
                    map.put(BillTypeFldCtlUpgradeService.KEY_LAYOUT_SOLUTION, rs.getString(11));
                    list.add(map);
                }
                return list;
            }
        });
        ArrayList<String> layoutIds = new ArrayList<String>();
        for (Map map : list) {
            Object formnumber;
            String layoutId = (String)map.get(KEY_LAYOUT_SOLUTION);
            if (layoutId != null) {
                layoutIds.add(layoutId);
            }
            if (layoutIds.contains(formnumber = (String)map.get(KEY_BILLFORMID))) continue;
            layoutIds.add((String)formnumber);
        }
        if (layoutIds.isEmpty()) {
            return "T_BAS_BILLTYPE not found fid in T_BAS_BILLTYPE.";
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid, fnumber from t_meta_formdesign where ", new Object[0]).appendIn("fid", layoutIds);
        Map metaNumberMap = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getString(2));
                }
                return map;
            }
        });
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (Map map : list) {
            Object[] vals = new Object[12];
            vals[0] = map.get("id");
            vals[1] = map.get("number");
            vals[2] = map.get(KEY_BILLFORMID);
            vals[3] = map.get(KEY_STATUS);
            vals[4] = map.get(KEY_ENABLE);
            vals[5] = map.get(KEY_CREATORID);
            vals[6] = map.get(KEY_CREATETIME);
            vals[7] = map.get(KEY_MODIFIERID);
            vals[8] = map.get(KEY_MODIFYTIME);
            vals[9] = map.get(KEY_MASTERID);
            String layoutId = (String)map.get(KEY_LAYOUT_SOLUTION);
            if (StringUtils.isBlank((CharSequence)layoutId) || "null".equalsIgnoreCase(layoutId)) {
                vals[10] = vals[2];
                vals[11] = metaNumberMap.get(vals[1]);
            } else {
                vals[10] = metaNumberMap.get(layoutId);
                vals[11] = layoutId;
            }
            if (!StringUtils.isNotBlank((Object)vals[10]) || !StringUtils.isNotBlank((Object)vals[11])) continue;
            values.add(vals);
        }
        String inssql = "insert into T_CTS_LAYOUTSCHEME (fid, fnumber, fformnumber, fstatus, fenable, fcreatorid, fcreatedate, fmodifierid, fmodifydate, fmasterid, flayoutnumber, flayoutnumber_d) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        if (!values.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.base, (String)inssql, values);
        }
        return "T_BAS_BILLTYPE into T_CTS_LAYOUTSCHEME count:" + values.size();
    }

    private static class BillType {
        Long id;
        String number;
        String billformid;
        String status;
        String enable;
        Long creatorid;
        java.sql.Date createtime;
        Long modifierid;
        java.sql.Date modifytime;
        Long masterid;
        String layoutsolution;
        String layoutnumber;

        private BillType() {
        }

        Long getId() {
            return this.id;
        }

        void setId(Long id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getBillformid() {
            return this.billformid;
        }

        public void setBillformid(String billformid) {
            this.billformid = billformid;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getEnable() {
            return this.enable;
        }

        public void setEnable(String enable) {
            this.enable = enable;
        }

        public Long getCreatorid() {
            return this.creatorid;
        }

        public void setCreatorid(Long creatorid) {
            this.creatorid = creatorid;
        }

        public java.sql.Date getCreatetime() {
            return this.createtime;
        }

        public void setCreatetime(java.sql.Date createtime) {
            this.createtime = createtime;
        }

        public Long getModifierid() {
            return this.modifierid;
        }

        public void setModifierid(Long modifierid) {
            this.modifierid = modifierid;
        }

        public java.sql.Date getModifytime() {
            return this.modifytime;
        }

        public void setModifytime(java.sql.Date modifytime) {
            this.modifytime = modifytime;
        }

        public Long getMasterid() {
            return this.masterid;
        }

        public void setMasterid(Long masterid) {
            this.masterid = masterid;
        }

        public String getLayoutsolution() {
            return this.layoutsolution;
        }

        public void setLayoutsolution(String layoutsolution) {
            this.layoutsolution = layoutsolution;
        }

        public String getLayoutnumber() {
            return this.layoutnumber;
        }

        public void setLayoutnumber(String layoutnumber) {
            this.layoutnumber = layoutnumber;
        }
    }
}

