/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.api.funcpara;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.api.VarInfo;
import kd.bos.formula.platform.api.funcpara.IFuncParamInputFormPlugin;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;

public class LogFuncParaInputPlugin
extends AbstractFormPlugin
implements IFuncParamInputFormPlugin {
    private static final String KEY_DISHU = "dishu";
    private static final String KEY_CCOZUOSHU = "caozuoshu";

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        FormulaDesignerParameter designerParameter = this.getDesignerParameter();
        if (designerParameter != null) {
            for (VarInfo varInfo : designerParameter.getVarInfos()) {
                if (!StringUtils.equals((CharSequence)varInfo.getVarType(), (CharSequence)"INT")) continue;
                ComboItem item = new ComboItem(new LocaleString(varInfo.getVarAlias()), varInfo.getVarName());
                items.add(item);
            }
            ComboEdit dishu = (ComboEdit)this.getView().getControl(KEY_DISHU);
            dishu.setComboItems(items);
            ComboEdit caozuoshu = (ComboEdit)this.getView().getControl(KEY_CCOZUOSHU);
            caozuoshu.setComboItems(items);
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String t1 = (String)this.getModel().getValue(KEY_DISHU);
        String t2 = (String)this.getModel().getValue(KEY_CCOZUOSHU);
        if (StringUtils.isBlank((CharSequence)t1) || StringUtils.isBlank((CharSequence)t2)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u53c2\u6570", (String)"LogFuncParaInputPlugin_0", (String)"bos-formula-platform-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        String t1 = (String)this.getModel().getValue(KEY_DISHU);
        String t2 = (String)this.getModel().getValue(KEY_CCOZUOSHU);
        FuncInfo funcInfo = this.getFuncInfo();
        String setting = String.format("%s(%s, %s)", funcInfo == null ? "log" : funcInfo.getFuncName(), t1, t2);
        return setting;
    }
}

