/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.api.FuncInfo;
import kd.bos.formula.platform.api.funcpara.IFuncParamInputFormPlugin;

public class FuncParamContainerPlugin
extends AbstractFormPlugin {
    private static final String CACHEKEY_PARAMPAGEID = "parampageid";
    private static final String KEY_FLD_FUNCCAPTION = "funccaption";
    private static final String KEY_FLD_FUNCNAME = "funcname";
    private static final String KEY_FLD_FUNCDESC = "funcdesc";
    private static final String KEY_PANEL_PARAM = "panel_param";
    private static final String KEY_BUTTON_OK = "btnok";
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private FuncInfo funcInfo;

    public void afterCreateNewData(EventObject e) {
        FuncInfo funcInfo = this.getFuncInfo();
        if (funcInfo != null) {
            this.getModel().setValue(KEY_FLD_FUNCNAME, (Object)funcInfo.getFuncName());
            this.getModel().setValue(KEY_FLD_FUNCCAPTION, (Object)funcInfo.getFuncCaption());
            this.getModel().setValue(KEY_FLD_FUNCDESC, (Object)funcInfo.getFuncDesc());
        }
    }

    public void afterBindData(EventObject e) {
        this.showParamForm();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BUTTON_OK, KEY_BUTTON_CANCEL});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_OK)) {
            String funcFormula = this.getFuncFormula();
            if (StringUtils.isNotBlank((CharSequence)funcFormula)) {
                this.getView().returnDataToParent((Object)funcFormula);
                this.getView().close();
            }
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_BUTTON_CANCEL)) {
            this.getView().close();
        }
    }

    private FuncInfo getFuncInfo() {
        String str;
        if (this.funcInfo == null && !StringUtils.isBlank((CharSequence)(str = (String)this.getView().getFormShowParameter().getCustomParam("funcinfo")))) {
            this.funcInfo = (FuncInfo)SerializationUtils.fromJsonString((String)str, FuncInfo.class);
        }
        return this.funcInfo;
    }

    private void showParamForm() {
        FuncInfo funcInfo = this.getFuncInfo();
        if (funcInfo == null || StringUtils.isBlank((CharSequence)funcInfo.getParaFormId())) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(funcInfo.getParaFormId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_PANEL_PARAM);
        this.getView().showForm(showParameter);
        this.getPageCache().put(CACHEKEY_PARAMPAGEID, showParameter.getPageId());
    }

    private String getFuncFormula() {
        String paramPageId = this.getPageCache().get(CACHEKEY_PARAMPAGEID);
        if (StringUtils.isBlank((CharSequence)paramPageId)) {
            return null;
        }
        IFormView paramView = this.getView().getView(paramPageId);
        IFuncParamInputFormPlugin paramPlugin = this.getParameterPlug(paramView);
        StringBuilder errMsg = new StringBuilder();
        if (paramPlugin != null && !paramPlugin.checkSetting(errMsg).booleanValue() && !StringUtils.isBlank((CharSequence)errMsg.toString())) {
            this.getView().showTipNotification(errMsg.toString());
        }
        return paramPlugin == null ? null : paramPlugin.getSetting();
    }

    private IFuncParamInputFormPlugin getParameterPlug(IFormView view) {
        if (view == null) {
            return null;
        }
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (proxy != null) {
            for (IFormPlugin plugin : proxy.getPlugIns()) {
                if (!(plugin instanceof IFuncParamInputFormPlugin)) continue;
                return (IFuncParamInputFormPlugin)plugin;
            }
        }
        return null;
    }
}

