/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.sample;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.api.VarInfo;
import kd.bos.formula.platform.builder.FormulaDesigner;
import kd.bos.formula.platform.builder.FormulaDesignerParameter;
import kd.bos.formula.platform.builder.FormulaDesignerResult;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.formula.platform.sample.CustFormulaFunctionsSample;
import kd.bos.list.ListShowParameter;

public class ShowFormulaFormModal_SamplePlugin
extends AbstractFormPlugin {
    private static final String KEY_TEXT_FORNMULAALIAS = "formulaalias";
    private static final String KEY_TEXT_FORNMULASCRIPT = "formulascript";
    private static final String KEY_BUTTON_SHOWFORMMULA = "btn_showformula";
    private static final String KEY_INT_VAR1 = "var1";
    private static final String KEY_INT_VAR2 = "var2";
    private static final String KEY_INT_VAR3 = "var3";
    private static final String KEY_BASE_OBJECTTYPE = "objecttype";
    private static final String KEY_BASE_OBJECTID = "objectid";
    private static final String KEY_BUTTON_RUNFORMULA = "btn_runformula";
    private static final String KEY_TEXT_RESULT = "result";
    private static final String CALLBACKACTIONID_FORMUKAFORM = "formulaform";
    private static final String CALLBACKACTIONID_OBJECYID = "objectid";

    private String getCustomVariable() {
        return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf", (String)"ShowFormulaFormModal_SamplePlugin_0", (String)"bos-formula-platform-plugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BUTTON_SHOWFORMMULA});
        this.addClickListeners(new String[]{KEY_BUTTON_RUNFORMULA});
        this.addClickListeners(new String[]{"objectid"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BUTTON_SHOWFORMMULA, (CharSequence)source.getKey())) {
            this.showFormulaForm();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)KEY_BUTTON_RUNFORMULA, (CharSequence)source.getKey())) {
            this.runFormula();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"objectid", (CharSequence)source.getKey())) {
            this.showBillList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)CALLBACKACTIONID_FORMUKAFORM, (CharSequence)closedCallBackEvent.getActionId())) {
            this.receiveFormulaDesignResult(closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"objectid", (CharSequence)closedCallBackEvent.getActionId()) && closedCallBackEvent != null && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            this.getModel().setValue("objectid", rows.get(0).getPrimaryKeyValue());
        }
    }

    private void showFormulaForm() {
        FormulaDesignerParameter parameter = new FormulaDesignerParameter();
        parameter.setRunMode(0);
        parameter.setEditable(true);
        parameter.setFormulaStr((String)this.getModel().getValue(KEY_TEXT_FORNMULASCRIPT));
        parameter.addVarInfo(new VarInfo(KEY_INT_VAR1, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf1", (String)"ShowFormulaFormModal_SamplePlugin_1", (String)"bos-formula-platform-plugin", (Object[])new Object[0]), "INT", "", "in", this.getCustomVariable()));
        parameter.addVarInfo(new VarInfo(KEY_INT_VAR2, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf2", (String)"ShowFormulaFormModal_SamplePlugin_2", (String)"bos-formula-platform-plugin", (Object[])new Object[0]), "INT", "", "in", this.getCustomVariable()));
        parameter.addVarInfo(new VarInfo(KEY_INT_VAR3, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d8\u91cf3", (String)"ShowFormulaFormModal_SamplePlugin_3", (String)"bos-formula-platform-plugin", (Object[])new Object[0]), "INT", "", "in", this.getCustomVariable()));
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_BASE_OBJECTTYPE);
        if (objectType != null) {
            String entityNumber = (String)objectType.getPkValue();
            parameter.addEntity(entityNumber);
            parameter.addVarInfo(new VarInfo(entityNumber, objectType.getString("name"), "", "", "in", ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"ShowFormulaFormModal_SamplePlugin_4", (String)"bos-formula-platform-plugin", (Object[])new Object[0])));
        }
        parameter.addBaseFormulaFunctions();
        parameter.addFormulaFunctions((IFormulaFunctions)new CustFormulaFunctionsSample());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKACTIONID_FORMUKAFORM);
        FormulaDesigner.showModal((IFormView)this.getView(), (CloseCallBack)closeCallBack, (FormulaDesignerParameter)parameter);
    }

    private void receiveFormulaDesignResult(Object returnStr) {
        if (StringUtils.isBlank((Object)returnStr)) {
            return;
        }
        FormulaDesignerResult designResult = (FormulaDesignerResult)SerializationUtils.fromJsonString((String)((String)returnStr), FormulaDesignerResult.class);
        this.getModel().setValue(KEY_TEXT_FORNMULAALIAS, (Object)designResult.getFormulaAliasStr());
        this.getModel().setValue(KEY_TEXT_FORNMULASCRIPT, (Object)designResult.getFormulaStr());
    }

    private void runFormula() {
        String formulaStr = (String)this.getModel().getValue(KEY_TEXT_FORNMULASCRIPT);
        if (StringUtils.isBlank((CharSequence)formulaStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u8ba1\u7b97\u516c\u5f0f", (String)"ShowFormulaFormModal_SamplePlugin_5", (String)"bos-formula-platform-plugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> varValues = new HashMap<String, Object>();
        varValues.put(KEY_INT_VAR1, (Integer)this.getModel().getValue(KEY_INT_VAR1));
        varValues.put(KEY_INT_VAR2, (Integer)this.getModel().getValue(KEY_INT_VAR2));
        varValues.put(KEY_INT_VAR3, (Integer)this.getModel().getValue(KEY_INT_VAR3));
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_BASE_OBJECTTYPE);
        String objectId = (String)this.getModel().getValue("objectid");
        if (objectType != null && StringUtils.isNotBlank((CharSequence)objectId)) {
            DynamicObjectCollection rows;
            String entityNumber = (String)objectType.getPkValue();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DynamicObject billObj = BusinessDataReader.loadSingle((Object)objectId, (DynamicObjectType)mainType);
            varValues.put(entityNumber, billObj);
            EntityType entryType = (EntityType)mainType.getAllEntities().get("entryentity");
            if (entryType != null && !(rows = billObj.getDynamicObjectCollection(entryType.getName())).isEmpty()) {
                varValues.put(entityNumber + "." + entryType.getName(), rows.get(0));
            }
        }
        try {
            FormulaEngine.registerFunctions((IFormulaFunctions)new CustFormulaFunctionsSample());
            Object result = FormulaEngine.runFormula((String)formulaStr, varValues);
            this.getModel().setValue(KEY_TEXT_RESULT, result);
        }
        catch (RunFormulaException exp) {
            this.getView().showErrMessage(exp.getMessage(), ResManager.loadKDString((String)"\u516c\u5f0f\u6267\u884c\u51fa\u9519", (String)"ShowFormulaFormModal_SamplePlugin_6", (String)"bos-formula-platform-plugin", (Object[])new Object[0]));
        }
    }

    private void showBillList() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(KEY_BASE_OBJECTTYPE);
        if (objectType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"ShowFormulaFormModal_SamplePlugin_7", (String)"bos-formula-platform-plugin", (Object[])new Object[0]));
            return;
        }
        String entityNumber = (String)objectType.getPkValue();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "objectid");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

