/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AppBlackListEditPlugin
extends AbstractFormPlugin {
    private static final String APPID = "appid";
    private static final String BTNOK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(APPID);
        this.getModel().setValue(APPID, (Object)appId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.returnDataAndClose();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("continue_save".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.returnDataAndClose();
        }
    }

    private void returnDataAndClose() {
        HashMap<String, String> para = new HashMap<String, String>(16);
        DynamicObject app = (DynamicObject)this.getModel().getValue(APPID);
        if (app == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e91\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AppBlackListEditPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        String appId = app.getPkValue().toString();
        String appName = app.getString("name");
        para.put(APPID, appId);
        para.put("appname", appName);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

