/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CloudBlackListEditPlugin
extends AbstractFormPlugin {
    private static final String CLOUDID = "cloudid";
    private static final String BTNOK = "btnok";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String cloudId = (String)this.getView().getFormShowParameter().getCustomParam(CLOUDID);
        this.getModel().setValue(CLOUDID, (Object)cloudId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.returnDataAndClose();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if ("continue_save".equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.returnDataAndClose();
        }
    }

    private void returnDataAndClose() {
        HashMap<String, String> para = new HashMap<String, String>(16);
        DynamicObject cloud = (DynamicObject)this.getModel().getValue(CLOUDID);
        if (cloud == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e91\u4e0d\u80fd\u4e3a\u7a7a", (String)"CloudBlackListEditPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        String cloudId = cloud.getPkValue().toString();
        String cloudName = cloud.getString("name");
        para.put(CLOUDID, cloudId);
        para.put("cloudname", cloudName);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

