/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.CloudBlackListPlugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FastSearchGridView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FeaturesBlackListEditPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String TreeView = "treeview";
    private static final String RootNodeID = "0";
    private static final String Key_ID = "id";
    private static final String Key_Number = "number";
    private static final String Key_Name = "name";
    private static final String Key_BizCloud = "bizcloud";
    private static final String Key_Cloud = "cloud";
    private static final String Key_App = "app";
    private static final String Key_SearchAp = "searchap";
    private static final String Key_FastSearchAp = "fastsearchgridviewap";
    protected static final String CacheKey_CloudId = "parentId";
    protected static final String CacheKey_AppId = "currentId";
    private static final String FormId_BizApp = "bos_devportal_bizapp";
    private static final String FormId_BizCloud = "bos_devportal_bizcloud";
    protected static final String EntityId_NewFeatures = "bos_features_input";
    private static final String TreeNodeCache = "treeNode";
    private static final String SearchTextCache = "searchText";
    private static final String SearchTimesCache = "searchTimes";
    private static final String SearchDataCache = "searchData";
    public static final String SystemType_Productmodel = "bos-productmodel-resource";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tView = (TreeView)this.getControl(TreeView);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(Key_SearchAp);
        search.addEnterListener((SearchEnterListener)this);
        FastSearchGridView fastSearch = (FastSearchGridView)this.getControl(Key_FastSearchAp);
        fastSearch.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = e.getNodeId().toString();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            if (RootNodeID.equals(nodeId)) {
                e.addQFilter(null);
            } else {
                e.addQFilter(new QFilter("bizcloud.id", "=", (Object)nodeId).or(new QFilter("bizapp.id", "=", (Object)nodeId)));
            }
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode root = this.buildTreeNodes();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getPageCache().put(TreeNodeCache, SerializationUtils.toJsonString((Object)root));
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
        } else {
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (treeNode != null) {
                return treeNode.getChildren();
            }
        }
        return cloudNodes;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        BillOperationStatus status = parameter.getBillStatus();
        if (status.equals((Object)BillOperationStatus.EDIT)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u7279\u6027", (String)"FeaturesBlackListEditPlugin_3", (String)SystemType_Productmodel, (Object[])new Object[0]));
        }
        TreeNode root = this.getTreeModel().getRoot();
        String currentId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode currentNode = root.getTreeNode(currentId, 20);
        String parentId = currentNode.getParentid();
        if (!StringUtils.equals((CharSequence)RootNodeID, (CharSequence)currentId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (StringUtils.equals((CharSequence)parentId, (CharSequence)RootNodeID)) {
                map.put(CacheKey_CloudId, currentId);
            } else {
                map.put(CacheKey_CloudId, parentId);
                map.put(CacheKey_AppId, currentId);
            }
            parameter.setCustomParams(map);
        }
    }

    private TreeNode buildTreeNodes() {
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(RootNodeID);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"FeaturesBlackListEditPlugin_4", (String)SystemType_Productmodel, (Object[])new Object[0]));
        root.setIsOpened(true);
        root.setChildren(this.getCloudNodes());
        return root;
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNodes = new ArrayList<TreeNode>(10);
        Set<String> cloudWhiteList = CloudBlackListPlugin.getCloudWhiteList();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Key_ID, "in", cloudWhiteList));
        Map<Object, DynamicObject> clouds = this.getNodesHelper(Key_Cloud, filters);
        for (DynamicObject cloud : clouds.values()) {
            TreeNode cloudNode = new TreeNode();
            String cloudId = cloud.getString(Key_ID);
            cloudNode.setId(cloudId);
            cloudNode.setText(cloud.getString(Key_Name));
            cloudNode.setParentid(RootNodeID);
            cloudNode.setChildren(this.getAppNodes(cloudId));
            cloudNodes.add(cloudNode);
        }
        return cloudNodes;
    }

    private List<TreeNode> getAppNodes(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(Key_BizCloud, "=", (Object)cloudId));
        filters.add(new QFilter("type", "=", (Object)RootNodeID));
        Map<Object, DynamicObject> apps = this.getNodesHelper(Key_App, filters);
        for (DynamicObject app : apps.values()) {
            TreeNode appNode = new TreeNode();
            appNode.setId(app.getString(Key_ID));
            appNode.setText(app.getString(Key_Name));
            appNode.setParentid(cloudId);
            appNodes.add(appNode);
        }
        return appNodes;
    }

    private Map<Object, DynamicObject> getNodesHelper(String key, List<QFilter> filters) {
        String entityName = Key_Cloud.equals(key) ? FormId_BizCloud : FormId_BizApp;
        String selectFields = "id, sequence, number, name";
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        return resultMap;
    }

    /*
     * WARNING - void declaration
     */
    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        String key = search.getKey();
        if (key.equals(Key_SearchAp)) {
            String searchText = e.getText();
            TreeView tv = (TreeView)this.getControl(TreeView);
            String searchTextCache = this.getPageCache().get(SearchTextCache);
            String searchTimesCache = this.getPageCache().get(SearchTimesCache);
            int searchTimes = 0;
            if (StringUtils.isNotBlank((CharSequence)searchTimesCache)) {
                searchTimes = Integer.parseInt(searchTimesCache);
            }
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TreeNodeCache), TreeNode.class);
            List cloudNodes = root.getChildren();
            ArrayList appNodes = new ArrayList();
            for (TreeNode cloud : cloudNodes) {
                if (cloud.getChildren() == null) continue;
                appNodes.addAll(cloud.getChildren());
            }
            ArrayList<Object> allNodes = new ArrayList<Object>();
            allNodes.add(root);
            allNodes.addAll(cloudNodes);
            allNodes.addAll(appNodes);
            if (searchText.equals(searchTextCache)) {
                List listCache;
                String searchDataCache = this.getPageCache().get(SearchDataCache);
                if (searchDataCache != null && !(listCache = SerializationUtils.fromJsonStringToList((String)searchDataCache, TreeNode.class)).isEmpty()) {
                    void var15_19;
                    TreeNode treeNode = new TreeNode();
                    if (listCache.size() > searchTimes) {
                        TreeNode treeNode2 = (TreeNode)listCache.get(searchTimes);
                        this.getPageCache().put(SearchTimesCache, String.valueOf(searchTimes + 1));
                    } else {
                        TreeNode treeNode3 = (TreeNode)listCache.get(0);
                        this.getPageCache().put(SearchTimesCache, "1");
                    }
                    this.clickNode(tv, var15_19.getParentid(), var15_19.getId());
                }
            } else {
                ArrayList<TreeNode> data = new ArrayList<TreeNode>();
                for (TreeNode treeNode : allNodes) {
                    if (!treeNode.getText().contains(searchText)) continue;
                    data.add(treeNode);
                }
                if (data.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u4e91\u6216\u5e94\u7528\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"FeaturesBlackListEditPlugin_5", (String)SystemType_Productmodel, (Object[])new Object[0]));
                    return;
                }
                TreeNode nextNode = (TreeNode)data.get(0);
                this.clickNode(tv, nextNode.getParentid(), nextNode.getId());
                this.getPageCache().put(SearchTextCache, searchText);
                this.getPageCache().put(SearchTimesCache, "1");
                this.getPageCache().put(SearchDataCache, SerializationUtils.toJsonString(data));
            }
        }
    }

    private void clickNode(TreeView tv, String parentId, String currentNodeId) {
        TreeNode parentNode = new TreeNode();
        parentNode.setId(parentId);
        TreeNode currentNode = new TreeNode();
        currentNode.setId(currentNodeId);
        if (!RootNodeID.equals(parentId)) {
            tv.expand(RootNodeID);
        }
        tv.expand(parentId);
        tv.focusNode(currentNode);
        tv.treeNodeClick(parentId, currentNodeId);
    }
}

