/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.model.ControlBlackListInfo;
import kd.bos.designer.productmodel.model.FieldBlackListInfo;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FormBlackListPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SEARCHBLACKLIST = "searchblacklist";
    private static final String CACHEID_BLACKLIST = "BlackList_CacheId";
    private static final String FORMID_OPERATESELECT = "bos_operate_select_edit";
    private static final String FORMID_CONTROLSELECT = "bos_form_serviceeditsel";
    private static final String FORMID_FIELDSELECT = "bos_field_select_edit";
    private static final String FORMID_LISTFIELDSELECT = "bos_listfield_select_edit";
    private static final String FORMID_LISTCTLSELECT = "bos_listctl_select_edit";
    private static final String KEY_APPID = "appid";
    private static final String KEY_FORM = "form";
    private static final String KEY_FORMID = "formid";
    private static final String KEY_FORMNAME = "formname";
    private static final String KEY_FORMNUMBER = "formnumber";
    private static final String KEY_OPERATES = "operates";
    private static final String KEY_OPERATES_INNER = "operatesinner";
    private static final String KEY_FIELDS = "fields";
    private static final String KEY_FIELDS_INNER = "fieldsinner";
    private static final String KEY_CONTROLS = "controls";
    private static final String KEY_CONTROLS_INNER = "controlsinner";
    private static final String KEY_LISTFIELDS = "listfields";
    private static final String KEY_LISTFIELDS_INNER = "listfieldsinner";
    private static final String KEY_LISTCTLS = "listctls";
    private static final String KEY_LISTCTLS_INNER = "listctlsinner";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_ID = "id";
    private static final String KEY_SAVE = "btnsave";
    private static final String KEY_FORMCLEARCACHE = "btnformclearcache";
    private static final String KEY_PRODUCTMODEL = "productmodel";
    private static final String KEY_NUMBER = "number";
    private static final String FORM_NUMBER = "formNumber";
    private static final String FORM_ID = "formId";
    private static final String VALUE = "value";
    private static final String FIELDS = "Fields";
    private List<FormBlackListInfo> blackListInfos;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        this.addClickListeners(new String[]{KEY_OPERATES, KEY_FIELDS, KEY_CONTROLS, KEY_LISTFIELDS, KEY_LISTCTLS});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_BLACKLIST);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<FormBlackListInfo> allFormBlackList = this.loadAllFormBlackList();
        this.putBlackListCache(allFormBlackList);
        this.doSearch("");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        switch (key) {
            case "btnsave": {
                this.saveAllForms();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"FormBlackListPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
            case "btnformclearcache": {
                FormBlackListSaveHelper.clearCache(modelType);
                this.getPageCache().put(CACHEID_BLACKLIST, "");
                this.blackListInfos = null;
                this.doSearch("");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f\uff01", (String)"FormBlackListPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "controls": {
                this.afterSelectControls(closedCallBackEvent);
                break;
            }
            case "fields": {
                this.afterSelectFields(closedCallBackEvent);
                break;
            }
            case "operates": {
                this.afterSelectOperates(closedCallBackEvent);
                break;
            }
            case "listfields": {
                this.afterSelectListFields(closedCallBackEvent);
                break;
            }
            case "listctls": {
                this.afterSelectListCtls(closedCallBackEvent);
                break;
            }
        }
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCHBLACKLIST, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "controls": {
                this.showSelectControls();
                break;
            }
            case "fields": {
                if (!this.hasEntity()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6ca1\u6709\u5b9e\u4f53\uff0c\u65e0\u9700\u914d\u7f6e\u5b57\u6bb5", (String)"FormBlackListPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
                    return;
                }
                this.showSelectFields();
                break;
            }
            case "operates": {
                this.showSelectOperates();
                break;
            }
            case "listfields": {
                this.showSelectListFileds();
                break;
            }
            case "listctls": {
                this.showSelectListCtls();
                break;
            }
        }
    }

    private void showSelectControls() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONTROLSELECT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        String formId = (String)this.getModel().getValue(KEY_FORMID, rowIndex);
        String controls = (String)this.getModel().getValue(KEY_CONTROLS_INNER, rowIndex);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        showParameter.getCustomParams().put(FORM_NUMBER, formNumber);
        showParameter.getCustomParams().put(FORM_ID, formId);
        showParameter.getCustomParams().put(VALUE, controls);
        showParameter.getCustomParams().put("isList", Boolean.TRUE);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_CONTROLS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showSelectOperates() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_OPERATESELECT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        String formId = (String)this.getModel().getValue(KEY_FORMID, rowIndex);
        String operates = (String)this.getModel().getValue(KEY_OPERATES_INNER, rowIndex);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        showParameter.getCustomParams().put(FORM_NUMBER, formNumber);
        showParameter.getCustomParams().put(FORM_ID, formId);
        showParameter.getCustomParams().put(VALUE, operates);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_OPERATES);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showSelectFields() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_FIELDSELECT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        String fields = (String)this.getModel().getValue(KEY_FIELDS_INNER, rowIndex);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        showParameter.getCustomParams().put(FORM_NUMBER, formNumber);
        showParameter.getCustomParams().put(VALUE, fields);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FIELDS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showSelectListFileds() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_LISTFIELDSELECT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        String fields = (String)this.getModel().getValue(KEY_LISTFIELDS_INNER, rowIndex);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        showParameter.getCustomParams().put(FORM_NUMBER, formNumber);
        showParameter.getCustomParams().put(VALUE, fields);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_LISTFIELDS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showSelectListCtls() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_LISTCTLSELECT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        String ctls = (String)this.getModel().getValue(KEY_LISTCTLS_INNER, rowIndex);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        showParameter.getCustomParams().put(FORM_NUMBER, formNumber);
        showParameter.getCustomParams().put(VALUE, ctls);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_LISTCTLS);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void afterSelectControls(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            List controls = (List)returnData.get(FIELDS);
            StringBuilder controlStr = new StringBuilder();
            String controlStrInner = "";
            if (controls != null) {
                ArrayList<ControlBlackListInfo> controlInfos = new ArrayList<ControlBlackListInfo>(controls.size());
                String formId = (String)returnData.get(FORM_ID);
                for (int i = 0; i < controls.size(); ++i) {
                    Map control = (Map)controls.get(i);
                    String name = (String)control.get("text");
                    String id = (String)control.get(KEY_ID);
                    String parentId = (String)control.get("parentid");
                    ControlBlackListInfo controlInfo = new ControlBlackListInfo(id, name, id, parentId);
                    controlInfo.setDisable(true);
                    controlInfo.setFormId(formId);
                    controlInfos.add(controlInfo);
                    if (i == 0) {
                        controlStr.append(name);
                        continue;
                    }
                    controlStr.append(',').append(name);
                }
                controlStrInner = SerializationUtils.toJsonString(controlInfos);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_CONTROLS, (Object)controlStr.toString(), index);
            this.getModel().setValue(KEY_CONTROLS_INNER, (Object)controlStrInner, index);
        }
    }

    private void afterSelectOperates(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            List operations = (List)returnData.get("Operations");
            StringBuilder operationStr = new StringBuilder();
            String operationStrInner = "";
            if (operations != null) {
                for (int i = 0; i < operations.size(); ++i) {
                    Map op = (Map)operations.get(i);
                    String name = (String)op.get("OpName");
                    if (i == 0) {
                        operationStr.append(name);
                        continue;
                    }
                    operationStr.append(',').append(name);
                }
                operationStrInner = SerializationUtils.toJsonString((Object)operations);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_OPERATES, (Object)operationStr.toString(), index);
            this.getModel().setValue(KEY_OPERATES_INNER, (Object)operationStrInner, index);
        }
    }

    private void afterSelectFields(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            List fields = (List)returnData.get(FIELDS);
            StringBuilder fieldStr = new StringBuilder();
            String fieldStrInner = "";
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    FieldBlackListInfo field = (FieldBlackListInfo)fields.get(i);
                    String name = field.getName();
                    if (i == 0) {
                        fieldStr.append(name);
                        continue;
                    }
                    fieldStr.append(',').append(name);
                }
                fieldStrInner = SerializationUtils.toJsonString((Object)fields);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_FIELDS, (Object)fieldStr.toString(), index);
            this.getModel().setValue(KEY_FIELDS_INNER, (Object)fieldStrInner, index);
        }
    }

    private void afterSelectListFields(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            List fields = (List)returnData.get(FIELDS);
            StringBuilder fieldStr = new StringBuilder();
            String fieldStrInner = "";
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    FieldBlackListInfo field = (FieldBlackListInfo)fields.get(i);
                    String name = field.getName();
                    if (i == 0) {
                        fieldStr.append(name);
                        continue;
                    }
                    fieldStr.append(',').append(name);
                }
                fieldStrInner = SerializationUtils.toJsonString((Object)fields);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_LISTFIELDS, (Object)fieldStr.toString(), index);
            this.getModel().setValue(KEY_LISTFIELDS_INNER, (Object)fieldStrInner, index);
        }
    }

    private void afterSelectListCtls(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            List fields = (List)returnData.get(FIELDS);
            StringBuilder fieldStr = new StringBuilder();
            String fieldStrInner = "";
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    FieldBlackListInfo field = (FieldBlackListInfo)fields.get(i);
                    String name = field.getName();
                    if (i == 0) {
                        fieldStr.append(name);
                        continue;
                    }
                    fieldStr.append(',').append(name);
                }
                fieldStrInner = SerializationUtils.toJsonString((Object)fields);
            }
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_LISTCTLS, (Object)fieldStr.toString(), index);
            this.getModel().setValue(KEY_LISTCTLS_INNER, (Object)fieldStrInner, index);
        }
    }

    private FormBlackListInfo getSelectBlacList() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"FormBlackListPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return null;
        }
        String fid = (String)this.getModel().getValue(KEY_FORMID, rowIndex);
        List<FormBlackListInfo> allBlackLists = this.getBlackListCache();
        FormBlackListInfo blackList = null;
        for (FormBlackListInfo Form2 : allBlackLists) {
            if (!fid.equals(Form2.getFormId())) continue;
            blackList = Form2;
            break;
        }
        return blackList;
    }

    private void doSearch(String searchText) {
        List<FormBlackListInfo> allBlackLists = this.getBlackListCache();
        ArrayList<FormBlackListInfo> blackLists = new ArrayList<FormBlackListInfo>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            blackLists.addAll(allBlackLists);
        } else {
            for (FormBlackListInfo Form2 : allBlackLists) {
                if ((!StringUtils.isNotBlank((CharSequence)Form2.getFormName()) || Form2.getFormName().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)Form2.getFormId()) || Form2.getFormId().indexOf(searchText) < 0)) continue;
                blackLists.add(Form2);
            }
        }
        this.refreshEntryGrid(blackLists);
    }

    private void refreshEntryGrid(List<FormBlackListInfo> formBlackLists) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        if (!formBlackLists.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, formBlackLists.size());
            for (int index = 0; index < formBlackLists.size(); ++index) {
                FormBlackListInfo form = formBlackLists.get(index);
                this.renderRow(form, index);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void renderRow(FormBlackListInfo form, int rowIndex) {
        this.getModel().setValue(KEY_FORM, (Object)form.getFormNumber(), rowIndex);
        this.getModel().setValue(KEY_FORMID, (Object)form.getFormId(), rowIndex);
        this.getModel().setValue(KEY_FORMNUMBER, (Object)form.getFormNumber(), rowIndex);
        this.getModel().setValue(KEY_FORMNAME, (Object)form.getFormName(), rowIndex);
        this.getModel().setValue(KEY_APPID, (Object)form.getAppId(), rowIndex);
        this.getModel().setValue(KEY_CONTROLS, (Object)form.getControlDisplay(), rowIndex);
        this.getModel().setValue(KEY_CONTROLS_INNER, (Object)form.getControlInner(), rowIndex);
        this.getModel().setValue(KEY_FIELDS, (Object)form.getFieldDisplay(), rowIndex);
        this.getModel().setValue(KEY_FIELDS_INNER, (Object)form.getFieldInner(), rowIndex);
        this.getModel().setValue(KEY_LISTFIELDS, (Object)form.getListFieldDisplay(), rowIndex);
        this.getModel().setValue(KEY_LISTFIELDS_INNER, (Object)form.getListFieldInner(), rowIndex);
        this.getModel().setValue(KEY_LISTCTLS, (Object)form.getListCtlDisplay(), rowIndex);
        this.getModel().setValue(KEY_LISTCTLS_INNER, (Object)form.getListCtlInner(), rowIndex);
        this.getModel().setValue(KEY_DISABLE, (Object)form.isDisable(), rowIndex);
        this.getModel().setValue(KEY_ID, (Object)form.getId(), rowIndex);
    }

    protected boolean existScheme(String formId) {
        List<FormBlackListInfo> allBlackLists = this.getBlackListCache();
        if (allBlackLists == null || allBlackLists.isEmpty()) {
            return false;
        }
        for (FormBlackListInfo blackList : allBlackLists) {
            if (!formId.equals(blackList.getFormId())) continue;
            return true;
        }
        return false;
    }

    private void putBlackListCache(List<FormBlackListInfo> blackLists) {
        String blackListsJsonString = SerializationUtils.toJsonString(blackLists);
        this.getPageCache().put(CACHEID_BLACKLIST, blackListsJsonString);
        this.blackListInfos = blackLists;
    }

    private List<FormBlackListInfo> getBlackListCache() {
        if (this.blackListInfos != null) {
            return this.blackListInfos;
        }
        String blackListJsonString = this.getPageCache().get(CACHEID_BLACKLIST);
        this.blackListInfos = StringUtils.isBlank((CharSequence)blackListJsonString) ? this.loadAllFormBlackList() : SerializationUtils.fromJsonStringToList((String)blackListJsonString, FormBlackListInfo.class);
        return this.blackListInfos;
    }

    private List<FormBlackListInfo> loadAllFormBlackList() {
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_APPID);
        QFilter[] filters = null;
        filters = StringUtils.isBlank((CharSequence)appId) ? new QFilter[]{new QFilter("type", "=", (Object)"0"), new QFilter("modeltype", "!=", (Object)"PrintModel")} : new QFilter[]{new QFilter("type", "=", (Object)"0"), new QFilter("bizappid", "=", (Object)appId), new QFilter("modeltype", "!=", (Object)"PrintModel")};
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        Map bizObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid,name", (QFilter[])filters);
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormBlackList(modelType, appId, bizObjMap);
        if (bizObjMap != null) {
            ArrayList<FormBlackListInfo> allForms = new ArrayList<FormBlackListInfo>(10);
            boolean isNeedRepairData = false;
            for (Map.Entry entry : bizObjMap.entrySet()) {
                DynamicObject obj = (DynamicObject)entry.getValue();
                String formId = (String)entry.getKey();
                FormBlackListInfo formInfo = formInfos.get(formId);
                if (formInfo != null) {
                    if (formInfo.getFormNumber() == "") {
                        formInfo.setFormNumber(obj.getString(KEY_NUMBER));
                        formInfo.setFormName(obj.getString("name"));
                        isNeedRepairData = true;
                    }
                    allForms.add(formInfo);
                    continue;
                }
                String formNum = obj.getString(KEY_NUMBER);
                String formName = obj.getString("name");
                long id = DB.genGlobalLongId();
                FormBlackListInfo info = new FormBlackListInfo(id, appId, formId, formName, formNum);
                info.setDisable(false);
                info.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
                allForms.add(info);
            }
            if (isNeedRepairData) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u5f53\u524d\u5e94\u7528\u5b58\u5728\u9ed1\u540d\u5355\u810f\u6570\u636e\uff0c\u5bfc\u51fa\u6587\u4ef6\u65f6\u4f1a\u62a5\u9519\uff0c\u8bf7\u524d\u5f80 bos_clearblacklistcache \u9875\u9762\u70b9\u51fb\u4fee\u590d\u810f\u6570\u636e\u3002", (String)"FormBlackListPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            }
            return allForms;
        }
        return new ArrayList<FormBlackListInfo>(10);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedPropertyName = e.getProperty().getName();
        if (KEY_DISABLE.equals(changedPropertyName) || KEY_CONTROLS_INNER.equals(changedPropertyName) || KEY_FIELDS_INNER.equals(changedPropertyName) || KEY_LISTFIELDS_INNER.equals(changedPropertyName) || KEY_LISTCTLS_INNER.equals(changedPropertyName)) {
            FormBlackListInfo info = this.getSelectBlacList();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            String controlStrInner = (String)this.getModel().getValue(KEY_CONTROLS_INNER, rowIndex);
            String controlStr = (String)this.getModel().getValue(KEY_CONTROLS, rowIndex);
            String fieldStrInner = (String)this.getModel().getValue(KEY_FIELDS_INNER, rowIndex);
            String fieldlStr = (String)this.getModel().getValue(KEY_FIELDS, rowIndex);
            String listFieldStrInner = (String)this.getModel().getValue(KEY_LISTFIELDS_INNER, rowIndex);
            String listFieldlStr = (String)this.getModel().getValue(KEY_LISTFIELDS, rowIndex);
            String listCtlStr = (String)this.getModel().getValue(KEY_LISTCTLS, rowIndex);
            String listCtlStrInner = (String)this.getModel().getValue(KEY_LISTCTLS_INNER, rowIndex);
            Boolean disable = (Boolean)this.getModel().getValue(KEY_DISABLE, rowIndex);
            if (info == null) {
                DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID, rowIndex);
                String appId = app == null ? "" : app.getPkValue().toString();
                String formId = (String)this.getModel().getValue(KEY_FORMID, rowIndex);
                String formNumber = (String)this.getModel().getValue(KEY_FORMNUMBER, rowIndex);
                DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
                String formName = form == null ? "" : form.getString("name");
                long id = DB.genGlobalLongId();
                info = new FormBlackListInfo(id, appId, formId, formName, formNumber);
            }
            info.setControlDisplay(controlStr);
            info.setControlInner(controlStrInner);
            info.setFieldDisplay(fieldlStr);
            info.setFieldInner(fieldStrInner);
            info.setListFieldDisplay(listFieldlStr);
            info.setListFieldInner(listFieldStrInner);
            info.setListCtlDisplay(listCtlStr);
            info.setListCtlInner(listCtlStrInner);
            info.setDisable(disable);
            String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
            FormBlackListSaveHelper.updateToDB(modelType, info);
        }
    }

    private void saveAllForms() {
        DynamicObjectCollection entryRows = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryRows == null || entryRows.isEmpty()) {
            return;
        }
        HashMap<String, FormBlackListInfo> infos = new HashMap<String, FormBlackListInfo>(entryRows.size());
        for (DynamicObject row : entryRows) {
            DynamicObject app = row.getDynamicObject(KEY_APPID);
            String appId = app == null ? "" : app.getPkValue().toString();
            DynamicObject form = row.getDynamicObject(KEY_FORM);
            String name = form == null ? "" : form.getString("name");
            String formId = row.getString(KEY_FORMID);
            String number = row.getString(KEY_FORMNUMBER);
            boolean disable = row.getBoolean(KEY_DISABLE);
            String controlStr = row.getString(KEY_CONTROLS);
            String controlStrInner = row.getString(KEY_CONTROLS_INNER);
            String fieldStr = row.getString(KEY_FIELDS);
            String fieldStrInner = row.getString(KEY_FIELDS_INNER);
            String listFieldStr = row.getString(KEY_LISTFIELDS);
            String listFieldStrInner = row.getString(KEY_LISTFIELDS_INNER);
            String listCtlStr = row.getString(KEY_LISTCTLS);
            String listCtlStrInner = row.getString(KEY_LISTCTLS_INNER);
            long id = DB.genGlobalLongId();
            FormBlackListInfo info = new FormBlackListInfo(id, appId, formId, name, number);
            info.setDisable(disable);
            info.setControlDisplay(controlStr);
            info.setControlInner(controlStrInner);
            info.setFieldDisplay(fieldStr);
            info.setFieldInner(fieldStrInner);
            info.setListFieldDisplay(listFieldStr);
            info.setListFieldInner(listFieldStrInner);
            info.setListCtlDisplay(listCtlStr);
            info.setListCtlInner(listCtlStrInner);
            infos.put(formId, info);
        }
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PRODUCTMODEL);
        FormBlackListSaveHelper.updateToDBBatch(modelType, infos);
    }

    private boolean hasEntity() {
        String formNumber;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORM, rowIndex);
        String string = formNumber = form == null ? "" : form.getString(KEY_NUMBER);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return false;
        }
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        return !StringUtils.isBlank((CharSequence)formId);
    }
}

