/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FunctionBlackListEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_MENUNAME = "menuname";
    private static final String KEY_APPID = "appid";
    private static final String KEY_MENUID = "menuid";
    private static final String KEY_FORMID = "formid";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel", KEY_MENUNAME});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_APPID);
        String menuId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_MENUID);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_FORMID);
        this.getModel().setValue(KEY_APPID, (Object)appId);
        this.getModel().setValue(KEY_MENUID, (Object)menuId);
        this.getModel().setValue(KEY_FORMID, (Object)formId);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "menuname": {
                this.showSelectMenu();
                break;
            }
            case "btnok": {
                this.returnDataAndClose();
                break;
            }
        }
    }

    private void showSelectMenu() {
        String appId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_function_select_edit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID);
        String string = appId = app == null ? "" : app.getPkValue().toString();
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e94\u7528\u3002", (String)"FunctionBlackListEditPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        showParameter.getCustomParams().put(KEY_APPID, appId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "functionSelect");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("functionSelect".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            String menuesStr = (String)returnData.get("Menues");
            List menues = (List)SerializationUtils.fromJsonString((String)menuesStr, List.class);
            Map menu = (Map)menues.get(0);
            this.getModel().setValue(KEY_APPID, menu.get(KEY_APPID));
            this.getModel().setValue(KEY_MENUID, menu.get(KEY_MENUID));
            this.getModel().setValue(KEY_FORMID, menu.get("formNumber"));
            this.getModel().setValue(KEY_MENUNAME, menu.get(KEY_MENUNAME));
            this.getModel().setValue("menunumber", menu.get("menuNumber"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        String callBackId = messageboxclosedevent.getCallBackId();
        if ("continue_save".equals(callBackId) && messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.returnDataAndClose();
        }
    }

    private void returnDataAndClose() {
        HashMap<String, String> para = new HashMap<String, String>(16);
        DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID);
        String menuId = (String)this.getModel().getValue(KEY_MENUID);
        DynamicObject form = (DynamicObject)this.getModel().getValue(KEY_FORMID);
        String menuName = (String)this.getModel().getValue(KEY_MENUNAME);
        String menuNumber = (String)this.getModel().getValue("menuNumber");
        if (app == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunctionBlackListEditPlugin_5", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        if (menuId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunctionBlackListEditPlugin_6", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        if (form == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunctionBlackListEditPlugin_7", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        String appId = app.getPkValue().toString();
        String appName = app.getString("name");
        String formId = form.getPkValue().toString();
        String formNumber = form.getString("number");
        String formName = form.getString("name");
        para.put(KEY_APPID, appId);
        para.put("appname", appName);
        para.put(KEY_MENUID, menuId);
        para.put(KEY_MENUNAME, menuName);
        para.put("menunumber", menuNumber);
        para.put(KEY_FORMID, formId);
        para.put("formname", formName);
        para.put("formnumber", formNumber);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

