/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FunctionBlackListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static final String KEY_NEW = "new";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SEARCHBLACKLIST = "searchblacklist";
    private static final String CACHEID_BLACKLIST = "BlackList_CacheId";
    private static final String FORMID_NEWFUNCTIONBLACKLIST = "bos_function_black_edit";
    private static final String KEY_APP = "app";
    private static final String KEY_APPID = "appid";
    private static final String KEY_APPNAME = "appname";
    private static final String KEY_MENUID = "menuid";
    private static final String KEY_MENUNAME = "menuname";
    private static final String KEY_MENUNUMBER = "menunumber";
    private static final String KEY_FORMID = "formid";
    private static final String KEY_FORMNAME = "formname";
    private static final String KEY_FORMNUMBER = "formnumber";
    private List<FunctionBlackListInfo> blackListInfos;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCHBLACKLIST);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_BLACKLIST);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<FunctionBlackListInfo> allfunctionBlackList = this.loadAllfunctionBlackList();
        this.putBlackListCache(allfunctionBlackList);
        this.doSearch("");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = e.getOperateKey();
        if (opKey.equalsIgnoreCase(KEY_NEW)) {
            this.doNew();
        } else if (opKey.equalsIgnoreCase(KEY_MODIFY)) {
            this.doModify();
        } else if (opKey.equalsIgnoreCase(KEY_DELETE)) {
            this.doBeforeDelete();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(KEY_NEW)) {
            this.afterShowNewForm(closedCallBackEvent, KEY_NEW);
        } else if (actionId.equalsIgnoreCase(KEY_MODIFY)) {
            this.afterShowNewForm(closedCallBackEvent, KEY_MODIFY);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doDelete();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.doModify();
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCHBLACKLIST, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearch(searchText);
        }
    }

    private void doNew() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_NEWFUNCTIONBLACKLIST);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_NEW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doModify() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"FunctionBlackListPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        String appId = (String)this.getModel().getValue(KEY_APPID, rowIndex);
        String appName = (String)this.getModel().getValue(KEY_APPNAME, rowIndex);
        String menuId = (String)this.getModel().getValue(KEY_MENUID, rowIndex);
        String menuName = (String)this.getModel().getValue(KEY_MENUNAME, rowIndex);
        String formId = (String)this.getModel().getValue(KEY_FORMID, rowIndex);
        String formName = (String)this.getModel().getValue(KEY_FORMNAME, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_NEWFUNCTIONBLACKLIST);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(KEY_APPID, (Object)appId);
        showParameter.setCustomParam(KEY_APPNAME, (Object)appName);
        showParameter.setCustomParam(KEY_MENUID, (Object)menuId);
        showParameter.setCustomParam(KEY_MENUNAME, (Object)menuName);
        showParameter.setCustomParam(KEY_FORMID, (Object)formId);
        showParameter.setCustomParam(KEY_FORMNAME, (Object)formName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_MODIFY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doBeforeDelete() {
        FunctionBlackListInfo blackList = this.getSelectBlacList();
        if (blackList != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
            String strDeleteConfirmTip = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u5220\u9664[%s]\u5417\uff1f", (String)"FunctionBlackListPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]), blackList.getMenuName());
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
            return;
        }
    }

    private void doDelete() {
        FunctionBlackListInfo blackList = this.getSelectBlacList();
        if (blackList == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25\uff01", (String)"FunctionBlackListPlugin_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        this.getModel().deleteEntryRow(KEY_ENTRYENTITY, rowIndex);
        List<FunctionBlackListInfo> allBlackList = this.getBlackListCache();
        allBlackList.remove(blackList);
        this.putBlackListCache(allBlackList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"FunctionBlackListPlugin_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
    }

    private FunctionBlackListInfo getSelectBlacList() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selRows = grid.getSelectRows();
        if (rowCount == 0 || rowIndex < 0 || selRows == null || selRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55", (String)"FunctionBlackListPlugin_0", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return null;
        }
        String fid = (String)this.getModel().getValue(KEY_MENUID, rowIndex);
        List<FunctionBlackListInfo> allBlackLists = this.getBlackListCache();
        FunctionBlackListInfo blackList = null;
        for (FunctionBlackListInfo function : allBlackLists) {
            if (!fid.equals(function.getMenuId())) continue;
            blackList = function;
            break;
        }
        return blackList;
    }

    private void doSearch(String searchText) {
        List<FunctionBlackListInfo> allBlackLists = this.getBlackListCache();
        ArrayList<FunctionBlackListInfo> blackLists = new ArrayList<FunctionBlackListInfo>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            blackLists.addAll(allBlackLists);
        } else {
            for (FunctionBlackListInfo function : allBlackLists) {
                if ((!StringUtils.isNotBlank((CharSequence)function.getMenuName()) || function.getMenuName().indexOf(searchText) < 0) && (!StringUtils.isNotBlank((CharSequence)function.getMenuId()) || function.getMenuId().indexOf(searchText) < 0)) continue;
                blackLists.add(function);
            }
        }
        this.refreshEntryGrid(blackLists);
    }

    private void refreshEntryGrid(List<FunctionBlackListInfo> functionBlackLists) {
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        if (!functionBlackLists.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, functionBlackLists.size());
            for (int index = 0; index < functionBlackLists.size(); ++index) {
                FunctionBlackListInfo function = functionBlackLists.get(index);
                this.renderRow(function, index);
            }
            this.getModel().endInit();
        }
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void afterShowNewForm(ClosedCallBackEvent closedCallBackEvent, String actionId) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params == null) {
            return;
        }
        String appId = (String)params.get(KEY_APPID);
        String appName = (String)params.get(KEY_APPNAME);
        String menuId = (String)params.get(KEY_MENUID);
        String menuName = (String)params.get(KEY_MENUNAME);
        String menuNumber = (String)params.get(KEY_MENUNUMBER);
        String formId = (String)params.get(KEY_FORMID);
        String formName = (String)params.get(KEY_FORMNAME);
        String formNumber = (String)params.get(KEY_FORMNUMBER);
        FunctionBlackListInfo function = new FunctionBlackListInfo(appId, appName, menuId, menuName, menuNumber, formId, formName, formNumber);
        List<FunctionBlackListInfo> allBlackLists = this.getBlackListCache();
        if (actionId.equalsIgnoreCase(KEY_MODIFY)) {
            allBlackLists.remove(this.getSelectBlacList());
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            allBlackLists.add(function);
            this.putBlackListCache(allBlackLists);
            this.renderRow(function, rowIndex);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"FunctionBlackListPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            return;
        }
        allBlackLists.add(function);
        this.putBlackListCache(allBlackLists);
        this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
        int rowIndex = this.getModel().getEntryRowCount(KEY_ENTRYENTITY) - 1;
        this.renderRow(function, rowIndex);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"FunctionBlackListPlugin_4", (String)"bos-productmodel-resource", (Object[])new Object[0]));
    }

    private void renderRow(FunctionBlackListInfo function, int rowIndex) {
        this.getModel().setValue(KEY_APP, (Object)function.getAppId(), rowIndex);
        this.getModel().setValue(KEY_APPID, (Object)function.getAppId(), rowIndex);
        this.getModel().setValue(KEY_APPNAME, (Object)function.getAppName(), rowIndex);
        this.getModel().setValue(KEY_MENUID, (Object)function.getMenuId(), rowIndex);
        this.getModel().setValue(KEY_MENUNAME, (Object)function.getMenuName(), rowIndex);
        this.getModel().setValue(KEY_MENUNUMBER, (Object)function.getMenuNumber(), rowIndex);
        this.getModel().setValue(KEY_FORMID, (Object)function.getFormId(), rowIndex);
        this.getModel().setValue(KEY_FORMNAME, (Object)function.getFormName(), rowIndex);
        this.getModel().setValue(KEY_FORMNUMBER, (Object)function.getFormNumber(), rowIndex);
    }

    protected boolean existScheme(String functionId) {
        List<FunctionBlackListInfo> allBlackLists = this.getBlackListCache();
        if (allBlackLists == null || allBlackLists.isEmpty()) {
            return false;
        }
        for (FunctionBlackListInfo blackList : allBlackLists) {
            if (!functionId.equals(blackList.getMenuId())) continue;
            return true;
        }
        return false;
    }

    private void putBlackListCache(List<FunctionBlackListInfo> blackLists) {
        String blackListsJsonString = SerializationUtils.toJsonString(blackLists);
        this.getPageCache().put(CACHEID_BLACKLIST, blackListsJsonString);
        this.blackListInfos = blackLists;
    }

    private List<FunctionBlackListInfo> getBlackListCache() {
        if (this.blackListInfos != null) {
            return this.blackListInfos;
        }
        String blackListJsonString = this.getPageCache().get(CACHEID_BLACKLIST);
        this.blackListInfos = StringUtils.isBlank((CharSequence)blackListJsonString) ? new ArrayList<FunctionBlackListInfo>() : SerializationUtils.fromJsonStringToList((String)blackListJsonString, FunctionBlackListInfo.class);
        return this.blackListInfos;
    }

    private List<FunctionBlackListInfo> loadAllfunctionBlackList() {
        return new ArrayList<FunctionBlackListInfo>(10);
    }

    private void delete(String schemeId) {
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.doModify();
    }
}

