/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.designer.productmodel.model.FunctionBlackListInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class FunctionSelectPlugin
extends AbstractFormPlugin {
    private static final String KEY_APPID = "appid";
    private static final String Key_EntryEntity = "entryentity";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = (String)this.getView().getFormShowParameter().getCustomParam(KEY_APPID);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("productmodel");
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        ArrayList<String> selectMenuIds = new ArrayList<String>(10);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            List selectMenu = SerializationUtils.fromJsonStringToList((String)value, FunctionBlackListInfo.class);
            for (FunctionBlackListInfo info : selectMenu) {
                selectMenuIds.add(info.getMenuId());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String appName;
            AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
            List menues = appMeta.getAppMenus();
            String string = appName = appMeta.getName() == null ? "" : appMeta.getName().getLocaleValue();
            if (menues != null && !menues.isEmpty()) {
                IDataModel model = this.getModel();
                model.batchCreateNewEntryRow(Key_EntryEntity, menues.size());
                int i = 0;
                boolean j = false;
                for (AppMenuElement menu : menues) {
                    String id = menu.getId();
                    String name = menu.getName() == null ? "" : menu.getName().getLocaleValue();
                    String number = menu.getNumber();
                    String formName = menu.getFormName() == null ? "" : menu.getFormName();
                    String formNumber = menu.getFormNumber();
                    String formId = menu.getFormId();
                    boolean disEnable = false;
                    if (formInfos.get(formId) != null) {
                        FormBlackListInfo formInfo = formInfos.get(formId);
                        disEnable = formInfo.isDisable();
                    }
                    if (StringUtils.isBlank((CharSequence)formId)) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"disenable"});
                    }
                    model.setValue(KEY_APPID, (Object)appId, i);
                    model.setValue("appname", (Object)appName, i);
                    model.setValue("menuid", (Object)id, i);
                    model.setValue("menuname", (Object)name, i);
                    model.setValue("menunumber", (Object)number, i);
                    model.setValue("formid", (Object)formNumber, i);
                    model.setValue("formname", (Object)formName, i);
                    model.setValue("formpkid", (Object)formId, i);
                    model.setValue("disenable", (Object)disEnable, i);
                    boolean isChecked = false;
                    if (selectMenuIds.contains(id)) {
                        isChecked = true;
                    }
                    model.setValue("ischecked", (Object)isChecked, i);
                    ++i;
                }
                this.getPageCache().put("value", SerializationUtils.toJsonString((Object)menues));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnData();
        }
    }

    private List<FunctionBlackListInfo> getSelectedMenu() {
        ArrayList<FunctionBlackListInfo> menues = new ArrayList<FunctionBlackListInfo>(1);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(Key_EntryEntity);
        int rowCount = this.getModel().getEntryRowCount(Key_EntryEntity);
        HashMap<String, FormBlackListInfo> updateFormMap = new HashMap<String, FormBlackListInfo>(10);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("productmodel");
        Map<String, FormBlackListInfo> formInfos = FormBlackListSaveHelper.getFormFromDB(modelType);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                String formNumber;
                Boolean isChecked = (Boolean)this.getModel().getValue("ischecked", i);
                String formPkId = (String)this.getModel().getValue("formpkid", i);
                DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID, i);
                String appId = app == null ? "" : app.getPkValue().toString();
                String appName = (String)this.getModel().getValue("appname", i);
                String menuId = (String)this.getModel().getValue("menuid", i);
                String menuName = (String)this.getModel().getValue("menuname", i);
                String menuNumber = (String)this.getModel().getValue("menunumber", i);
                DynamicObject form = (DynamicObject)this.getModel().getValue("formid", i);
                String formId = form == null ? "" : form.getPkValue().toString();
                String formName = (String)this.getModel().getValue("formname", i);
                String string = formNumber = form == null ? "" : form.getString("number");
                if (isChecked.booleanValue()) {
                    FunctionBlackListInfo menu = new FunctionBlackListInfo(appId, appName, menuId, menuName, menuNumber, formId, formName, formNumber);
                    menues.add(menu);
                }
                if (!StringUtils.isNotBlank((CharSequence)formPkId)) continue;
                Boolean disEnable = (Boolean)this.getModel().getValue("disenable", i);
                FormBlackListInfo formInfo = formInfos.get(formPkId);
                if (formInfo == null) {
                    formInfo = new FormBlackListInfo(appId, formPkId, formName, formNumber);
                    formInfo.setModelType(ProductModeTypeUtil.getType(modelType).getValue());
                }
                formInfo.setDisable(disEnable);
                updateFormMap.put(formPkId, formInfo);
            }
        }
        this.updateFormBlackList(modelType, updateFormMap);
        return menues;
    }

    private void updateFormBlackList(String modelType, Map<String, FormBlackListInfo> formMap) {
        if (formMap == null || formMap.isEmpty()) {
            return;
        }
        FormBlackListSaveHelper.updateToDBBatch(modelType, formMap);
    }

    private void returnData() {
        List<FunctionBlackListInfo> data = this.getSelectedMenu();
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("Menues", SerializationUtils.toJsonString(data));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("ischecked".equals(e.getProperty().getName())) {
            String formId;
            Boolean isChecked = (Boolean)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_EntryEntity);
            DynamicObject form = (DynamicObject)this.getModel().getValue("formid", rowIndex);
            String string = formId = form == null ? "" : form.getPkValue().toString();
            if (StringUtils.isNotBlank((CharSequence)formId)) {
                this.getModel().setValue("disenable", (Object)isChecked, rowIndex);
            }
        }
    }
}

