/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.AbstractSelectPlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class ListPropSelectPlugin
extends AbstractSelectPlugin
implements TreeNodeCheckListener {
    @Override
    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        Map<String, Object> fieldTree = null;
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formNumber");
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return;
        }
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        Map listToolBar = FormMetadataCache.getListToolBar((String)formNumber);
        if (listToolBar == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u5355\u7f16\u7801\u3010%1$s\u3011\u7684\u8868\u5355\u6ca1\u6709\u5217\u8868\u5de5\u5177\u680f\u5143\u6570\u636e\uff0c\u65e0\u9700\u914d\u7f6e\u3002", (String)"ListPropSelectPlugin_1", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNumber));
            return;
        }
        fieldTree = this.createFieldsTree(listToolBar, formNumber);
        TreeNode root = TreeNode.Parse((String)"", fieldTree, (String)"Id", (String)"Name", (String)"Items");
        root.setIsOpened(true);
        root.setExpend(true);
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.addNode(root);
        this.buildTreeNode(value, root, tree);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    private Map<String, Object> createFieldsTree(Map<String, Object> listToolBar, String formNumber) {
        HashMap<String, Object> node = new HashMap<String, Object>(4);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)formNumber);
        if (listToolBar == null || listToolBar.isEmpty()) {
            return node;
        }
        node.put("Id", listToolBar.get("id"));
        node.put("Type", listToolBar.get("type"));
        node.put("Name", type.getDisplayName().getLocaleValue_zh_CN());
        node.put("CreateType", 1);
        ArrayList nodeItems = new ArrayList();
        node.put("Items", nodeItems);
        List items = (List)listToolBar.get("items");
        for (Map item : items) {
            String itemType = (String)item.get("type");
            String id = (String)item.get("id");
            String name = this.getName(item, "text");
            List secItems = (List)item.get("items");
            ArrayList secNodeItems = new ArrayList(10);
            HashMap<String, Object> secNode = new HashMap<String, Object>(3);
            if (secItems != null && !secItems.isEmpty()) {
                secNode.put("Id", id + "_title");
                secNode.put("Type", itemType + "_main");
                secNode.put("Name", name);
                nodeItems.add(secNode);
                secNode.put("Items", secNodeItems);
                HashMap<String, String> firstNode = new HashMap<String, String>(3);
                firstNode.put("Id", id);
                firstNode.put("Type", itemType);
                firstNode.put("Name", this.formatName(name, id));
                secNodeItems.add(firstNode);
                for (Map baritem : secItems) {
                    String fieldName = this.getName(baritem, "title");
                    HashMap fieldNode = new HashMap(3);
                    fieldNode.put("Id", baritem.get("key"));
                    fieldNode.put("Type", baritem.get("operationKey"));
                    fieldNode.put("Name", this.formatName(fieldName, (String)baritem.get("key")));
                    secNodeItems.add(fieldNode);
                }
                continue;
            }
            secNode.put("Id", id);
            secNode.put("Type", itemType);
            secNode.put("Name", this.formatName(name, id));
            nodeItems.add(secNode);
        }
        return node;
    }

    private String getName(Map<String, Object> item, String key) {
        String name = "";
        if (item == null) {
            return name;
        }
        Object o = item.get(key);
        if (o instanceof Map) {
            Map map = (Map)o;
            name = (String)map.get("zh_CN");
        }
        return name;
    }

    private String formatName(String name, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return name;
        }
        return name + "(" + key + ")";
    }

    @Override
    protected String getFormatName(String name, String key) {
        return name;
    }
}

