/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.productmodel;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.ProductModeTypeUtil;
import kd.bos.designer.productmodel.model.FormBlackListInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.AbstractFormPlugin;

public class RepairFormDataHelper
extends AbstractFormPlugin {
    private String modelType = "";

    public RepairFormDataHelper(String modelType) {
        this.modelType = modelType;
    }

    protected String repairFormData() {
        Map<String, FormBlackListInfo> dirtyData = RepairFormDataHelper.getDirtyDataFromDB(this.modelType);
        if (dirtyData.isEmpty()) {
            return "";
        }
        String localeId = Locale.getDefault().toString();
        Map<Object, List<String>> formMetaData = RepairFormDataHelper.getFormMetaData(dirtyData.keySet(), localeId);
        return this.repairFormDataHelper(this.modelType, dirtyData, formMetaData);
    }

    private static Map<String, FormBlackListInfo> getDirtyDataFromDB(String modelType) {
        String sql = String.format("select FID, FAPPID, FFORMID, FFORMNUM, FFORMNAME, FDISABLE, FFIELDS, FCONTROLS, FLISTFIELDS, FLISTCTLS, FMODELTYPE from %s where FMODELTYPE = '%s' and FFORMNUM = ' ' ", "T_BAS_FormBlackList", ProductModeTypeUtil.getType(modelType).getValue());
        ResultSetHandler callBackHanlder = rs -> {
            HashMap<String, FormBlackListInfo> map = new HashMap<String, FormBlackListInfo>(16);
            try {
                while (rs.next()) {
                    long id = rs.getLong("FID");
                    String appId = rs.getString("FAPPID");
                    String formId = rs.getString("FFORMID");
                    String formNum = rs.getString("FFORMNUM");
                    String formName = rs.getString("FFORMNAME");
                    String fields = rs.getString("FFIELDS");
                    String controls = rs.getString("FCONTROLS");
                    String listFields = rs.getString("FLISTFIELDS");
                    String listCtls = rs.getString("FLISTCTLS");
                    boolean disable = rs.getBoolean("FDISABLE");
                    int type = rs.getInt("FMODELTYPE");
                    FormBlackListInfo info = new FormBlackListInfo(id, appId, formId, formName, formNum, fields, controls);
                    info.setListFieldInner(listFields);
                    info.setListCtlInner(listCtls);
                    info.setDisable(disable);
                    info.setModelType(type);
                    map.put(formId, info);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)callBackHanlder);
    }

    private static Map<Object, List<String>> getFormMetaData(Set<String> ids, String localeId) {
        String formIds = RepairFormDataHelper.changeSetToStr(ids);
        if (formIds.isEmpty()) {
            return new HashMap<Object, List<String>>();
        }
        String sql = String.format("select distinct fid,fnumber,fname from t_meta_formdesign_l where fid in (%s) and  flocaleid = '%s'", formIds, localeId);
        ResultSetHandler handler = rs -> {
            HashMap map = new HashMap();
            try {
                while (rs.next()) {
                    String formId = rs.getString("fid");
                    String formNum = rs.getString("fnumber");
                    String formName = rs.getString("fname");
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(formNum);
                    list.add(formName);
                    map.put(formId, list);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return map;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)handler);
    }

    private static String changeSetToStr(Set<String> idsOrNums) {
        if (idsOrNums == null || idsOrNums.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String idOrNum : idsOrNums) {
            sb.append("'");
            sb.append(idOrNum);
            sb.append("',");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    private String repairFormDataHelper(String modelType, Map<String, FormBlackListInfo> dirtyData, Map<Object, List<String>> formMetaData) {
        if (formMetaData == null || formMetaData.isEmpty()) {
            return "";
        }
        ArrayList<String> dirtyFormNums = new ArrayList<String>();
        for (Map.Entry<String, FormBlackListInfo> entry : dirtyData.entrySet()) {
            String formId = entry.getKey();
            FormBlackListInfo info = entry.getValue();
            List<String> list = formMetaData.get(formId);
            if (info == null || info.getFormNumber() != "" || list == null || list.isEmpty()) continue;
            String formNum = list.get(0);
            String formName = list.get(1);
            info.setFormNumber(formNum);
            info.setFormName(formName);
            dirtyData.put(formId, info);
            dirtyFormNums.add(formNum);
        }
        FormBlackListSaveHelper.updateToDBBatch(modelType, dirtyData);
        return StringUtils.join((Object[])dirtyFormNums.toArray(), (String)"\u3001");
    }

    protected String deleteUseless() {
        List<String> numsList = this.getUselessNums();
        this.deleteUselessHelper();
        return StringUtils.join((Object[])numsList.toArray(), (String)"\u3001");
    }

    private List<String> getUselessNums() {
        String sql = String.format("select distinct bl.fformnum from %s bl where bl.fformid not in (select meta.fid from t_meta_formdesign meta)", "T_BAS_FormBlackList");
        ResultSetHandler handler = rs -> {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (rs.next()) {
                    String formNum = rs.getString("fformnum");
                    list.add(formNum);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return list;
        };
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)handler);
    }

    private void deleteUselessHelper() {
        String deleteSql = "delete from t_bas_formblacklist bl where bl.fformid in (select bl.fformid from t_bas_formblacklist bl where bl.fformid not in (select meta.fid from t_meta_formdesign meta))";
        DB.execute((DBRoute)DBRoute.meta, (String)deleteSql);
    }
}

