/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.ProductFileUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class BlackSettingCacheManager {
    private static final String KEY_FUNUMNBER = "fnumber";
    private static final String KEY_FORBIDALL = "forbidall";
    private static final String KEY_BLACKAPP = "blackapp";
    private static final String KEY_FBIZAPPID = "fbizappid";
    static String KEY_ORIGINDATA = "product.blackfile";
    static String KEY_CACHEDATA = "product.blacklistdata";
    private static final String[] BOS_CLOUD_NUMBERS = new String[]{"dev", "demo", "eip", "wfs"};
    private static final String[] EXT_CLOUD_NUMBERS = new String[]{"esc", "icc", "fi", "ec", "taxc", "macc", "imc", "epm", "tmc", "odc", "hr", "swc", "hrmp", "pmgt", "scmc", "pur", "drp", "occ", "mmc", "qmc", "pccs", "mpscmm", "bamp", "data", "sit", "ai", "sys", "bsc", "rpac"};
    private static Log log = LogFactory.getLog(BlackSettingCacheManager.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
    private static int localTimeoutSeconds = Integer.getInteger("sys.modeltype.localtimeout", 1800);
    private static int redisTimeoutSeconds = Integer.getInteger("sys.modeltype.redistimeout", 7200);
    private static final String WHITELISTENABLE = "sys.cloudwhitelist.enable";
    private static boolean applyWhiteList = true;

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(localTimeoutSeconds);
        info.setMaxMemSize(300);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("sys_modeltype", "blacklistdata", info);
    }

    protected static int getProductModel() {
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s", "blacksettingcache_modeltype_", rc.getAccountId());
        Integer type = (Integer)ThreadCache.get((Object)key, () -> {
            ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
            return service.getModeType();
        });
        return type;
    }

    private static String getCacheDataKey() {
        return KEY_CACHEDATA + "." + BlackSettingCacheManager.getProductModel();
    }

    private static String getOriginDataKey() {
        RequestContext rs = RequestContext.get();
        return KEY_ORIGINDATA + ".key" + rs.getAccountId() + "." + BlackSettingCacheManager.getProductModel();
    }

    protected static ProductBlackList getDataFromCahe() {
        String str = (String)cache.get(BlackSettingCacheManager.getOriginDataKey());
        ProductBlackList data = null;
        if (StringUtils.isBlank((CharSequence)str)) {
            data = BlackSettingCacheManager.loadBlackListSetting();
            cache.put(BlackSettingCacheManager.getOriginDataKey(), (Object)SerializationUtils.toJsonString((Object)data), redisTimeoutSeconds);
        } else {
            data = (ProductBlackList)SerializationUtils.fromJsonString((String)str, ProductBlackList.class);
        }
        return data;
    }

    protected static void clearAllCacheData() {
        ThreadPools.executeOnce((String)"productcacheclear", (Runnable)new Runnable(){

            @Override
            public void run() {
                List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
                for (Account account : accounts) {
                    RequestContextCreator.createBatch((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                    MetadataDao.cleanAllAppMetadataCache();
                    BlackSettingCacheManager.clearCacheData();
                }
            }
        });
    }

    protected static void clearCacheData(boolean force) {
        cache.remove(BlackSettingCacheManager.getOriginDataKey());
        cache.remove(BlackSettingCacheManager.getCacheDataKey());
        MetadataDao.cleanAllPortalAppCache();
        try {
            String sql = "select fid,fnumber,fbizcloudid from t_meta_bizapp";
            List ids = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                ArrayList<String> list = new ArrayList<String>(16);
                while (rs.next()) {
                    String appId = rs.getString(KEY_FUNUMNBER);
                    list.add(appId);
                }
                return list;
            });
            MetaCacheUtils.removeDistributeCache((String[])ids.toArray(new String[ids.size()]));
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u6a21\u5f0f\u91ca\u653e\u5e94\u7528\u7f13\u5b58\u5931\u8d25:" + e.getMessage());
        }
        BlackSettingCacheManager.getLocalCache().clear();
    }

    protected static void clearCacheData() {
        BlackSettingCacheManager.clearCacheData(true);
    }

    private static Map<String, String> getCacheData() {
        Map data = null;
        RequestContext rs = RequestContext.get();
        String str = (String)cache.get(BlackSettingCacheManager.getCacheDataKey(), rs.getAccountId());
        if (StringUtils.isBlank((CharSequence)str)) {
            ProductBlackList file = BlackSettingCacheManager.getDataFromCahe();
            data = file.buildCacheData();
            cache.put(BlackSettingCacheManager.getCacheDataKey(), rs.getAccountId(), SerializationUtils.toJsonString((Object)data), redisTimeoutSeconds);
        } else {
            data = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return data;
    }

    protected static Map<String, String> getAllAppInfoBlackList() {
        return BlackSettingCacheManager.getOrCreateLocalBlackAppInfo();
    }

    protected static Map<String, String> getAppBlackListByCloudId(String cloudId) {
        Map<String, Map<String, String>> localData = BlackSettingCacheManager.getOrCreateLocalCloudAppMapping();
        HashMap result = localData.get(cloudId);
        return result == null ? new HashMap(16) : result;
    }

    protected static List<String> getBlackFeatureByAppId(String appId) {
        ArrayList<String> blackFeatures = new ArrayList<String>();
        AppMetadata appMetadata = AppReader.loadMeta((String)appId, (boolean)true);
        if (appMetadata == null || appMetadata.getBizCloudID() == null) {
            return new ArrayList<String>();
        }
        Map<String, String> data = BlackSettingCacheManager.getCacheData();
        if (data == null) {
            return new ArrayList<String>();
        }
        block0: for (Map.Entry<String, String> row : data.entrySet()) {
            Map cloudInfo;
            Map map;
            if (!StringUtils.equalsIgnoreCase((CharSequence)row.getKey(), (CharSequence)appMetadata.getBizCloudID()) || (map = (Map)(cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class)).get(KEY_BLACKAPP)) == null || map.isEmpty()) continue;
            for (Map.Entry app : map.entrySet()) {
                if (!StringUtils.equals((CharSequence)appId, (CharSequence)((CharSequence)app.getKey()))) continue;
                List features = (List)((Map)app.getValue()).get("feature");
                if (features == null) continue block0;
                blackFeatures.addAll(features);
            }
        }
        return blackFeatures;
    }

    protected static List<String> getBlackMenuByAppId(String appId) {
        ArrayList<String> blackMenus = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return blackMenus;
        }
        AppMetadata appMetadata = AppReader.loadMeta((String)appId, (boolean)true);
        if (appMetadata.getBizCloudID() == null) {
            return new ArrayList<String>();
        }
        Map<String, String> data = BlackSettingCacheManager.getCacheData();
        if (data == null) {
            return new ArrayList<String>();
        }
        block0: for (Map.Entry<String, String> row : data.entrySet()) {
            Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
            if (!StringUtils.equalsIgnoreCase((CharSequence)row.getKey(), (CharSequence)appMetadata.getBizCloudID())) continue;
            if (Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) {
                for (AppMenuElement menuElement : appMetadata.getAppMenus()) {
                    blackMenus.add(menuElement.getId());
                }
                break;
            }
            Map map = (Map)cloudInfo.get(KEY_BLACKAPP);
            if (map == null || map.isEmpty()) continue;
            for (Map.Entry approw : map.entrySet()) {
                if (!StringUtils.equals((CharSequence)appId, (CharSequence)((CharSequence)approw.getKey()))) continue;
                if (Boolean.parseBoolean(String.valueOf(((Map)approw.getValue()).get(KEY_FORBIDALL)))) {
                    for (AppMenuElement menuElement : appMetadata.getAppMenus()) {
                        blackMenus.add(menuElement.getId());
                    }
                    continue block0;
                }
                Map m = (Map)((Map)approw.getValue()).get("menu");
                if (m == null) continue block0;
                blackMenus.addAll(m.keySet());
            }
        }
        return blackMenus;
    }

    protected static Map<String, List<String>> getBlackMenuAndApp(Map<String, String> appMap) {
        if (appMap == null || appMap.size() == 0) {
            return null;
        }
        ArrayList blackMenus = new ArrayList();
        ArrayList<String> blackAppIds = new ArrayList<String>();
        Map<String, String> data = BlackSettingCacheManager.getCacheData();
        if (data == null) {
            return null;
        }
        block0: for (Map.Entry<String, String> entry : appMap.entrySet()) {
            String cloudId = entry.getValue();
            String appId = entry.getKey();
            block1: for (Map.Entry<String, String> row : data.entrySet()) {
                Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
                if (!StringUtils.equalsIgnoreCase((CharSequence)row.getKey(), (CharSequence)cloudId)) continue;
                if (Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) {
                    blackAppIds.add(appId);
                    continue block0;
                }
                Map map = (Map)cloudInfo.get(KEY_BLACKAPP);
                if (map == null || map.isEmpty()) continue;
                for (Map.Entry approw : map.entrySet()) {
                    if (!StringUtils.equals((CharSequence)appId, (CharSequence)((CharSequence)approw.getKey()))) continue;
                    if (Boolean.parseBoolean(String.valueOf(((Map)approw.getValue()).get(KEY_FORBIDALL)))) {
                        blackAppIds.add(appId);
                        continue block1;
                    }
                    Map m = (Map)((Map)approw.getValue()).get("menu");
                    if (m == null) continue block1;
                    blackMenus.addAll(m.keySet());
                }
            }
        }
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(16);
        resultMap.put("blackMenus", blackMenus);
        resultMap.put("blackAppIds", blackAppIds);
        return resultMap;
    }

    protected static ProductBlackList loadBlackListSetting() {
        ProductBlackList setting = new ProductBlackList();
        ProductBlackList bos_setting = null;
        ProductBlackList biz_setting = null;
        List<String> cloudBlackList = setting.getCloudBlackList();
        List<String> appBlackList = setting.getAppBlackList();
        List<String> formBlackList = setting.getFormBlackList();
        Map<String, List<String>> appMenu = setting.getAllAppMenuBlackList();
        Map<String, List<String>> appFunction = setting.getAllAppFuncPackBlackList();
        Map<String, List<String>> allFeatures = setting.getAllFeatureBlackList();
        int productModel = BlackSettingCacheManager.getProductModel();
        for (String bos_CloudNum : BOS_CLOUD_NUMBERS) {
            String bos_fileName = ProductFileUtil.getBlackListFileName(productModel, bos_CloudNum);
            String bos_content = ProductFileUtil.loadFileContent("/resources", bos_fileName);
            if (StringUtils.isBlank((CharSequence)bos_content)) continue;
            bos_setting = (ProductBlackList)SerializationUtils.fromJsonString((String)bos_content, ProductBlackList.class);
            cloudBlackList.addAll(bos_setting.getCloudBlackList());
            appBlackList.addAll(bos_setting.getAppBlackList());
            formBlackList.addAll(bos_setting.getFormBlackList());
            Map<String, List<String>> bosAppMenus = bos_setting.getAllAppMenuBlackList();
            BlackSettingCacheManager.mergeMap(appMenu, bosAppMenus);
            Map<String, List<String>> bosAppFunctions = bos_setting.getAllAppFuncPackBlackList();
            BlackSettingCacheManager.mergeMap(appFunction, bosAppFunctions);
            Map<String, List<String>> bosFeatures = bos_setting.getAllFeatureBlackList();
            BlackSettingCacheManager.mergeMap(allFeatures, bosFeatures);
        }
        for (String biz_cloudNum : EXT_CLOUD_NUMBERS) {
            String biz_fileName = ProductFileUtil.getBlackListFileName(productModel, biz_cloudNum);
            String biz_content = ProductFileUtil.loadFileContent("/resources", biz_fileName);
            if (StringUtils.isBlank((CharSequence)biz_content)) continue;
            biz_setting = (ProductBlackList)SerializationUtils.fromJsonString((String)biz_content, ProductBlackList.class);
            cloudBlackList.addAll(biz_setting.getCloudBlackList());
            appBlackList.addAll(biz_setting.getAppBlackList());
            formBlackList.addAll(biz_setting.getFormBlackList());
            Map<String, List<String>> bizAppMenus = biz_setting.getAllAppMenuBlackList();
            BlackSettingCacheManager.mergeMap(appMenu, bizAppMenus);
            Map<String, List<String>> bizAppFunctions = biz_setting.getAllAppFuncPackBlackList();
            BlackSettingCacheManager.mergeMap(appFunction, bizAppFunctions);
            Map<String, List<String>> bizFeatures = biz_setting.getAllFeatureBlackList();
            BlackSettingCacheManager.mergeMap(allFeatures, bizFeatures);
        }
        if (applyWhiteList && productModel == 2) {
            BlackSettingCacheManager.mergeCloudWhiteList(cloudBlackList);
        }
        setting.setCloudBlackList(cloudBlackList);
        setting.setAppBlackList(appBlackList);
        setting.setFormBlackList(formBlackList);
        setting.setAllAppMenuBlackList(appMenu);
        setting.setAllAppFuncPackBlackList(appFunction);
        setting.setAllFeatureBlackList(allFeatures);
        return setting;
    }

    private static void mergeCloudWhiteList(List<String> cloudBlackList) {
        String whiteListSql = "select fcloudid from t_meta_cloudwhitelist";
        List whiteListIds = (List)DB.query((DBRoute)DBRoute.meta, (String)whiteListSql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        });
        if (whiteListIds.isEmpty()) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("isv", "=", (Object)"kingdee"), new QFilter("id", "not in", (Object)whiteListIds)};
        Map clouds = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number", (QFilter[])qFilters);
        if (clouds != null && !clouds.isEmpty()) {
            for (Object cloudId : clouds.keySet()) {
                cloudBlackList.add((String)cloudId);
            }
        }
        log.info("whiteListIds:" + SerializationUtils.toJsonString((Object)whiteListIds) + "clouds size:" + (clouds == null ? 0 : clouds.size()) + ",cloudBlackList:" + SerializationUtils.toJsonString(cloudBlackList));
    }

    private static void mergeMap(Map<String, List<String>> origin, Map<String, List<String>> target) {
        if (target != null) {
            for (Map.Entry<String, List<String>> entry : target.entrySet()) {
                List<String> list = entry.getValue();
                String key = entry.getKey();
                List<String> menuList = origin.get(key);
                if (menuList == null) {
                    menuList = new ArrayList<String>(10);
                }
                menuList.addAll(list);
                origin.put(key, menuList);
            }
        }
    }

    protected static void updateCache(ProductBlackList data) {
        BlackSettingCacheManager.clearCacheData();
        cache.put(BlackSettingCacheManager.getOriginDataKey(), (Object)SerializationUtils.toJsonString((Object)data), redisTimeoutSeconds);
    }

    private static Map<String, String> getAllBlackFormInfoFromData() {
        SqlBuilder sb;
        HashMap<String, String> blackForm = new HashMap<String, String>();
        ArrayList<String> blackClouds = new ArrayList<String>();
        ArrayList blackApps = new ArrayList();
        Map<String, String> data = BlackSettingCacheManager.getCacheData();
        if (data == null) {
            return new HashMap<String, String>();
        }
        for (Map.Entry<String, String> row : data.entrySet()) {
            Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
            if (Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) {
                blackClouds.add(row.getKey());
                continue;
            }
            Map map = (Map)cloudInfo.get(KEY_BLACKAPP);
            if (map == null || map.isEmpty()) continue;
            for (Map.Entry approw : map.entrySet()) {
                if (Boolean.parseBoolean(String.valueOf(((Map)approw.getValue()).get(KEY_FORBIDALL)))) {
                    blackApps.add(approw.getKey());
                    continue;
                }
                Map m = (Map)((Map)approw.getValue()).get("blackform");
                if (m == null) continue;
                for (Map.Entry formrow : m.entrySet()) {
                    blackForm.put(formrow.getKey().toString(), String.valueOf(((Map)formrow.getValue()).get("num")));
                }
            }
        }
        if (!blackClouds.isEmpty()) {
            sb = new SqlBuilder();
            sb.append("select fid from t_meta_bizapp where ", new Object[0]).appendIn("fbizcloudid", blackClouds.toArray());
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, resultSet -> {
                while (resultSet.next()) {
                    blackApps.add(resultSet.getString("fid"));
                }
                return Boolean.TRUE;
            });
        }
        if (!blackApps.isEmpty()) {
            sb = new SqlBuilder();
            sb.append("select fid,fnumber from t_meta_formdesign where ", new Object[0]).appendIn(KEY_FBIZAPPID, blackApps.toArray());
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, resultSet -> {
                while (resultSet.next()) {
                    blackForm.put(resultSet.getString("fid"), resultSet.getString(KEY_FUNUMNBER));
                }
                return Boolean.TRUE;
            });
        }
        return blackForm;
    }

    protected static Map<String, String> getAllBlackCloudList() {
        Map<String, String> data = BlackSettingCacheManager.getCacheData();
        if (data == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> blackList = new HashMap<String, String>();
        for (Map.Entry<String, String> row : data.entrySet()) {
            Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
            if (!Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) continue;
            blackList.put(row.getKey(), String.valueOf(cloudInfo.get("num")));
        }
        return blackList;
    }

    protected static Map<String, String> getAllFormInfoBlackList() {
        Map<String, Map<String, String>> map = BlackSettingCacheManager.getOrCreateLocalAllBlackAppFormInfo();
        HashMap<String, String> value = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> row : map.entrySet()) {
            value.putAll(row.getValue());
        }
        return value;
    }

    protected static Map<String, String> getFormInfoBlackListByAppId(String appId) {
        HashMap data = BlackSettingCacheManager.getOrCreateLocalAllBlackAppFormInfo().get(appId);
        return data == null ? new HashMap(16) : data;
    }

    private static Map<String, String> getFormInfoBlackListByCloudId(String cloudId) {
        return null;
    }

    private static Map<String, String> getOrCreateLocalBlackAppInfo() {
        RequestContext rs = RequestContext.get();
        String key = "allblackappinfo." + rs.getAccountId() + "." + BlackSettingCacheManager.getProductModel();
        LocalMemoryCache localCache = BlackSettingCacheManager.getLocalCache();
        Object localData = localCache.get(key);
        HashMap<String, String> blackAppInfo = new HashMap<String, String>(16);
        if (localData == null) {
            Map<String, String> data = BlackSettingCacheManager.getCacheData();
            localCache.put(key, blackAppInfo);
            if (data == null) {
                return blackAppInfo;
            }
            for (Map.Entry<String, String> row : data.entrySet()) {
                blackAppInfo.putAll(BlackSettingCacheManager.getBlackAppInfoFromCloudData(row));
            }
            return blackAppInfo;
        }
        return (Map)localData;
    }

    private static Map<String, Map<String, String>> getOrCreateLocalCloudAppMapping() {
        RequestContext rs = RequestContext.get();
        String key = "blackcloudappinfo" + rs.getAccountId() + BlackSettingCacheManager.getProductModel();
        LocalMemoryCache localCache = BlackSettingCacheManager.getLocalCache();
        HashMap localData = localCache.get(key);
        if (localData == null) {
            Map<String, String> data = BlackSettingCacheManager.getCacheData();
            localData = new HashMap(16);
            if (data == null) {
                localCache.put(key, localData);
                return localData;
            }
            for (Map.Entry<String, String> row : data.entrySet()) {
                Map<String, String> cloudData = BlackSettingCacheManager.getBlackAppInfoFromCloudData(row);
                ((Map)localData).put(row.getKey(), cloudData);
            }
            localCache.put(key, localData);
            return localData;
        }
        return localData;
    }

    private static Map<String, Map<String, String>> getOrCreateLocalAllBlackAppFormInfo() {
        RequestContext rs = RequestContext.get();
        String key = "allblackappforminfo" + rs.getAccountId() + BlackSettingCacheManager.getProductModel();
        LocalMemoryCache localCache = BlackSettingCacheManager.getLocalCache();
        Object localData = localCache.get(key);
        if (localData == null) {
            SqlBuilder sb;
            HashMap<String, Map<String, String>> appFormData = new HashMap<String, Map<String, String>>();
            localCache.put(key, appFormData);
            HashMap<String, String> blackForm = new HashMap<String, String>();
            ArrayList<String> blackClouds = new ArrayList<String>();
            ArrayList blackApps = new ArrayList();
            Map<String, String> data = BlackSettingCacheManager.getCacheData();
            if (data == null) {
                return new HashMap<String, Map<String, String>>();
            }
            for (Map.Entry<String, String> row : data.entrySet()) {
                Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
                if (Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) {
                    blackClouds.add(row.getKey());
                    continue;
                }
                Map map = (Map)cloudInfo.get(KEY_BLACKAPP);
                if (map == null || map.isEmpty()) continue;
                for (Map.Entry approw : map.entrySet()) {
                    if (Boolean.parseBoolean(String.valueOf(((Map)approw.getValue()).get(KEY_FORBIDALL)))) {
                        blackApps.add(approw.getKey());
                        continue;
                    }
                    Map m = (Map)((Map)approw.getValue()).get("blackform");
                    if (m == null) continue;
                    for (Map.Entry formrow : m.entrySet()) {
                        blackForm.put(formrow.getKey().toString(), String.valueOf(((Map)formrow.getValue()).get("num")));
                    }
                }
            }
            if (!blackClouds.isEmpty()) {
                sb = new SqlBuilder();
                sb.append("select fid from t_meta_bizapp where ", new Object[0]).appendIn("fbizcloudid", blackClouds.toArray());
                DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, resultSet -> {
                    while (resultSet.next()) {
                        blackApps.add(resultSet.getString("fid"));
                    }
                    return Boolean.TRUE;
                });
            }
            if (!blackApps.isEmpty()) {
                sb = new SqlBuilder();
                sb.append("select fid,fnumber from t_meta_formdesign where ", new Object[0]).appendIn(KEY_FBIZAPPID, blackApps.toArray());
                DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, resultSet -> {
                    while (resultSet.next()) {
                        blackForm.put(resultSet.getString("fid"), resultSet.getString(KEY_FUNUMNBER));
                    }
                    return Boolean.TRUE;
                });
            }
            if (!blackForm.isEmpty()) {
                sb = new SqlBuilder();
                sb.append("select fid,fnumber,fbizappid from t_meta_formdesign where ", new Object[0]).appendIn("fid", blackForm.keySet().toArray());
                DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, resultSet -> {
                    while (resultSet.next()) {
                        if (appFormData.containsKey(resultSet.getString(KEY_FBIZAPPID))) {
                            ((Map)appFormData.get(resultSet.getString(KEY_FBIZAPPID))).put(resultSet.getString("fid"), resultSet.getString(KEY_FUNUMNBER));
                            continue;
                        }
                        HashMap<String, String> m = new HashMap<String, String>(10);
                        m.put(resultSet.getString("fid"), resultSet.getString(KEY_FUNUMNBER));
                        appFormData.put(resultSet.getString(KEY_FBIZAPPID), m);
                    }
                    return Boolean.TRUE;
                });
            }
            blackForm.clear();
            return appFormData;
        }
        return (Map)localData;
    }

    private static Map<String, String> getBlackAppInfoFromCloudData(Map.Entry<String, String> row) {
        HashMap<String, String> blackAppInfo = new HashMap<String, String>();
        Map cloudInfo = (Map)SerializationUtils.fromJsonString((String)row.getValue(), Map.class);
        if (Boolean.parseBoolean(String.valueOf(cloudInfo.get(KEY_FORBIDALL)))) {
            String sql = "select fid,fbizcloudid,fnumber from t_meta_bizapp where fbizcloudid = ? ";
            SqlParameter para = new SqlParameter(":fbizcloudid", 12, (Object)row.getKey());
            SqlBuilder sb = new SqlBuilder();
            sb.append(sql, new Object[]{para});
            DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sb, rs -> {
                while (rs.next()) {
                    blackAppInfo.put(rs.getString("fid"), rs.getString(KEY_FUNUMNBER));
                }
                return Boolean.TRUE;
            });
        } else {
            Map map = (Map)cloudInfo.get(KEY_BLACKAPP);
            if (map != null && !map.isEmpty()) {
                for (Map.Entry approw : map.entrySet()) {
                    if (!Boolean.parseBoolean(String.valueOf(((Map)approw.getValue()).get(KEY_FORBIDALL)))) continue;
                    blackAppInfo.put((String)approw.getKey(), String.valueOf(((Map)approw.getValue()).get("appNum")));
                }
            }
        }
        return blackAppInfo;
    }

    static {
        applyWhiteList = Boolean.parseBoolean(System.getProperty(WHITELISTENABLE, "true"));
        ConfigurationUtil.observeChange((String)WHITELISTENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                applyWhiteList = Boolean.parseBoolean(System.getProperty(BlackSettingCacheManager.WHITELISTENABLE));
            }
        });
    }

    static enum ProductModelType {
        Standard("std", 1),
        enterprise("enterprise", 2),
        enjoy("enjot", 3);

        String name;
        int type;

        private ProductModelType(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public static ProductModelType get(int type) {
            for (ProductModelType modelType : ProductModelType.values()) {
                if (modelType.type != type) continue;
                return modelType;
            }
            return Standard;
        }
    }
}

