/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel.FileHandler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.productmodel.FileHandler.AbstractFormFileHandler;
import kd.bos.productmodel.FormSettingCacheManager;
import kd.bos.productmodel.ProductFormSetting;
import kd.bos.productmodel.cache.FormSettingCacheData;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class FormSettingHandler
extends AbstractFormFileHandler {
    private boolean _isInitialize = false;
    @JsonIgnore
    private Map<String, Map<String, Object>> formItems = new HashMap<String, Map<String, Object>>();
    @JsonIgnore
    private Map<String, Map<String, Object>> listItems = new HashMap<String, Map<String, Object>>();
    private static String NodeKey_Meta = "meta";
    private static String NodeKey_Type = "type";
    private static String NodeKey_Items = "items";
    private static String Key_Instruct = "instruct";
    private static String KEY_PARENTID = "parentId";
    private static String KEY_ITEMKEYWORD = "itemKeyWord";
    private Map<String, ControlAp> ctlApMapping = new CaseInsensitiveMap();

    FormSettingHandler(ProductFormSetting setting) {
        super(setting);
        this.createIndex();
    }

    @Override
    public void setListDisVisitControl(List<String> list) {
        this.createIndex();
        this.listItems.clear();
        for (String str : list) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("id", str);
            map.put("vi", "");
            this.listItems.put(str, map);
        }
    }

    private void createIndex() {
        if (this.setting == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff1a\u6587\u4ef6\u5185\u5bb9\u4e22\u5931\u3002", (String)"FormSettingHandler_2", (String)"bos-productmodel-resource", (Object[])new Object[0]));
        }
        if (!this._isInitialize) {
            if (StringUtils.isBlank((CharSequence)this.getFormNum())) {
                throw new KDException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u6b63\u786e\uff0c\u672a\u83b7\u53d6\u5230\u8868\u5355\u7f16\u7801\u3002", (String)"FormSettingHandler_3", (String)"bos-productmodel-resource", (Object[])new Object[0]));
            }
            Object meta = this.setting.get(NodeKey_Meta);
            if (meta == null) {
                this._isInitialize = true;
                return;
            }
            for (Object obj : (List)meta) {
                if (obj == null) continue;
                Map detail = (Map)obj;
                String type = String.valueOf(detail.get(NodeKey_Type));
                List items = (List)detail.get(NodeKey_Items);
                this.buildIndex(type, items);
                this._isInitialize = true;
            }
        }
    }

    private void buildIndex(String type, Object data) {
        if (data == null) {
            return;
        }
        switch (type) {
            case "form": {
                this.buildFormIndex(data);
                break;
            }
            case "list": {
                this.buildListIndex(data);
                break;
            }
            case "mobile": {
                this.buildMobileIndex(data);
                break;
            }
            case "mobilelist": {
                this.buildMobileListIndex(data);
                break;
            }
        }
    }

    private void buildFormIndex(Object data) {
        this.formItems.clear();
        for (Map item : (List)data) {
            Map map;
            String id = String.valueOf(item.get("id"));
            if (!item.containsKey("type") && this.getCtlApMapping().get(id) != null && (map = this.getCtlApMapping().get(id).createControl()).get("type") != null) {
                item.put("type", map.get("type"));
            }
            this.formItems.put(id, item);
        }
    }

    private void buildListIndex(Object data) {
        this.listItems.clear();
        for (Map item : (List)data) {
            String id = String.valueOf(item.get("id"));
            this.listItems.put(id, item);
        }
    }

    private void buildMobileIndex(Object data) {
    }

    private void buildMobileListIndex(Object data) {
    }

    @Override
    public Map<String, Map<String, Object>> getFormItemMetas() {
        return new HashMap<String, Map<String, Object>>();
    }

    @Override
    public Map<String, Map<String, Object>> getMobileItemMetas() {
        return new HashMap<String, Map<String, Object>>();
    }

    @Override
    public Map<String, Map<String, Object>> getListItemMetas() {
        return new HashMap<String, Map<String, Object>>();
    }

    @Override
    public Map<String, Map<String, Object>> getMobileListItemMetas() {
        return new HashMap<String, Map<String, Object>>();
    }

    @Override
    public List<String> getFormDisVisitControl() {
        ArrayList<String> list = new ArrayList<String>(this.formItems.size());
        for (Map.Entry<String, Map<String, Object>> row : this.formItems.entrySet()) {
            if (this.isControlVisible(String.valueOf(row.getValue().get("vi")))) continue;
            list.add(row.getKey());
        }
        return list;
    }

    @Override
    public List<String> getMobileListDisVisitControl() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getListDisVisitControl() {
        return new ArrayList<String>(this.listItems.keySet());
    }

    @Override
    public List<String> getMobileDisVisitControl() {
        return new ArrayList<String>();
    }

    @Override
    public void clear() {
        super.clear();
        this.listItems = null;
        this.formItems = null;
        this.ctlApMapping.clear();
        this._isInitialize = false;
    }

    @Override
    public String getFormNum() {
        return String.valueOf(this.setting.get("form"));
    }

    @Override
    public void setMobileDisVisitControl(List<String> list) {
    }

    @Override
    public void setFormDisVisitControl(List<String> list) {
        this.formItems.clear();
        for (String str : list) {
            Object type;
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("id", str);
            map.put("vi", "");
            ControlAp ap = this.getCtlApMapping().get(str);
            if (ap != null && (type = ap.createControl().get("type")) != null) {
                map.put("type", type.toString());
            }
            this.formItems.put(str, map);
        }
    }

    private Map<String, ControlAp> getCtlApMapping() {
        if (!this.ctlApMapping.isEmpty()) {
            return this.ctlApMapping;
        }
        for (ControlAp ap : this.getFormMetadata().getItems()) {
            this.ctlApMapping.put(ap.getKey(), ap);
        }
        return this.ctlApMapping;
    }

    @Override
    public void setMobileListDisVisitControl(List<String> list) {
    }

    @Override
    public String buildFileContent() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        HashMap<String, Object> form = new HashMap<String, Object>(2);
        form.put("type", "form");
        form.put(NodeKey_Items, this.formItems.values());
        HashMap<String, Object> list = new HashMap<String, Object>(2);
        list.put("type", "list");
        list.put(NodeKey_Items, this.listItems.values());
        ArrayList<HashMap<String, Object>> metas = new ArrayList<HashMap<String, Object>>();
        metas.add(form);
        metas.add(list);
        map.put("meta", metas);
        map.put("form", this.getFormNum());
        map.put("pkid", this.getPk());
        map.put("version", this.getFileVer());
        return SerializationUtils.toJsonString(map);
    }

    @Override
    public FormSettingCacheData createCacheData() {
        FormSettingCacheData cacheData = new FormSettingCacheData();
        this.createIndex();
        cacheData.setFormNum(this.getFormNum());
        List<ProductFormSetting> parentList = FormSettingCacheManager.loadParentFormSetting(this.getFormNum());
        HashMap<String, ControlAp> apMapping = new HashMap<String, ControlAp>(this.getFormMetadata().getItems().size());
        HashMap<String, EntryAp> entryApMap = new HashMap<String, EntryAp>(10);
        HashMap<String, String> dropDownItemMapping = new HashMap<String, String>(10);
        ArrayList<String> formCtlKeys = new ArrayList<String>(16);
        ArrayList<String> formFieldKeys = new ArrayList<String>(16);
        for (ControlAp ap : this.getFormMetadata().getItems()) {
            apMapping.put(ap.getKey(), ap);
            if (ap.getClass().getName().equalsIgnoreCase(EntryAp.class.getName())) {
                entryApMap.put(ap.getId(), (EntryAp)ap);
            }
            if (!(ap instanceof BarItemAp)) continue;
            for (DropdownItem dropdownItem : ((BarItemAp)ap).getDropdownItems()) {
                dropDownItemMapping.put(dropdownItem.getKey(), dropdownItem.getKey());
            }
        }
        HashMap<String, HideInstructions> formInstructionMap = new HashMap<String, HideInstructions>();
        HashMap<String, HideInstructions> listInstructionMap = new HashMap<String, HideInstructions>();
        for (Map.Entry<String, Map<String, Object>> entry : this.formItems.entrySet()) {
            HideInstructions hideInstructions;
            String entryId;
            formCtlKeys.add(entry.getKey());
            if (apMapping.get(entry.getKey()) instanceof FieldAp) {
                formFieldKeys.add(entry.getKey());
            }
            if ((apMapping.get(entry.getKey()) instanceof EntryFieldAp || apMapping.get(entry.getKey()) instanceof EntryFieldGroupAp) && StringUtils.isNotBlank((CharSequence)(entryId = this.getEntryKey((ControlAp)apMapping.get(entry.getKey()), this.getFormMetadata(), entryApMap)))) {
                hideInstructions = (HideInstructions)formInstructionMap.get(entryId);
                if (hideInstructions != null) {
                    hideInstructions.ids.add(entry.getKey());
                    continue;
                }
                hideInstructions = new HideInstructions();
                hideInstructions.parentId = this.getFormMetadata().getItem(entryId).getKey();
                hideInstructions.ids.add(entry.getKey());
                hideInstructions.itemKeyWord = "columns";
                formInstructionMap.put(entryId, hideInstructions);
                continue;
            }
            String ctlKey = entry.getKey();
            if (apMapping.get(entry.getKey()) == null) {
                String itemId = (String)dropDownItemMapping.get(ctlKey);
                String string = ctlKey = StringUtils.isNotBlank((CharSequence)itemId) ? itemId : ctlKey;
            }
            if (formInstructionMap.get("") == null) {
                hideInstructions = new HideInstructions();
                hideInstructions.ids.add(ctlKey);
                formInstructionMap.put("", hideInstructions);
                continue;
            }
            ((HideInstructions)formInstructionMap.get((Object)"")).ids.add(ctlKey);
        }
        for (Map.Entry<String, Map<String, Object>> entry : formInstructionMap.entrySet()) {
            ((HideInstructions)((Object)entry.getValue())).ids = ((HideInstructions)((Object)entry.getValue())).ids.stream().distinct().collect(Collectors.toList());
        }
        ArrayList<String> listCtlKeys = new ArrayList<String>(16);
        ArrayList<String> arrayList = new ArrayList<String>(16);
        arrayList.addAll(formFieldKeys);
        ArrayList<Map<String, Object>> listMetaInstruct = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.listItems.entrySet()) {
            if (!this.isControlVisible(String.valueOf(entry.getValue().get("vi")))) {
                listCtlKeys.add(entry.getKey());
                HideInstructions data = listInstructionMap.getOrDefault("", new HideInstructions());
                data.ids.add(entry.getKey());
                listInstructionMap.put("", data);
            }
            if (entry.getValue().get(Key_Instruct) == null) continue;
            listMetaInstruct.add((Map<String, Object>)entry.getValue().get(Key_Instruct));
        }
        cacheData.addFormBlackCtlKey(formCtlKeys);
        cacheData.addFormBlackFieldKey(formFieldKeys);
        cacheData.addListBlackFieldKey(arrayList);
        cacheData.addListBlackCtlKey(listCtlKeys);
        if (!listMetaInstruct.isEmpty()) {
            cacheData.addListMetaInstruct(listMetaInstruct);
        }
        for (Map.Entry<String, Map<String, Object>> entry : formInstructionMap.entrySet()) {
            cacheData.addToFormHideInstruct(((HideInstructions)((Object)entry.getValue())).getResult());
        }
        for (Map.Entry<String, Map<String, Object>> entry : listInstructionMap.entrySet()) {
            cacheData.addToListHideInstruct(((HideInstructions)((Object)entry.getValue())).getResult());
        }
        if (parentList != null) {
            for (ProductFormSetting productFormSetting : parentList) {
                FormSettingCacheData parentData = productFormSetting.createCacheData();
                this.mergedFormSettingCacheData(cacheData, parentData);
            }
        }
        return cacheData;
    }

    private void mergedFormSettingCacheData(FormSettingCacheData current, FormSettingCacheData parentData) {
        Map<String, HideInstructions> entryInstructionMap;
        List<Map<String, Object>> all;
        current.addFormBlackCtlKey(parentData.getFormBlackCtlKey());
        current.addFormBlackFieldKey(parentData.getFormBlackFieldKey());
        current.addListBlackFieldKey(parentData.getListBlackFieldKey());
        current.addListBlackCtlKey(parentData.getListBlackCtlKey());
        if (!parentData.getListMetaInstruct().isEmpty()) {
            current.addListMetaInstruct(parentData.getListMetaInstruct());
        }
        if (!parentData.getFormCtlHideInstructions().isEmpty()) {
            all = current.getFormHideInstruct();
            all.addAll(parentData.getFormHideInstruct());
            entryInstructionMap = this.buildHideInsIndex(all);
            current.setFormHideInstruct(new ArrayList<Map<String, Object>>());
            for (Map.Entry<String, HideInstructions> it : entryInstructionMap.entrySet()) {
                current.addToFormHideInstruct(it.getValue().getResult());
            }
        }
        if (!parentData.getListCtlHideInstructions().isEmpty()) {
            if (current.getListCtlHideInstructions().isEmpty()) {
                current.setListHideInstruct(parentData.getListCtlHideInstructions());
            } else {
                all = current.getListHideInstruct();
                all.addAll(parentData.getListHideInstruct());
                entryInstructionMap = this.buildHideInsIndex(all);
                current.setListHideInstruct(new ArrayList<Map<String, Object>>());
                for (Map.Entry<String, HideInstructions> it : entryInstructionMap.entrySet()) {
                    current.addToListHideInstruct(it.getValue().getResult());
                }
            }
        }
    }

    private Map<String, HideInstructions> buildHideInsIndex(List<Map<String, Object>> all) {
        HashMap<String, HideInstructions> entryInstructionMap = new HashMap<String, HideInstructions>();
        for (Map<String, Object> map : all) {
            HideInstructions it = HideInstructions.fromMapData(map);
            if (it.ids.isEmpty()) continue;
            HideInstructions hideInstructions = (HideInstructions)entryInstructionMap.get(it.parentId);
            if (hideInstructions != null) {
                hideInstructions.ids.addAll(it.ids);
                continue;
            }
            entryInstructionMap.put(it.parentId, it);
        }
        for (Map.Entry entry : entryInstructionMap.entrySet()) {
            ((HideInstructions)entry.getValue()).ids = ((HideInstructions)entry.getValue()).ids.stream().distinct().collect(Collectors.toList());
        }
        return entryInstructionMap;
    }

    private String getEntryKey(ControlAp fieldAp, FormMetadata meta, Map<String, EntryAp> mapping) {
        if (fieldAp != null && fieldAp.getParentId() != null) {
            ControlAp parent = meta.getItem(fieldAp.getParentId());
            if (parent == null) {
                return null;
            }
            if (mapping.containsKey(parent.getId())) {
                return parent.getId();
            }
            return this.getEntryKey(parent, meta, mapping);
        }
        return null;
    }

    @Override
    public void setListCtlMetaInstruct(String key, Map data) {
        if (this.listItems.get(key) != null) {
            if (this.listItems.get(key).get(Key_Instruct) != null) {
                ((Map)this.listItems.get(key).get(Key_Instruct)).putAll(data);
            } else {
                this.listItems.get(key).put(Key_Instruct, data);
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("id", key);
            map.put("vi", "-1");
            map.put(Key_Instruct, data);
            this.listItems.put(key, map);
        }
    }

    static class HideInstructions {
        String parentId = "";
        List<String> ids = new ArrayList<String>();
        String itemKeyWord;

        HideInstructions() {
        }

        protected boolean isEmpty() {
            return this.ids.isEmpty();
        }

        protected Map<String, Object> getResult() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ids", this.ids);
            if (StringUtils.isNotBlank((CharSequence)this.parentId)) {
                map.put(KEY_PARENTID, this.parentId);
                map.put(KEY_ITEMKEYWORD, this.itemKeyWord);
            }
            return map;
        }

        protected static HideInstructions fromMapData(Map<String, Object> data) {
            HideInstructions hide = new HideInstructions();
            hide.parentId = data.get(KEY_PARENTID) == null ? "" : data.get(KEY_PARENTID).toString();
            String string = hide.itemKeyWord = data.get(KEY_ITEMKEYWORD) == null ? null : data.get(KEY_ITEMKEYWORD).toString();
            if (data.get("ids") instanceof List) {
                hide.ids = (List)data.get("ids");
            }
            return hide;
        }
    }
}

