/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.productmodel.ProductFileUtil;
import kd.bos.productmodel.ProductFormSetting;
import kd.bos.productmodel.cache.IFormBlackCacheData;
import kd.bos.service.ServiceFactory;

public class FormSettingCacheManager {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
    private static int timeoutSeconds = Integer.getInteger("sys.modeltype.timeout", 43200);
    private static String Cache_ResouceKey = "product.formsetting";
    private static final Log log = LogFactory.getLog(FormSettingCacheManager.class);
    private static final String SPAN_FORMSETTING = "blacklistsetting";

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(timeoutSeconds);
        info.setMaxMemSize(300);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("sys_modeltype", "blacklistdata", info);
    }

    protected static void clearCache() {
        cache.remove(FormSettingCacheManager.getResouceCacheKey());
        FormSettingCacheManager.getLocalCache().remove(new String[]{FormSettingCacheManager.getCacheDataKey()});
    }

    private static int getProductModel() {
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        return service.getModeType();
    }

    private static String getResouceCacheKey() {
        RequestContext rs = RequestContext.get();
        return Cache_ResouceKey + "_" + rs.getAccountId() + "_" + FormSettingCacheManager.getProductModel();
    }

    protected static ProductFormSetting getFormSttingFromCache(String formNum) {
        String str = (String)cache.get(FormSettingCacheManager.getResouceCacheKey(), formNum);
        ProductFormSetting data = null;
        if (StringUtils.isBlank((CharSequence)str)) {
            data = FormSettingCacheManager.loadFormSettingFromFile(formNum);
            cache.put(FormSettingCacheManager.getResouceCacheKey(), formNum, (Object)SerializationUtils.toJsonString((Object)data));
        } else {
            data = (ProductFormSetting)SerializationUtils.fromJsonString((String)str, ProductFormSetting.class);
        }
        return data;
    }

    private static String getCacheDataKey() {
        RequestContext rs = RequestContext.get();
        return "cache_productformsetting_" + rs.getAccountId() + "_" + FormSettingCacheManager.getProductModel();
    }

    private static IFormBlackCacheData convertToCacheData(ProductFormSetting file) {
        return file.createCacheData();
    }

    protected static IFormBlackCacheData getCacheData(String formNum) {
        IFormBlackCacheData data;
        String cacheKey = FormSettingCacheManager.getCacheDataKey();
        LocalMemoryCache localCache = FormSettingCacheManager.getLocalCache();
        HashMap<String, IFormBlackCacheData> cacheMap = (HashMap<String, IFormBlackCacheData>)localCache.get(cacheKey);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, IFormBlackCacheData>(8);
        }
        if ((data = (IFormBlackCacheData)cacheMap.get(formNum)) == null) {
            ProductFormSetting file = FormSettingCacheManager.getFormSttingFromCache(formNum);
            data = FormSettingCacheManager.convertToCacheData(file);
            cacheMap.put(formNum, data);
            localCache.put(cacheKey, cacheMap);
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ProductFormSetting loadFormSettingFromFile(String formNum) {
        String appNum = null;
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_FORMSETTING, (String)"FormSettingCacheManager.loadFormSettingFromFile");){
            String id = MetadataDao.getIdByNumber((String)formNum, (MetaCategory)MetaCategory.Form);
            if (span.isRealtime()) {
                span.addLocaleTag("formNum", (Object)formNum);
                span.addLocaleTag("formId", (Object)id);
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                ProductFormSetting productFormSetting2 = new ProductFormSetting(formNum);
                return productFormSetting2;
            }
            FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
            appNum = metadata.getBizappNumber();
            String fileName = ProductFileUtil.getFormFileName(appNum, formNum, FormSettingCacheManager.getProductModel());
            String content = ProductFileUtil.loadFileContent("/resources/app/" + appNum, fileName);
            ProductFormSetting setting = null;
            setting = StringUtils.isNotBlank((CharSequence)content) ? (ProductFormSetting)SerializationUtils.fromJsonString((String)content, ProductFormSetting.class) : new ProductFormSetting(formNum);
            ProductFormSetting productFormSetting = setting;
            return productFormSetting;
        }
        catch (Exception e) {
            return new ProductFormSetting(formNum);
        }
    }

    public static List<ProductFormSetting> loadParentFormSetting(String formNum) {
        String parentNum;
        String id = MetadataDao.getIdByNumber((String)formNum, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isBlank((CharSequence)id)) {
            log.info(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801\uff1a%1$s \u83b7\u53d6\u5230id\u4e3a\uff1a%2$s\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5143\u6570\u636e\u3002", (String)"FormSettingCacheManager_0", (String)"bos-productmodel-resource", (Object[])new Object[0]), formNum, id));
            return new ArrayList<ProductFormSetting>(1);
        }
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        ArrayList<ProductFormSetting> parentSetting = new ArrayList<ProductFormSetting>();
        String paraentId = metadata.getParentId();
        if (StringUtils.isNotBlank((CharSequence)paraentId) && StringUtils.isNotBlank((CharSequence)(parentNum = MetadataDao.getNumberById((String)paraentId)))) {
            parentSetting.add(FormSettingCacheManager.loadFormSettingFromFile(parentNum));
        }
        return parentSetting;
    }

    protected static void updateCache(List<ProductFormSetting> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        String cacheKey = FormSettingCacheManager.getCacheDataKey();
        LocalMemoryCache localCache = FormSettingCacheManager.getLocalCache();
        HashMap<String, IFormBlackCacheData> cacheMap = (HashMap<String, IFormBlackCacheData>)localCache.get(cacheKey);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, IFormBlackCacheData>(files.size());
        }
        for (ProductFormSetting file : files) {
            IFormBlackCacheData data = FormSettingCacheManager.convertToCacheData(file);
            if (data == null) continue;
            cacheMap.put(file.getFormNum(), data);
        }
        localCache.put(cacheKey, cacheMap);
    }
}

