/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.productmodel.kit.CloudBlackListSaveHelper;
import kd.bos.designer.productmodel.kit.FormBlackListSaveHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ProductFileExportUtil {
    public static List<String> getAllClearResourceFileUrl() {
        ArrayList<String> urls = new ArrayList<String>();
        Set<String> cloudIds = ProductFileExportUtil.getCloudIdWhiteList();
        String cloudIdStr = ProductFileExportUtil.changeSetToStr(cloudIds);
        String formFileUrl = FormBlackListSaveHelper.exportAllClearResourceFile("2", cloudIdStr);
        String cloudFileUrl = CloudBlackListSaveHelper.exportClearResourceFile("2");
        urls.add(formFileUrl);
        urls.add(cloudFileUrl);
        return urls;
    }

    private static Set<String> getCloudIdWhiteList() {
        HashSet<String> whitelist = new HashSet<String>();
        String whiteListSql = "select fcloudid from t_meta_cloudwhitelist";
        List whiteListIds = (List)DB.query((DBRoute)DBRoute.meta, (String)whiteListSql, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                return ids;
            }
        });
        if (whiteListIds.isEmpty()) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("isv", "=", (Object)"kingdee"), new QFilter("id", "in", (Object)whiteListIds)};
        Map clouds = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number", (QFilter[])qFilters);
        if (clouds != null && !clouds.isEmpty()) {
            for (Object cloudId : clouds.keySet()) {
                whitelist.add((String)cloudId);
            }
        }
        return whitelist;
    }

    private static String changeSetToStr(Set<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String idOrNum : ids) {
            sb.append("'");
            sb.append(idOrNum);
            sb.append("',");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }
}

