/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.productmodel.model.CloudBlackListInfo;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.productmodel.BlackSettingCacheManager;
import kd.bos.productmodel.FormSettingCacheManager;
import kd.bos.productmodel.ProductBlackList;
import kd.bos.productmodel.ProductFileUtil;
import kd.bos.productmodel.ProductFormSetting;
import kd.bos.service.ServiceFactory;
import kd.bos.util.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ProductFileServiceHelper {
    private static final String BOS_PRODUCTMODEL_RESOURCE = "bos-productmodel-resource";
    private static final Log LOG = LogFactory.getLog(ProductFileServiceHelper.class);

    private static String getErrorMessage() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u7f16\u7801\u9519\u8bef", (String)"ProductFileServiceHelper_5", (String)BOS_PRODUCTMODEL_RESOURCE, (Object[])new Object[0]);
    }

    public static ProductFormSetting loadFormSetting(String formNum) {
        return FormSettingCacheManager.loadFormSettingFromFile(formNum);
    }

    public static ProductBlackList loadBlackListSetting() {
        return BlackSettingCacheManager.loadBlackListSetting();
    }

    public static ProductBlackList loadBlackListFormCache() {
        return BlackSettingCacheManager.getDataFromCahe();
    }

    public static void clearFormCache(List<String> list) {
        BlackSettingCacheManager.clearCacheData();
    }

    public static void clearBlackListCache() {
        BlackSettingCacheManager.clearCacheData();
    }

    public static ProductFormSetting createProductFormSetting(String formNum) {
        return new ProductFormSetting(formNum);
    }

    public static ProductBlackList creatProductBlackList() {
        return new ProductBlackList();
    }

    public static ProductFormSetting loadFormSettingFormCache(String formNum) {
        return FormSettingCacheManager.getFormSttingFromCache(formNum);
    }

    private static void updateFormCache(ProductFormSetting setting) {
    }

    private static void updateBlackCache(ProductBlackList setting) {
    }

    public static List<ProductFormSetting> getFormSettingFileByAppNum(String appNum) {
        ArrayList<ProductFormSetting> list = new ArrayList<ProductFormSetting>();
        File file = new File("/resources/app/" + FilenameUtils.getName((String)appNum));
        if (!file.exists()) {
            return list;
        }
        for (String childpath : file.list()) {
            String content = ProductFileUtil.loadFileContent(childpath);
            ProductFormSetting setting = null;
            if (!StringUtils.isNotBlank((CharSequence)content)) continue;
            setting = (ProductFormSetting)SerializationUtils.fromJsonString((String)content, ProductFormSetting.class);
            list.add(setting);
        }
        return list;
    }

    public static void saveFormSettingFile(ProductFormSetting setting, String dirPath) throws Exception {
        ProductFileServiceHelper.saveFormSettingFile(setting, dirPath, ProductFileServiceHelper.getProductModel());
    }

    public static void saveFormSettingFile(ProductFormSetting setting, String dirPath, int modelType) throws Exception {
        Objects.requireNonNull(setting.getFormNum());
        String id = MetadataDao.getIdByNumber((String)setting.getFormNum(), (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        String fileName = ProductFileUtil.getFormFileName(metadata.getBizappNumber(), setting.getFormNum(), modelType);
        String fileSeparator = ProductFileUtil.fileSeparator;
        String path = dirPath + fileSeparator + fileName;
        File file = new File(FilenameUtils.getName((String)path));
        file.mkdir();
        boolean flag = false;
        if (!file.exists()) {
            flag = file.createNewFile();
            if (!flag) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
        } else {
            flag = file.delete();
            if (!flag) {
                LOG.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
            }
            if (!(flag = file.createNewFile())) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(setting.buildEncryptContent().getBytes("UTF-8"));
            os.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        ProductFileServiceHelper.updateFormCache(setting);
    }

    public static String saveFormSettingFileAsTempFile(ProductFormSetting setting) {
        return ProductFileServiceHelper.saveFormSettingFileAsTempFile(setting, ProductFileServiceHelper.getProductModel());
    }

    public static String saveFormSettingFileAsTempFile(ProductFormSetting setting, int modelType) {
        String id = MetadataDao.getIdByNumber((String)setting.getFormNum(), (MetaCategory)MetaCategory.Form);
        FormMetadata metadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = "";
        String fileName = ProductFileUtil.getFormFileName(metadata.getBizappNumber(), setting.getFormNum(), modelType);
        try {
            url = fileCache.saveAsFullUrl(fileName, setting.buildEncryptContent().getBytes("UTF-8"), 600);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        return url;
    }

    public static String saveFormSettingFileAsTempFile(List<ProductFormSetting> settings, int modelType) {
        Throwable throwable;
        String cloudNum = "";
        if (settings == null || settings.size() <= 0) {
            return "";
        }
        cloudNum = settings.get(0).getCloudNum();
        String filePath = FileUtils.cleanString((String)(ProductFileUtil.temDir + "formBlackList" + "_" + cloudNum.toLowerCase() + "_" + modelType + ".zip"));
        File zipFile = new File(filePath);
        String url = "";
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            throwable = null;
            try (FileOutputStream ins = new FileOutputStream(zipFile);
                 ZipOutputStream zip = new ZipOutputStream(ins);){
                for (ProductFormSetting setting : settings) {
                    FormConfig formConfig = FormMetadataCache.getFormConfig((String)setting.getFormNum());
                    String fileName = formConfig.getBizAppNumber() + "/" + ProductFileUtil.getFormFileName(formConfig.getBizAppNumber(), setting.getFormNum(), modelType);
                    ZipEntry entry = new ZipEntry(fileName);
                    byte[] file = setting.buildEncryptContent().getBytes("UTF-8");
                    entry.setSize(file.length);
                    zip.putNextEntry(entry);
                    BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(file));
                    Throwable throwable2 = null;
                    try {
                        byte[] buff = new byte[file.length];
                        int len = 0;
                        while ((len = bis.read(buff)) != -1) {
                            zip.write(buff, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bis == null) continue;
                        if (throwable2 != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bis.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u538b\u7f29zip\u5305\u51fa\u9519\u3002", (String)"ProductFileServiceHelper_0", (String)BOS_PRODUCTMODEL_RESOURCE, (Object[])new Object[0]), e);
        }
        try {
            throwable = null;
            try (FileInputStream zipIns = new FileInputStream(zipFile);){
                url = fileCache.saveAsFullUrl("formBlackList_" + cloudNum.toLowerCase() + "_" + modelType + ".zip", (InputStream)zipIns, 600);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        finally {
            boolean flag = zipFile.delete();
            if (!flag) {
                LOG.error("zip\u5305\u5220\u9664\u51fa\u9519");
            }
        }
        return url;
    }

    public static String saveBlackListAsTempFile(ProductBlackList setting) {
        return ProductFileServiceHelper.saveBlackListAsTempFile(setting, ProductFileServiceHelper.getProductModel());
    }

    public static String saveBlackListAsTempFile(ProductBlackList setting, int modelType) {
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = "";
        try {
            url = fileCache.saveAsFullUrl(ProductFileUtil.getBlackListFileName(modelType), setting.buildEncryptContent().getBytes("utf-8"), 600);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        ProductFileServiceHelper.updateBlackCache(setting);
        return url;
    }

    public static String saveBlackListAsClearTempFile(ProductBlackList setting, int modelType) {
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = "";
        try {
            url = fileCache.saveAsFullUrl(ProductFileUtil.getClearBlackListFileName(modelType), setting.buildFileContent().getBytes("utf-8"), 600);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        ProductFileServiceHelper.updateBlackCache(setting);
        return url;
    }

    public static String saveBlackListAsTempFile(ProductBlackList setting, int modelType, CloudBlackListInfo blackList) {
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = "";
        try {
            String cloudNum = blackList.getCloudNum();
            url = fileCache.saveAsFullUrl(ProductFileUtil.getBlackListFileName(modelType, cloudNum), setting.buildEncryptContent().getBytes("utf-8"), 600);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        ProductFileServiceHelper.updateBlackCache(setting);
        return url;
    }

    protected static void saveBlackListFile(ProductBlackList setting, String dirPath) throws Exception {
        ProductFileServiceHelper.saveBlackListFile(setting, dirPath, ProductFileServiceHelper.getProductModel());
    }

    protected static void saveBlackListFile(ProductBlackList setting, String dirPath, int modelType) throws Exception {
        String fileSeparator = ProductFileUtil.fileSeparator;
        String fileName = ProductFileUtil.getBlackListFileName(modelType);
        String path = dirPath + fileSeparator + fileName;
        File file = new File(FilenameUtils.getName((String)path));
        file.mkdir();
        boolean flag = false;
        if (!file.exists()) {
            flag = file.createNewFile();
            if (!flag) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
        } else {
            flag = file.delete();
            if (!flag) {
                LOG.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
            }
            if (!(flag = file.createNewFile())) {
                LOG.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
            }
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(SerializationUtils.toJsonString((Object)setting).getBytes("UTF-8"));
            os.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        ProductFileServiceHelper.updateBlackCache(setting);
    }

    protected static int getProductModel() {
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        return service.getModeType();
    }

    public static String saveFormSettingAsClearFile(List<ProductFormSetting> settings, int modelType) {
        Throwable throwable;
        String filePath = FileUtils.cleanString((String)(ProductFileUtil.temDir + "formBlackList"));
        File zipFile = new File(filePath);
        String url = "";
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            throwable = null;
            try (FileOutputStream ins = new FileOutputStream(zipFile);
                 ZipOutputStream zip = new ZipOutputStream(ins);){
                for (ProductFormSetting setting : settings) {
                    FormConfig formConfig = FormMetadataCache.getFormConfig((String)setting.getFormNum());
                    String fileName = formConfig.getBizAppNumber() + "/" + ProductFileUtil.getFormFileName(formConfig.getBizAppNumber(), setting.getFormNum(), modelType);
                    ZipEntry entry = new ZipEntry(fileName);
                    byte[] file = setting.buildFileContent().getBytes("UTF-8");
                    entry.setSize(file.length);
                    zip.putNextEntry(entry);
                    BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(file));
                    Throwable throwable2 = null;
                    try {
                        byte[] buff = new byte[file.length];
                        int len = 0;
                        while ((len = bis.read(buff)) != -1) {
                            zip.write(buff, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bis == null) continue;
                        if (throwable2 != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bis.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u538b\u7f29zip\u5305\u51fa\u9519\u3002", (String)"ProductFileServiceHelper_0", (String)BOS_PRODUCTMODEL_RESOURCE, (Object[])new Object[0]), e);
        }
        try {
            throwable = null;
            try (FileInputStream zipIns = new FileInputStream(zipFile);){
                url = fileCache.saveAsFullUrl("formBlackList", (InputStream)zipIns, 600);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(ProductFileServiceHelper.getErrorMessage(), e);
        }
        finally {
            boolean flag = zipFile.delete();
            if (!flag) {
                LOG.error("zip\u5305\u5220\u9664\u51fa\u9519");
            }
        }
        return url;
    }
}

