/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.license.api.ILicenseService;
import kd.bos.productmodel.ProductFileServiceHelper;
import kd.bos.productmodel.encry.BlackListEncryHelper;
import kd.bos.service.ServiceFactory;

public class ProductFileUtil {
    public static final String fileEncoding = "UTF-8";
    protected static final String rootPath = "/resources";
    protected static final String appPath = "/resources/app/";
    protected static final int tempCacheTimeOut = 600;
    protected static final String zipFileName = "formBlackList";
    protected static final String zipPostfix = ".zip";
    protected static final String temDir = System.getProperty("java.io.tmpdir");
    protected static final String fileSeparator = System.getProperty("file.separator");

    protected static String loadFileContent(String root, String fileName) {
        String filePath = StringUtils.isBlank((CharSequence)root) ? fileName : root + "/" + fileName;
        return ProductFileUtil.loadFileContent(filePath);
    }

    protected static String loadFileContent(String fileName) {
        if (!fileName.startsWith("/")) {
            fileName = "/" + fileName;
        }
        URL url = ProductFileServiceHelper.class.getResource(fileName);
        String jsonStr = "";
        if (url != null) {
            try (InputStream in = url.openConnection().getInputStream();
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                byte[] buffer = new byte[512];
                int length = 0;
                while ((length = in.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                jsonStr = new String(os.toByteArray(), fileEncoding);
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.bOS, ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (String)"ProductFileUtil_0", (String)"bos-productmodel-resource", (Object[])new Object[0]), e.getCause());
            }
        }
        return BlackListEncryHelper.DecryptContent(jsonStr);
    }

    protected static String getBlackListFileName(int model) {
        return "blacklist_setting_" + model + ".json";
    }

    protected static String getClearBlackListFileName(int model) {
        return "blacklist_setting_all_cloud_" + model + ".json";
    }

    protected static String getBlackListFileName(int model, String cloudNum) {
        return "blacklist_setting_" + cloudNum.toLowerCase() + "_" + model + ".json";
    }

    protected static String getFormFileName(String appNum, String formNum, int model) {
        return appNum + "_" + formNum + "_" + model + ".json";
    }

    protected static int getProductModel() {
        ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        return service.getModeType();
    }
}

