/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.productmodel.FileHandler.FileHandlerFactory;
import kd.bos.productmodel.IProductFormFileHandler;
import kd.bos.productmodel.cache.FormSettingCacheData;

public class ProductFormSetting
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final String VERSION = "version";
    private IProductFormFileHandler handler = null;
    @JsonIgnore
    private FormMetadata formMetadata;

    ProductFormSetting() {
        this.init();
    }

    ProductFormSetting(String formNumber) {
        this.init(formNumber);
    }

    protected IProductFormFileHandler getHandler() {
        if (this.handler != null) {
            return this.handler;
        }
        this.handler = FileHandlerFactory.getProductFormFileHandler(this);
        return this.handler;
    }

    public String getFileVer() {
        Object ver = this.get(VERSION);
        return ver == null ? "" : ver.toString();
    }

    private void init() {
        this.put(VERSION, "1.5");
    }

    public Map<String, Map<String, Object>> getFormItemMetas() {
        return this.getHandler().getFormItemMetas();
    }

    public Map<String, Map<String, Object>> getMobileItemMetas() {
        return this.getHandler().getMobileItemMetas();
    }

    public Map<String, Map<String, Object>> getListItemMetas() {
        return this.getHandler().getListItemMetas();
    }

    public Map<String, Map<String, Object>> getMobileLIstItemMetas() {
        return this.getHandler().getMobileListItemMetas();
    }

    private void init(String formNumber) {
        this.put(VERSION, "2.0");
        this.put("form", formNumber);
    }

    public List<String> getFormDisVisitControl() {
        return this.getHandler().getFormDisVisitControl();
    }

    public void setFormDisVisitControl(List<String> list) {
        this.getHandler().setFormDisVisitControl(list);
    }

    public List<String> getMobileListDisVisitControl() {
        return this.getHandler().getMobileListDisVisitControl();
    }

    public void setMobileListDisVisitControl(List<String> list) {
        this.getHandler().setMobileListDisVisitControl(list);
    }

    public List<String> getListDisVisitControl() {
        return this.getHandler().getListDisVisitControl();
    }

    public void setListDisVisitControl(List<String> list) {
        this.getHandler().setListDisVisitControl(list);
    }

    public List<String> getMobileDisVisitControl() {
        return this.getHandler().getMobileDisVisitControl();
    }

    public void setMobileDisVisitControl(List<String> list) {
        this.getHandler().setMobileDisVisitControl(list);
    }

    @Override
    public void clear() {
        this.getHandler().clear();
    }

    public String getFormNum() {
        return this.getHandler().getFormNum();
    }

    public void setFormNum(String formNum) {
        this.getHandler().setFormNum(formNum);
    }

    public ProductFormSetting buildDiffSetting() {
        return this;
    }

    protected String buildFileContent() {
        return this.getHandler().buildFileContent();
    }

    public String buildEncryptContent() {
        return this.getHandler().buildEncryptContent();
    }

    public String getAppNum() {
        return this.getHandler().getAppNum();
    }

    public String getCloudNum() {
        return this.getHandler().getCloudNum();
    }

    protected long getPk() {
        String pk = String.valueOf(this.get("filepkid"));
        if (!"null".equals(pk) && StringUtils.isNotBlank((CharSequence)pk)) {
            return Long.parseLong(pk);
        }
        return 0L;
    }

    protected void setPk(long pk) {
        this.put("filepkid", pk);
    }

    public FormSettingCacheData createCacheData() {
        return this.getHandler().createCacheData();
    }

    public void clearAll() {
        super.clear();
    }

    public void setListCtlMetaInstruct(String key, Map data) {
        this.getHandler().setListCtlMetaInstruct(key, data);
    }
}

