/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.productmodel.encry;

import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.productmodel.encry.CryptoAlgorithm;
import kd.bos.productmodel.encry.OneTimePadUtil;
import kd.bos.productmodel.encry.RSA;
import kd.bos.service.ServiceFactory;

public class BlackListEncryHelper {
    private static CryptoAlgorithm ca = new RSACryptoAlgorithm();
    private static ILicenseService service = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
    private static Log log = LogFactory.getLog(BlackListEncryHelper.class);

    @Deprecated
    public static String EncryStringToString(String encry) {
        return encry;
    }

    @Deprecated
    public static String StringToEncryString(String text) {
        return text;
    }

    public static String EncryptContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        try {
            return service.encrypt(content);
        }
        catch (KDException e) {
            log.error("\u8d44\u6e90\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25\uff0ccontent:" + content, (Throwable)e);
            return "";
        }
    }

    public static String DecryptContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        try {
            return service.decrypt(content);
        }
        catch (KDException e) {
            log.error("\u8d44\u6e90\u6587\u4ef6\u89e3\u5bc6\u5931\u8d25,content:" + content, (Throwable)e);
            return "";
        }
    }

    private static class RSACryptoAlgorithm
    implements CryptoAlgorithm {
        private RSACryptoAlgorithm() {
        }

        @Override
        public byte[] encrypt(byte[] bytes) {
            byte[] byteValue = new byte[]{};
            try {
                return OneTimePadUtil.xor(bytes, RSA.pkey().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Throwable)e);
                return byteValue;
            }
        }

        @Override
        public byte[] decrypt(byte[] bytes) {
            byte[] byteValue = new byte[]{};
            try {
                return OneTimePadUtil.xor(bytes, RSA.pkey().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Throwable)e);
                return byteValue;
            }
        }
    }
}

