/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.RouteMode;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DbJobOperation {
    private static final Log log = LogFactory.getLog(DbJobOperation.class);

    public static void RetrySaveFailureJobInfo(JobInfo jobInfos) {
        if (jobInfos.getGroupId() == 0L) {
            return;
        }
        String jobInfo = SerializationUtils.toJsonString((Object)jobInfos);
        long groupId = jobInfos.getGroupId();
        RouteMode routeModeDate = jobInfos.getRouteMode();
        String routeMode = routeModeDate == RouteMode.SHARDINGTASK ? "2" : (routeModeDate == RouteMode.SHARDINGBROADCAST ? "1" : "0");
        int retryTimes = jobInfos.getRetryTime();
        int executeTime = jobInfos.getExecuteTime();
        String scheduleId = jobInfos.getScheduleId();
        String jobId = jobInfos.getId();
        Object[] paramsFliter = new SqlParameter[]{new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
        String selectSql = "SELECT FTASKINFO,FRETRYTIME,FGROUPID  ,FSTATUS FROM T_SCH_RETRYJOB WHERE FSCHEDULEID = ? AND FJOBID = ?   ";
        ArrayList listData = new ArrayList();
        HashMap retryTime = new HashMap();
        HashMap groupIdTemp = new HashMap();
        HashMap statusTemp = new HashMap();
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])paramsFliter, rs -> {
            while (rs.next()) {
                JobInfo info = (JobInfo)JSON.parseObject((String)rs.getString("FTASKINFO"), JobInfo.class);
                retryTime.put("retryTime", rs.getInt("FRETRYTIME"));
                groupIdTemp.put("groupIdTemp", rs.getLong("FGROUPID"));
                statusTemp.put("status", rs.getString("FSTATUS"));
                listData.add(info);
            }
            return listData;
        });
        if (listData.size() > 0) {
            if (jobInfos.getRetryCode() != -1 && jobInfos.getGroupId() != (long)((Long)groupIdTemp.get("groupIdTemp")).intValue()) {
                Object[] reparams = new SqlParameter[]{new SqlParameter(":FRETRYTIME", 4, (Object)retryTimes), new SqlParameter(":FGROUPID", -5, (Object)groupId), new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FTASKINFO", 12, (Object)jobInfo), new SqlParameter(":FBATCHTIME", 12, (Object)jobInfos.getExecuteTime()), new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
                String resql = "UPDATE T_SCH_RETRYJOB SET FRETRYTIME = ? ,FGROUPID = ?,FLATESTEXECUTIONTIME = ? ,FTASKINFO = ? ,FBATCHTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ? ";
                DB.update((DBRoute)DBRoute.basedata, (String)resql, (Object[])reparams);
                return;
            }
            return;
        }
        ArrayList<SqlParameter[]> params = new ArrayList<SqlParameter[]>();
        SqlParameter[] value = new SqlParameter[]{new SqlParameter(":FGROUPID", -5, (Object)groupId), new SqlParameter(":FTASKINFO", 12, (Object)jobInfo), new SqlParameter(":FBATCHTIME", -9, (Object)executeTime), new SqlParameter(":FRETRYTIME", 4, (Object)retryTimes), new SqlParameter(":FSTATUS", -9, (Object)"1"), new SqlParameter(":FFIRSTFAILURETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FRUNMODE", 12, (Object)routeMode), new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
        params.add(value);
        String sql = "INSERT INTO T_SCH_RETRYJOB(FGROUPID,FTASKINFO,FBATCHTIME,FRETRYTIME,FSTATUS,FFIRSTFAILURETIME,FLATESTEXECUTIONTIME,FRUNMODE,FSCHEDULEID,FJOBID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
    }

    public static List<JobInfo> RetrySelectJobInfo(int timeCycle) {
        long latestExecutionTime = System.currentTimeMillis() - (long)timeCycle;
        Object[] params = new SqlParameter[]{new SqlParameter(":FSTATUS", 12, (Object)"1"), new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(latestExecutionTime))};
        String sql = "SELECT FTASKINFO,FGROUPID,FRUNMODE,FLATESTEXECUTIONTIME FROM T_SCH_RETRYJOB WHERE FSTATUS = ? AND FRETRYTIME > 0 AND FLATESTEXECUTIONTIME <= ?";
        ArrayList<JobInfo> listData = new ArrayList<JobInfo>();
        ArrayList<Long> taskDate = new ArrayList<Long>();
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                JobInfo info = (JobInfo)JSON.parseObject((String)rs.getString("FTASKINFO"), JobInfo.class);
                listData.add(info);
                taskDate.add(rs.getLong("FGROUPID"));
            }
            return listData;
        });
        if (taskDate.size() == 0) {
            return listData;
        }
        StringBuilder taskSqlBuff = new StringBuilder();
        String taskSql = taskSqlBuff.append("UPDATE T_SCH_RETRYJOB SET FRETRYTIME = FRETRYTIME-1  WHERE FGROUPID IN (").append(DbJobOperation.listToSqlString(taskDate)).append(")").toString();
        DB.update((DBRoute)DBRoute.basedata, (String)taskSql, null);
        return listData;
    }

    public static long getGroupMax() {
        long groupId = DB.genLongId((String)"t_sch_retryjob");
        return groupId;
    }

    public static void updateGroupId(String scheduleId, String jobId, long groupId) {
        Object[] taskPrams = new SqlParameter[]{new SqlParameter(":FGROUEPID", -5, (Object)groupId), new SqlParameter(":FSCHEDULEID", 12, (Object)scheduleId), new SqlParameter(":FJOBID", 12, (Object)jobId)};
        String sql = "UPDATE T_SCH_RETRYJOB SET FGROUPID = ? WHERE FSCHEDULEID = ? AND FJOBID = ? ";
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])taskPrams);
    }

    private static String listToSqlString(List<Long> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (long item : list) {
            sb.append('\'').append(item).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }
}

