/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.schedule.zk.ZkConfig;

public class DbScheduleDAO
implements ScheduleDao {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final Log log = LogFactory.getLog(DbScheduleDAO.class);

    public void insert(Map<String, Object> scheduleMap) {
        StringBuilder insertSb = new StringBuilder();
        StringBuilder valueSb = new StringBuilder();
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        scheduleMap.put("FCREATORID", rc.getCurrUserId());
        scheduleMap.put("FCREATETIME", now);
        scheduleMap.put("FMODIFIERID", 0L);
        scheduleMap.put("FMODIFYTIME", now);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(scheduleMap.size());
        LocaleString lName = null;
        insertSb.append("INSERT INTO T_SCH_SCHEDULE (");
        valueSb.append("VALUES (");
        for (Map.Entry<String, Object> entry : scheduleMap.entrySet()) {
            String key = entry.getKey();
            Object val = scheduleMap.get(key);
            if ("fname".equalsIgnoreCase(key)) continue;
            if ("flname".equalsIgnoreCase(key) && val instanceof LocaleString) {
                lName = (LocaleString)val;
                continue;
            }
            insertSb.append(key).append(",");
            valueSb.append("?,");
            SqlParameter param = null;
            if (val instanceof Boolean) {
                param = new SqlParameter(":" + key, 12, (Object)((Boolean)val != false ? "1" : "0"));
            } else if (val instanceof String) {
                param = new SqlParameter(":" + key, 12, val);
            } else if (val instanceof Integer) {
                param = new SqlParameter(":" + key, 4, val);
            } else if (val instanceof Long) {
                param = new SqlParameter(":" + key, -5, val);
            } else if (val instanceof Calendar) {
                param = new SqlParameter(":" + key, 93, (Object)new Timestamp(((Calendar)val).getTimeInMillis()));
            }
            if (params == null) continue;
            params.add(param);
        }
        insertSb.setLength(insertSb.length() - 1);
        valueSb.setLength(valueSb.length() - 1);
        String sql = insertSb.append(") ").append((CharSequence)valueSb).append(") ").toString();
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sql, (Object[])params.toArray(new SqlParameter[0]));
                String schId = String.valueOf(scheduleMap.get("fid"));
                this.insertSchL(lName, schId);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    private void insertSchL(LocaleString lName, String schId) {
        if (lName != null && !lName.isEmpty()) {
            String sql = "INSERT INTO T_SCH_SCHEDULE_L (FPKID, FID,FLOCALEID,FNAME) VALUES (?,?,?,?)";
            ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(6);
            for (Map.Entry entry : lName.entrySet()) {
                IDService idService = IDService.get();
                long newId = idService.genLongId(RequestContext.get().getAccountId(), "T_SCH_SCHEDULE_L");
                SqlParameter[] lparams = new SqlParameter[]{new SqlParameter(":FPKID", 12, (Object)String.valueOf(newId)), new SqlParameter(":FID", 12, (Object)schId), new SqlParameter(":FLOCALEID", 12, entry.getKey()), new SqlParameter(":FNAME", 12, entry.getValue())};
                paramss.add(lparams);
            }
            DB.executeBatch((DBRoute)Sch_Route, (String)sql, paramss);
        }
    }

    public boolean delete(String id) {
        String sql = "delete from T_SCH_SCHEDULE_L where fid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)id)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            DB.execute((DBRoute)Sch_Route, (String)sql, (Object[])params);
            sql = "delete from T_SCH_SCHEDULE where fid = ?";
            boolean ret = DB.execute((DBRoute)Sch_Route, (String)sql, (Object[])params);
            if (ret) {
                this.updateDataEntityCache(new Object[]{id});
            }
            boolean bl = ret;
            return bl;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return false;
    }

    public void update(Map<String, Object> scheduleMap) {
        StringBuilder insertSb = new StringBuilder();
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        scheduleMap.put("FMODIFIERID", rc.getCurrUserId());
        scheduleMap.put("FMODIFYTIME", now);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(scheduleMap.size());
        LocaleString lName = null;
        Object nameVal = null;
        String id = null;
        insertSb.append("UPDATE  T_SCH_SCHEDULE SET ");
        for (Map.Entry<String, Object> entry : scheduleMap.entrySet()) {
            String key = entry.getKey();
            Object val = scheduleMap.get(key);
            if ("fid".equalsIgnoreCase(key)) {
                id = (String)val;
            }
            if ("fname".equalsIgnoreCase(key)) continue;
            if ("flname".equalsIgnoreCase(key) && val instanceof LocaleString) {
                lName = (LocaleString)val;
                continue;
            }
            insertSb.append(key).append(" = ?,");
            SqlParameter param = null;
            if (val instanceof Boolean) {
                param = new SqlParameter(":" + key, 12, (Object)((Boolean)val != false ? "1" : "0"));
            } else if (val instanceof String) {
                param = new SqlParameter(":" + key, 12, val);
            } else if (val instanceof Integer) {
                param = new SqlParameter(":" + key, 4, val);
            } else if (val instanceof Long) {
                param = new SqlParameter(":" + key, -5, val);
            } else if (val instanceof Calendar) {
                param = new SqlParameter(":" + key, 93, (Object)new Timestamp(((Calendar)val).getTimeInMillis()));
            }
            if (params == null) continue;
            params.add(param);
        }
        insertSb.setLength(insertSb.length() - 1);
        String sql = insertSb.append(" WHERE FID = ").append("'").append(id).append("'").toString();
        try (TXHandle handle = TX.beginNew();){
            try {
                DB.update((DBRoute)Sch_Route, (String)sql, (Object[])params.toArray(new SqlParameter[0]));
                if (lName != null && !lName.isEmpty()) {
                    sql = "UPDATE  T_SCH_SCHEDULE_L SET FNAME = ? WHERE FID = ? and FLOCALEID = ?";
                    ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(6);
                    ArrayList<Map.Entry> entryList = new ArrayList<Map.Entry>(lName.size());
                    for (Map.Entry entry : lName.entrySet()) {
                        SqlParameter[] lparams = new SqlParameter[]{new SqlParameter(":FNAME", 12, entry.getValue()), new SqlParameter(":FID", 12, scheduleMap.get("fid")), new SqlParameter(":FLOCALEID", 12, entry.getKey())};
                        paramss.add(lparams);
                        entryList.add(entry);
                    }
                    int[] rets = DB.executeBatch((DBRoute)Sch_Route, (String)sql, paramss);
                    LocaleString localeString = new LocaleString();
                    for (int i = 0; i < rets.length; ++i) {
                        if (rets[i] != 0) continue;
                        Map.Entry entry = (Map.Entry)entryList.get(i);
                        localeString.setItem((String)entry.getKey(), entry.getValue());
                    }
                    if (!localeString.isEmpty()) {
                        this.insertSchL(localeString, id);
                    }
                    if (StringUtils.isNotBlank((Object)scheduleMap.get("fid"))) {
                        this.updateDataEntityCache(new Object[]{scheduleMap.get("fid")});
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    private void updateDataEntityCache(Object[] ids) {
        ScheduleDataEntityUtils.getInvoker().updateDataEntityCache(SchEntityType.Schedule, ids);
    }

    public boolean existed(String id) {
        String sql = "select fid from T_SCH_SCHEDULE where fid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)id)};
        return (Boolean)DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, rs -> rs.next());
    }

    public boolean existedByNumber(String number) {
        String host = AbstractService.getHostIpAddress();
        String sql = "select fid from T_SCH_SCHEDULE where fnumber = ?";
        Object[] params = new SqlParameter[1];
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            sql = sql + " and fhost = ? ";
            params = new SqlParameter[2];
            params[1] = new SqlParameter(":fhost", 12, (Object)host);
        }
        params[0] = new SqlParameter(":fnumber", 12, (Object)number);
        return (Boolean)DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, rs -> rs.next());
    }

    public String getIdByNumber(String number) {
        String host = AbstractService.getHostIpAddress();
        String sql = "select fid from T_SCH_SCHEDULE where fnumber = ?";
        Object[] params = new SqlParameter[1];
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            sql = sql + " and fhost = ? ";
            params = new SqlParameter[2];
            params[1] = new SqlParameter(":fhost", 12, (Object)host);
        }
        params[0] = new SqlParameter(":fnumber", 12, (Object)number);
        return (String)DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, rs -> {
            String fid = null;
            if (rs.next()) {
                fid = rs.getString(1);
            }
            return fid;
        });
    }

    public Map<String, String> querySchTypeAndPlanById(String id) {
        String sql = "select fplan,frepeatmode  from T_SCH_SCHEDULE where fid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)id)};
        return (Map)DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, rs -> {
            HashMap<String, String> result = new HashMap<String, String>();
            if (rs.next()) {
                result.put("fplan", rs.getString("fplan"));
                result.put("frepeatmode", rs.getString("frepeatmode"));
            }
            return result;
        });
    }

    public boolean enableSchedule(String id) {
        boolean isSuccess = true;
        String sql = "update t_sch_schedule set fstatus = '1',FMODIFIERID = ?, FMODIFYTIME = ? where fid = ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":fid", 12, (Object)id)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)sql, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{id});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return isSuccess;
    }

    public boolean disableSchedule(String id) {
        boolean isSuccess = true;
        String sql = "update t_sch_schedule set fstatus = '0',FMODIFIERID = ?, FMODIFYTIME = ? where fid = ? ";
        RequestContext rc = RequestContext.get();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new SqlParameter[]{new SqlParameter(":FMODIFIERID", -5, (Object)rc.getCurrUserId()), new SqlParameter(":FMODIFYTIME", 93, (Object)now), new SqlParameter(":fid", 12, (Object)id)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            boolean result = DB.execute((DBRoute)Sch_Route, (String)sql, (Object[])params);
            if (result) {
                this.updateDataEntityCache(new Object[]{id});
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            isSuccess = false;
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return isSuccess;
    }

    public List<String> getJobIdByScheduleId(String scheduleId) {
        String sql = "SELECT t1.FJOBID,t2.FJOBNUMBER FROM T_SCH_SCHEDULE t1 LEFT JOIN T_SCH_SCHEDULE_ENTRY T2 ON t1.FID = t2.FID WHERE t1.FID = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)scheduleId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.beginNew();){
            List list = (List)DB.query((DBRoute)Sch_Route, (String)sql, (Object[])params, rs -> {
                ArrayList<String> fidList = new ArrayList<String>();
                while (rs.next()) {
                    String fjobnumber = rs.getString("fjobnumber");
                    String fjobid = rs.getString("fjobid");
                    if (StringUtils.isNotBlank((CharSequence)fjobnumber)) {
                        fidList.add(fjobnumber);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)fjobid)) continue;
                    fidList.add(fjobid);
                }
                return fidList;
            });
            return list;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return new ArrayList<String>();
    }
}

