/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dao.dbImpl;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.utils.ErrorProcessUtils;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class DbTaskDAO
implements TaskDao {
    private static final DBRoute Sch_Route = DBRoute.basedata;
    private static final Log log = LogFactory.getLog(DbTaskDAO.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"BOSSchedule-TaskDao", (int)ZkConfig.getNumOfWorkThread(), (String)"bos");
    private static final String FJOB_ID = "fjobid";
    private static final String F_JOBDID = ":FJOBID";
    private static final String FEND_TIME = ":FENDTIME";
    private static final String FRUN_TIME = ":FRUNTIME";
    private static final String FSTATUS = ":FSTATUS";
    private static final String FPROGRESS = ":FPROGRESS";
    private static final String FSCHEDULE_ID = ":FSCHEDULEID";
    private static final String FCOSTTIME = ":FCOSTTIME";
    private static final String UPDATE_TASK_FSTATUS = "UPDATE T_SCH_TASK SET FSTATUS = ? ";
    private static final String F_PROGRESS = ",FPROGRESS = ? ";
    private static final String WHERE_FID = " WHERE FID = ? ";
    private JobDao jobDao = new DbJobDao();

    public TaskInfo get(String taskId) {
        TaskInfo cacheTaskInfo = TaskCache.getTaskInfo(taskId);
        if (cacheTaskInfo != null) {
            return cacheTaskInfo;
        }
        String strSQL = "SELECT t1.FJOBID,t1.FENDTIME,t1.FRUNTIME,t1.FDISPATCHTIME,t1.FJOBTYPE,t1.FSTATUSDESC, t1.FDATA,t1.FSTATUS,t1.FPROGRESS,t1.FRUNAT,t1.FID,t1.FSCHEDULEID,t2.FERRORREASON,t1.FINSTANCEID,t1.FTRACEID,t1.FAPPID,t1.FGROUPID,t1.FMESSAGEID FROM T_SCH_TASK t1 LEFT JOIN T_SCH_ERRORJOB t2 on t1.FID=t2.FTASKID  WHERE t1.FID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)taskId)};
        return (TaskInfo)DB.query((DBRoute)Sch_Route, (String)strSQL, (Object[])params, rs -> {
            TaskInfo taskInfo = new TaskInfo();
            if (rs.next()) {
                taskInfo.setId(rs.getString("FID"));
                taskInfo.setData(rs.getString("FDATA"));
                if (rs.getTimestamp("FDISPATCHTIME") != null) {
                    taskInfo.setDispachTime(rs.getTimestamp("FDISPATCHTIME").getTime());
                }
                if (rs.getTimestamp("FENDTIME") != null) {
                    taskInfo.setEndTime(rs.getTimestamp("FENDTIME").getTime());
                }
                if (rs.getTimestamp("FRUNTIME") != null) {
                    taskInfo.setRunTime(rs.getTimestamp("FRUNTIME").getTime());
                }
                if (rs.getString("FJOBTYPE") != null) {
                    taskInfo.setJobType(JobType.valueOf((String)rs.getString("FJOBTYPE")));
                }
                if (rs.getString("FJOBID") != null) {
                    taskInfo.setJobId(rs.getString("FJOBID"));
                }
                if (rs.getString("FSCHEDULEID") != null) {
                    taskInfo.setScheduleId(rs.getString("FSCHEDULEID"));
                }
                taskInfo.setProgress(rs.getInt("FPROGRESS"));
                taskInfo.setRunAt(rs.getString("FRUNAT"));
                taskInfo.setStatus(rs.getString("FSTATUS"));
                if (rs.getString("FERRORREASON") != null) {
                    taskInfo.setFailureReason(rs.getString("FERRORREASON"));
                }
                taskInfo.setStatusDesc(rs.getString("FSTATUSDESC"));
                taskInfo.setInstanceId(rs.getString("FINSTANCEID"));
                taskInfo.setTraceId(rs.getString("FTRACEID"));
                taskInfo.setAppid(rs.getString("FAPPID"));
                taskInfo.setGroupId(rs.getLong("FGROUPID"));
                taskInfo.setMessageId(rs.getString("FMESSAGEID"));
            }
            return taskInfo;
        });
    }

    public List<TaskInfo> get(List<String> taskIds) {
        if (taskIds == null) {
            return Collections.emptyList();
        }
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        ArrayList<String> noExistIds = new ArrayList<String>();
        for (String taskId : taskIds) {
            TaskInfo taskInfo2 = TaskCache.getTaskInfo(taskId);
            if (taskInfo2 != null) {
                taskInfos.add(taskInfo2);
                continue;
            }
            noExistIds.add(taskId);
        }
        if (noExistIds.isEmpty()) {
            return taskInfos;
        }
        Object[] params = new SqlParameter[noExistIds.size()];
        StringBuilder sql = new StringBuilder(100);
        sql.append("select fid,fdata,fdispatchtime,fendtime,fruntime,fjobid,fscheduleid,frunat,fstatus,fprogress,finstanceid,ftraceid,fappid from t_sch_task where fid in ");
        sql.append("(");
        for (int i = 0; i < noExistIds.size(); ++i) {
            params[i] = new SqlParameter(":FID", 12, noExistIds.get(i));
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        List list = (List)DB.query((DBRoute)Sch_Route, (String)sql.toString(), (Object[])params, rs -> {
            ArrayList<TaskInfo> tmp = new ArrayList<TaskInfo>(10);
            while (rs.next()) {
                TaskInfo taskInfo = new TaskInfo();
                taskInfo.setId(rs.getString("fid"));
                taskInfo.setData(rs.getString("fdata"));
                if (rs.getTimestamp("fdispatchtime") != null) {
                    taskInfo.setDispachTime(rs.getTimestamp("fdispatchtime").getTime());
                }
                if (rs.getTimestamp("fendtime") != null) {
                    taskInfo.setEndTime(rs.getTimestamp("fendtime").getTime());
                }
                if (rs.getTimestamp("fruntime") != null) {
                    taskInfo.setRunTime(rs.getTimestamp("fruntime").getTime());
                }
                if (rs.getString(FJOB_ID) != null) {
                    taskInfo.setJobId(rs.getString(FJOB_ID));
                }
                if (rs.getString("fscheduleid") != null) {
                    taskInfo.setScheduleId(rs.getString("fscheduleid"));
                }
                taskInfo.setProgress(rs.getInt("fprogress"));
                taskInfo.setRunAt(rs.getString("frunat"));
                taskInfo.setStatus(rs.getString("fstatus"));
                taskInfo.setInstanceId(rs.getString("finstanceid"));
                taskInfo.setTraceId(rs.getString("ftraceid"));
                taskInfo.setAppid(rs.getString("fappid"));
                tmp.add(taskInfo);
            }
            return tmp;
        });
        taskInfos.addAll(list);
        Map<String, TaskInfo> map = taskInfos.stream().collect(Collectors.toMap(TaskInfo::getId, taskInfo -> taskInfo));
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>(taskIds.size());
        for (String taskId : taskIds) {
            result.add(map.get(taskId));
        }
        return result;
    }

    public void save(TaskInfo taskInfo) {
        this.save(new TaskInfo[]{taskInfo});
    }

    public boolean updateStatus(String taskId, String status) {
        return this.updateStatus(taskId, status, null);
    }

    public boolean updateStatus(String taskId, String status, String statusDesc) {
        boolean ret;
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(UPDATE_TASK_FSTATUS);
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(FSTATUS, 12, (Object)status));
        taskMap.put("status", status);
        if ("READY".equals(status)) {
            sqlBuffer.append(",FRUNAT = ?, FINSTANCEID = ? ");
            String runAt = ZkConfig.getExecutorServerName();
            String instanceId = Instance.getInstanceId();
            paraList.add(new SqlParameter(":FRUNAT", 12, (Object)runAt));
            paraList.add(new SqlParameter(":FINSTANCEID", 12, (Object)instanceId));
            taskMap.put("runAt", runAt);
            taskMap.put("instanceId", instanceId);
        }
        if (status.equals("COMPLETED")) {
            sqlBuffer.append(F_PROGRESS);
            paraList.add(new SqlParameter(FPROGRESS, 4, (Object)100));
            taskMap.put("progress", 100);
        }
        if (status.equals("BEGIN")) {
            sqlBuffer.append(",FRUNTIME = ? ");
            Timestamp runtime = new Timestamp(System.currentTimeMillis());
            paraList.add(new SqlParameter(FRUN_TIME, 93, (Object)runtime));
            taskMap.put("runTime", runtime.getTime());
        } else if ("SKIP".equals(status) || "ABORTED".equals(status)) {
            sqlBuffer.append(",FSTATUSDESC = ? ");
            paraList.add(new SqlParameter(":FSTATUSDESC", 12, (Object)statusDesc));
            taskMap.put("statusDesc", statusDesc);
        }
        TaskInfo endTaskInfo = null;
        if (TaskStatusConstant.isEnd((String)status) && (endTaskInfo = this.get(taskId)).getRunTime() != 0L) {
            sqlBuffer.append(",FENDTIME = ? ");
            Object endTime = new Timestamp(System.currentTimeMillis());
            paraList.add(new SqlParameter(FEND_TIME, 91, endTime));
            int costTime = (int)((((Timestamp)endTime).getTime() - endTaskInfo.getRunTime()) / 1000L);
            if (costTime < 1) {
                costTime = 1;
            }
            sqlBuffer.append(",FCOSTTIME = ?");
            paraList.add(new SqlParameter(FCOSTTIME, 4, (Object)costTime));
            taskMap.put("endTime", endTime);
            taskMap.put("costTime", costTime);
        }
        sqlBuffer.append(WHERE_FID);
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        switch (status) {
            case "READY": {
                sqlBuffer.append(" and FSTATUS in (?,?,?)");
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"SCHEDULED"));
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"ABORTED"));
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"RESCHEDULE"));
                break;
            }
            case "BEGIN": {
                sqlBuffer.append(" and FSTATUS in (?, ?, ?)");
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"READY"));
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"SCHEDULED"));
                paraList.add(new SqlParameter(FSTATUS, 12, (Object)"ABORTED"));
            }
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                ret = DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error("Schedule***DbTaskDAO.updateStatus error, taskid : {}", (Object)taskId, (Object)e);
                handle.markRollback();
                throw e;
            }
        }
        if (ret) {
            TaskInfo taskInfo;
            if (TaskStatusConstant.isEnd((String)status)) {
                taskInfo = endTaskInfo;
                TaskCache.clearCache(taskId);
            } else {
                TaskCache.putTaskMap(taskId, taskMap);
                taskInfo = this.get(taskId);
            }
            if (taskInfo != null) {
                String jobId;
                QFilter qFilter;
                Map jobMap;
                DynamicObject job;
                boolean isSupportTaskTrace;
                this.retryJobStatusUpdate(taskInfo, status);
                taskInfo.setStatus(status);
                RequestContext rc = RequestContext.get();
                SchObservableCollectData.collectData((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"Client", (String)"taskUpdateStatus", (Object)taskInfo);
                if (StringUtils.equals((CharSequence)status, (CharSequence)"ABORTED") && taskInfo.getJobType() == JobType.BIZ && (isSupportTaskTrace = (job = (DynamicObject)(jobMap = BusinessDataReader.loadFromCache((String)"sch_job", (String)"tasktrace", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)(jobId = taskInfo.getJobId()))})).get(jobId)).getBoolean("tasktrace"))) {
                    SchObservableCollectData.collectData((String)rc.getTenantId(), (String)rc.getAccountId(), (String)"Client", (String)"abortTaskByReboot", (Object)taskInfo);
                }
            }
        }
        return ret;
    }

    private void retryJobStatusUpdate(TaskInfo taskInfo, String status) {
        DynamicObject jobObj;
        String jobInfoId = taskInfo.getJobId();
        if (StringUtils.isNotEmpty((CharSequence)jobInfoId) && (jobObj = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Job, (Object)jobInfoId, "retrytime")) != null && jobObj.getInt("retrytime") > 0) {
            this.RetryJobStatusUpdate(taskInfo.getId(), status);
        }
    }

    public void RetryJobStatusUpdate(String taskId, String status) {
        if (!(status.equals("FAILED") || status.equals("COMPLETED") || status.equals("BEGIN"))) {
            status = "FAILED";
        }
        HashMap groupDate = new HashMap();
        HashMap taskDate = new HashMap();
        ArrayList beforeStatus = new ArrayList();
        Object[] taskPrams = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)taskId)};
        String taskSqlTemp = "SELECT FSCHEDULEID,FNUMBER,FGROUPID,FSTATUS FROM T_SCH_TASK WHERE FID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)taskSqlTemp, (Object[])taskPrams, rs -> {
            while (rs.next()) {
                taskDate.put("number", rs.getString("FNUMBER"));
                taskDate.put("scheduleId", rs.getString("FSCHEDULEID"));
                taskDate.put("groupId", rs.getLong("FGROUPID"));
            }
            return taskDate;
        });
        String scheduleId = String.valueOf(taskDate.get("scheduleId"));
        String jobId = String.valueOf(taskDate.get("number"));
        if ((Long)taskDate.get("groupId") == 0L) {
            Object[] params = new SqlParameter[4];
            params[1] = new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis()));
            params[2] = new SqlParameter(FSCHEDULE_ID, 12, (Object)scheduleId);
            params[3] = new SqlParameter(F_JOBDID, 12, (Object)jobId);
            String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = ?,FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
            params[0] = status.equals("COMPLETED") ? new SqlParameter(FSTATUS, 12, (Object)"2") : (status.equals("BEGIN") ? new SqlParameter(FSTATUS, 12, (Object)"0") : new SqlParameter(FSTATUS, 12, (Object)"1"));
            DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            return;
        }
        Object[] statusPrams = new SqlParameter[]{new SqlParameter(FSCHEDULE_ID, 12, taskDate.get("scheduleId")), new SqlParameter(":FGROUPID", 12, taskDate.get("groupId"))};
        String statusSqlTemp = "SELECT FSCHEDULEID,FNUMBER,FGROUPID,FSTATUS FROM T_SCH_TASK WHERE FSCHEDULEID = ? AND FGROUPID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)statusSqlTemp, (Object[])statusPrams, rs -> {
            while (rs.next()) {
                beforeStatus.add(rs.getString("FSTATUS"));
            }
            return beforeStatus;
        });
        Object[] paramsTemp = new SqlParameter[]{new SqlParameter(FSCHEDULE_ID, 12, (Object)scheduleId), new SqlParameter(F_JOBDID, 12, (Object)jobId)};
        String sql = "SELECT FBATCHTIME,FGROUPID ,FRETRYTIME ,FRUNMODE,FTASKINFO FROM T_SCH_RETRYJOB  WHERE FSCHEDULEID = ? AND FJOBID = ?";
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])paramsTemp, rs -> {
            while (rs.next()) {
                groupDate.put("batchtime", rs.getInt("FBATCHTIME"));
                groupDate.put("groupid", rs.getLong("FGROUPID"));
                groupDate.put("retrytime", rs.getInt("FRETRYTIME"));
                groupDate.put("routemode", rs.getString("FRUNMODE"));
                groupDate.put("jobinfo", rs.getString("FTASKINFO"));
            }
            return groupDate;
        });
        if (groupDate.size() != 0) {
            Object[] params = new SqlParameter[]{new SqlParameter(":FLATESTEXECUTIONTIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(FSCHEDULE_ID, 12, (Object)scheduleId), new SqlParameter(F_JOBDID, 12, (Object)jobId)};
            if (status.equals("BEGIN") && (Integer)groupDate.get("retrytime") > 0) {
                String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '0',FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            } else {
                String taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '1' ,FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                if (groupDate.get("routemode").equals("2") || groupDate.get("routemode").equals("1")) {
                    boolean end = true;
                    if (status.equals("COMPLETED")) {
                        if (beforeStatus.size() == ((Integer)groupDate.get("batchtime")).intValue()) {
                            for (int j = 0; j < beforeStatus.size(); ++j) {
                                if (((String)beforeStatus.get(j)).contains("COMPLETED")) continue;
                                end = false;
                                break;
                            }
                        }
                        if (end) {
                            taskSql = "UPDATE T_SCH_RETRYJOB SET FSTATUS = '2',FLATESTEXECUTIONTIME = ? WHERE FSCHEDULEID = ? AND FJOBID = ?";
                        }
                    }
                } else if (status.equals("COMPLETED")) {
                    StringBuilder temp = new StringBuilder();
                    int retryTime = ((JobInfo)JSON.parseObject((String)String.valueOf(groupDate.get("jobinfo")), JobInfo.class)).getRetryTime();
                    taskSql = temp.append("UPDATE T_SCH_RETRYJOB SET FSTATUS = '2',FLATESTEXECUTIONTIME = ?").append(", FRETRYTIME = ").append(retryTime).append("  WHERE FSCHEDULEID = ? AND FJOBID = ?").toString();
                }
                DB.update((DBRoute)DBRoute.basedata, (String)taskSql, (Object[])params);
            }
        }
    }

    public void setStop(String taskId) {
        TaskCache.putStopStatus(taskId, true);
    }

    public boolean isStop(String taskId) {
        return TaskCache.getStopStatus(taskId);
    }

    public void updateProgress(String taskId, int progress) {
        this.updateProgress(taskId, progress, null, null);
    }

    public void updateProgress(String taskId, int progress, String desc, Map<String, Object> customData) {
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("status", "BEGIN");
        if (progress >= 100) {
            taskMap.put("progress", 99);
        } else {
            taskMap.put("progress", progress);
        }
        taskMap.put("desc", desc);
        if (customData != null) {
            String data = SerializationUtils.toJsonString(customData);
            taskMap.put("data", data);
        }
        TaskCache.putTaskMap(taskId, taskMap);
        if (progress >= 100) {
            progress = 99;
            StringBuilder sqlBuffer = new StringBuilder();
            sqlBuffer.append(UPDATE_TASK_FSTATUS);
            ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
            paraList.add(new SqlParameter(FSTATUS, 12, (Object)"BEGIN"));
            sqlBuffer.append(F_PROGRESS);
            paraList.add(new SqlParameter(FPROGRESS, 4, (Object)progress));
            sqlBuffer.append(WHERE_FID);
            paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    handle.markRollback();
                }
            }
        }
    }

    public void updateRunAt(String taskId, String serverName, String instanceId, String traceId) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_SCH_TASK SET FRUNAT = ?, FINSTANCEID = ?, FTRACEID = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(":FRUNAT", 12, (Object)serverName));
        paraList.add(new SqlParameter(":FINSTANCEID", 12, (Object)instanceId));
        paraList.add(new SqlParameter(":FTRACEID", 12, (Object)traceId));
        sqlBuffer.append(WHERE_FID);
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public void updateCustomData(String taskId, Map<String, Object> customData) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append(UPDATE_TASK_FSTATUS);
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(FSTATUS, 12, (Object)"BEGIN"));
        sqlBuffer.append(",FDATA = ? ");
        paraList.add(new SqlParameter(":FDATA", -9, (Object)SerializationUtils.toJsonString(customData)));
        sqlBuffer.append(WHERE_FID);
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public void updateRuntime(String taskId, long runTime) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_SCH_TASK SET FRUNTIME = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(FRUN_TIME, 93, (Object)new Timestamp(runTime)));
        sqlBuffer.append(WHERE_FID);
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public void updateEndTime(String taskId, long endTime) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("UPDATE T_SCH_TASK SET FENDTIME = ? ");
        ArrayList<SqlParameter> paraList = new ArrayList<SqlParameter>();
        paraList.add(new SqlParameter(FEND_TIME, 93, (Object)new Timestamp(endTime)));
        sqlBuffer.append(F_PROGRESS);
        paraList.add(new SqlParameter(FPROGRESS, 4, (Object)100));
        sqlBuffer.append(WHERE_FID);
        paraList.add(new SqlParameter(":FID", 12, (Object)taskId));
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)Sch_Route, (String)sqlBuffer.toString(), (Object[])paraList.toArray(new SqlParameter[paraList.size()]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                handle.markRollback();
            }
        }
    }

    public void asynDeleteTaskByJobId(String jobId) {
        if (jobId == null || jobId.trim().length() == 0) {
            return;
        }
        String strSQL = "DELETE FROM T_SCH_TASk WHERE FJOBID= ?";
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(F_JOBDID, 12, (Object)jobId)};
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(params);
        threadPool.execute((Runnable)new DeleteTask(RequestContext.get(), strSQL, list));
    }

    public void asynDeleteTaskByScheduleId(String scheduleId) {
        if (scheduleId == null || scheduleId.trim().length() == 0) {
            return;
        }
        String selectSql = "select fjobid from t_sch_schedule where fid= ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)scheduleId)};
        List jobIds = (List)DB.query((DBRoute)Sch_Route, (String)selectSql, (Object[])params, rs -> {
            ArrayList<String> ids = new ArrayList<String>(10);
            while (rs.next()) {
                ids.add(rs.getString(FJOB_ID));
            }
            return ids;
        });
        if (jobIds.isEmpty()) {
            return;
        }
        String strSQL = "DELETE FROM T_SCH_TASk WHERE FJOBID = ? ";
        ArrayList<Object[]> delParams = new ArrayList<Object[]>(jobIds.size());
        for (String jobId : jobIds) {
            SqlParameter[] delParam = new SqlParameter[]{new SqlParameter(FSCHEDULE_ID, 12, (Object)jobId), new SqlParameter(FRUN_TIME, 91, (Object)new Date(System.currentTimeMillis()))};
            delParams.add(delParam);
        }
        threadPool.execute((Runnable)new DeleteTask(RequestContext.get(), strSQL, delParams));
    }

    public int deleteTaskByScheduleId(String scheduleId) {
        if (scheduleId == null || scheduleId.trim().length() == 0) {
            return 0;
        }
        String strSQL = "DELETE FROM T_SCH_TASk WHERE FSCHEDULEID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(FSCHEDULE_ID, 12, (Object)scheduleId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            int n = DB.update((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            return n;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return 0;
    }

    public int deleteTaskByJobId(String jobId) {
        if (jobId == null || jobId.trim().length() == 0) {
            return 0;
        }
        String strSQL = "DELETE FROM T_SCH_TASk WHERE FJOBID= ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(F_JOBDID, 12, (Object)jobId)};
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            int n = DB.update((DBRoute)Sch_Route, (String)strSQL, (Object[])params);
            return n;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            handle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return 0;
    }

    public void save(TaskInfo[] taskArray) {
        String strSQL = "INSERT INTO T_SCH_TASK (FID,FJOBID,FENDTIME,FRUNTIME,FDISPATCHTIME,FDATA,FSTATUS,FPROGRESS,FRUNAT,FSCHEDULEID,FNUMBER,FTIMEOUT,FGROUPID,FCANSTOP,FINSTANCEID,FAPPID,FJOBTYPE,FMESSAGEID,FSCHEDULETIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<SqlParameter[]> paramss = new ArrayList<SqlParameter[]>(taskArray.length);
        for (TaskInfo taskInfo : taskArray) {
            SqlParameter[] params = new SqlParameter[19];
            params[0] = new SqlParameter(":FID", 12, (Object)taskInfo.getId());
            params[1] = new SqlParameter(F_JOBDID, 12, (Object)taskInfo.getJobId());
            params[2] = taskInfo.getEndTime() > 0L ? new SqlParameter(FEND_TIME, 93, (Object)new Timestamp(taskInfo.getEndTime())) : new SqlParameter(FEND_TIME, 93, null);
            params[3] = taskInfo.getRunTime() > 0L ? new SqlParameter(FRUN_TIME, 93, (Object)new Timestamp(taskInfo.getRunTime())) : new SqlParameter(FRUN_TIME, 93, null);
            params[4] = taskInfo.getDispachTime() > 0L ? new SqlParameter(":FDISPATCHTIME", 93, (Object)new Timestamp(taskInfo.getDispachTime())) : new SqlParameter(":FDISPATCHTIME", 93, null);
            params[5] = new SqlParameter(":FDATA", 12, (Object)taskInfo.getData());
            params[6] = new SqlParameter(FSTATUS, 12, (Object)taskInfo.getStatus());
            params[7] = new SqlParameter(FPROGRESS, 4, (Object)taskInfo.getProgress());
            String runAt = taskInfo.getRunAt();
            String instanceId = taskInfo.getInstanceId();
            if (runAt == null) {
                try {
                    runAt = ZkConfig.getHostIpAddress();
                    instanceId = Instance.getInstanceId();
                    taskInfo.setRunAt(runAt);
                    taskInfo.setInstanceId(instanceId);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            params[8] = new SqlParameter(":FRUNAT", 12, (Object)runAt);
            params[9] = new SqlParameter(FSCHEDULE_ID, 12, (Object)taskInfo.getScheduleId());
            params[10] = new SqlParameter(":FNUMBER", 12, (Object)taskInfo.getJobId());
            params[11] = new SqlParameter(":FTIMEOUT", 4, (Object)taskInfo.getTimeOut());
            long groupid = taskInfo.getGroupId();
            if (taskInfo.getRouteMode() != null && taskInfo.getRouteMode().equals("RAMDOM")) {
                groupid = 0L;
            }
            params[12] = new SqlParameter(":FGROUPID", -5, (Object)groupid);
            params[13] = new SqlParameter(":FCANSTOP", 12, (Object)(taskInfo.getCanStop() != false ? "1" : "0"));
            params[14] = new SqlParameter(":FINSTANCEID", 12, (Object)instanceId);
            params[15] = new SqlParameter(":FAPPID", 12, (Object)taskInfo.getAppid());
            params[16] = new SqlParameter(":FJOBTYPE", 12, (Object)taskInfo.getJobType());
            params[17] = new SqlParameter(":FMESSAGEID", 12, (Object)(taskInfo.getMessageId() == null ? " " : taskInfo.getMessageId()));
            params[18] = taskInfo.getScheduleTime() > 0L ? new SqlParameter(":FSCHEDULETIME", 93, (Object)new Timestamp(taskInfo.getScheduleTime())) : (taskInfo.getDispachTime() > 0L ? new SqlParameter(":FSCHEDULETIME", 93, (Object)new Timestamp(taskInfo.getDispachTime())) : new SqlParameter(":FSCHEDULETIME", 93, null));
            paramss.add(params);
        }
        TaskInfo[] taskInfoArray = null;
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)Sch_Route, (String)strSQL, paramss);
            }
            catch (Exception e) {
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
        catch (Throwable object) {
            taskInfoArray = object;
            throw object;
        }
        Exception exception = null;
        for (TaskInfo taskInfo : taskArray) {
            TaskCache.putTaskInfo(taskInfo);
            try {
                TaskCache.putTaskInfo(taskInfo);
            }
            catch (Exception exp) {
                JobInfo jobInfo = new JobInfo();
                jobInfo.setTaskId(taskInfo.getId());
                jobInfo.setId(taskInfo.getJobId());
                ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo(jobInfo, exp);
                this.jobDao.writeErrorJobInfo(errorJobInfo);
                exception = exp;
            }
            RequestContext rc = RequestContext.get();
            ObservableModel model = new ObservableModel(rc.getTenantId(), rc.getAccountId(), "Client", "taskCreate", (Object)taskInfo);
            ObservableLogHandler.collectData((ObservableModel)model);
        }
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    class DeleteTask
    implements Runnable {
        private RequestContext context;
        private String sql;
        private List<Object[]> delParams;

        public DeleteTask(RequestContext context, String strSQL, List<Object[]> delParams) {
            this.sql = strSQL;
            this.context = context;
            this.delParams = delParams;
        }

        @Override
        public void run() {
            RequestContext.copyAndSet((RequestContext)this.context);
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)Sch_Route, (String)this.sql, this.delParams);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    handle.markRollback();
                }
            }
        }
    }
}

