/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.dataentity.dao;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.schedule.dataentity.DeployScheduleEntity;
import kd.bos.schedule.dataentity.JobMainEntity;
import kd.bos.schedule.dataentity.JobMainEntityL;
import kd.bos.schedule.dataentity.ScheduleJobEntryEntity;
import kd.bos.schedule.dataentity.ScheduleMainEntity;
import kd.bos.schedule.dataentity.ScheduleMainEntityL;
import kd.bos.schedule.dataentity.TaskDefineMainEntity;
import kd.bos.schedule.dataentity.TaskDefineMainEntityL;

public class ScheduleEntityReader {
    private static Method businessDataReader_load;
    public static Class<?> businessDataReader;

    private static List<ScheduleMainEntity> readScheduleData(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<ScheduleMainEntity>(3);
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(ScheduleMainEntity.class);
        Object[] scheduleMainEntitys = ScheduleEntityReader.read(ids.toArray(), dt);
        ArrayList<ScheduleMainEntity> list = new ArrayList<ScheduleMainEntity>(10);
        ScheduleEntityReader.fillLocaleCollection(scheduleMainEntitys, list);
        return list;
    }

    private static void fillLocaleCollection(Object[] scheduleMainEntitys, List<ScheduleMainEntity> list) {
        for (Object data : scheduleMainEntitys) {
            ScheduleMainEntity it = (ScheduleMainEntity)data;
            LocaleString localeNames = new LocaleString();
            LocaleString localeDescription = new LocaleString();
            for (ScheduleMainEntityL locale : it.getLocaleCollection()) {
                localeNames.put(locale.getLocaleId(), (Object)locale.getName());
                localeDescription.put(locale.getLocaleId(), (Object)locale.getDescription());
            }
            it.setName(localeNames.toString());
            it.setDescription(localeDescription.toString());
            list.add(it);
        }
    }

    private static List<JobMainEntity> readJobData(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<JobMainEntity>(3);
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(JobMainEntity.class);
        Object[] scheduleMainEntitys = ScheduleEntityReader.read(ids.toArray(), dt);
        ArrayList<JobMainEntity> list = new ArrayList<JobMainEntity>(10);
        for (Object data : scheduleMainEntitys) {
            JobMainEntity it = (JobMainEntity)data;
            LocaleString localeNames = new LocaleString();
            LocaleString localeDescription = new LocaleString();
            for (JobMainEntityL locale : it.getLocaleCollection()) {
                localeNames.put(locale.getLocaleId(), (Object)locale.getName());
                localeDescription.put(locale.getLocaleId(), (Object)locale.getDescription());
            }
            it.setName(localeNames.toString());
            it.setDescription(localeDescription.toString());
            list.add(it);
        }
        return list;
    }

    private static List<TaskDefineMainEntity> readTaskDefineData(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<TaskDefineMainEntity>(3);
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(TaskDefineMainEntity.class);
        Object[] scheduleMainEntitys = ScheduleEntityReader.read(ids.toArray(), dt);
        ArrayList<TaskDefineMainEntity> list = new ArrayList<TaskDefineMainEntity>(10);
        for (Object data : scheduleMainEntitys) {
            TaskDefineMainEntity it = (TaskDefineMainEntity)data;
            LocaleString localeNames = new LocaleString();
            LocaleString localeDescription = new LocaleString();
            for (TaskDefineMainEntityL locale : it.getLocaleCollection()) {
                localeNames.put(locale.getLocaleId(), (Object)locale.getName());
                localeDescription.put(locale.getLocaleId(), (Object)locale.getDescription());
            }
            it.setName(localeNames.toString());
            it.setDescription(localeDescription.toString());
            list.add(it);
        }
        return list;
    }

    public static List<DeployScheduleEntity> getDeployDatasByScheduleId(List<String> scheduleIds, Map<String, Object> params) {
        List<ScheduleMainEntity> scheduleMainEntityList = ScheduleEntityReader.readScheduleData(scheduleIds);
        boolean override = Boolean.parseBoolean(String.valueOf(params.get("override")));
        ArrayList<String> jobIds = new ArrayList<String>(scheduleIds.size());
        HashMap<String, DeployScheduleEntity> datas = new HashMap<String, DeployScheduleEntity>(scheduleIds.size());
        HashMap schJobIdIndex = new HashMap(scheduleIds.size());
        for (ScheduleMainEntity it : scheduleMainEntityList) {
            DeployScheduleEntity data = new DeployScheduleEntity();
            data.setVersion("2.0");
            data.setExportTime(System.currentTimeMillis());
            data.setScheduleMainEntity(it);
            datas.put(it.getId(), data);
            schJobIdIndex.putIfAbsent(it.getId(), new HashSet(3));
            if (StringUtils.isNotBlank((CharSequence)it.getJobId())) {
                jobIds.add(it.getJobId());
                ((Set)schJobIdIndex.get(it.getId())).add(it.getJobId());
            }
            List entry = it.getEntryentity();
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                Iterator<Object> entryRow = (ScheduleJobEntryEntity)iterator.next();
                if (!StringUtils.isNotBlank((CharSequence)entryRow.getJobId())) continue;
                jobIds.add(entryRow.getJobId());
                ((Set)schJobIdIndex.get(it.getId())).add(entryRow.getJobId());
            }
        }
        ArrayList<String> taskDefineIds = new ArrayList<String>(jobIds.size());
        List<JobMainEntity> jobMainEntityList = ScheduleEntityReader.readJobData(jobIds);
        HashMap<String, JobMainEntity> jobIndex = new HashMap<String, JobMainEntity>(jobMainEntityList.size());
        for (JobMainEntity it : jobMainEntityList) {
            jobIndex.put(it.getId(), it);
            if (!StringUtils.isNotBlank((CharSequence)it.getTaskDefineId())) continue;
            taskDefineIds.add(it.getTaskDefineId());
        }
        List<TaskDefineMainEntity> taskDefineMainEntityList = ScheduleEntityReader.readTaskDefineData(taskDefineIds);
        HashMap<String, TaskDefineMainEntity> taskDefineIndex = new HashMap<String, TaskDefineMainEntity>(taskDefineIds.size());
        for (TaskDefineMainEntity taskDefineMainEntity : taskDefineMainEntityList) {
            taskDefineIndex.put(taskDefineMainEntity.getId(), taskDefineMainEntity);
        }
        for (Map.Entry entry : datas.entrySet()) {
            Set refJobIds;
            DeployScheduleEntity data = (DeployScheduleEntity)entry.getValue();
            if (override) {
                data.setOverride(true);
            }
            if ((refJobIds = (Set)schJobIdIndex.get(entry.getKey())) == null || refJobIds.isEmpty()) continue;
            List jobs = data.getJobMainEntityList();
            List taskDefines = data.getJobTaskMainEntityList();
            for (String jobId : refJobIds) {
                JobMainEntity jobData = (JobMainEntity)jobIndex.get(jobId);
                if (jobData == null) continue;
                jobs.add(jobData);
                TaskDefineMainEntity taskDefine = (TaskDefineMainEntity)taskDefineIndex.get(jobData.getTaskDefineId());
                if (taskDefine == null) continue;
                taskDefines.add(taskDefine);
            }
        }
        ArrayList<DeployScheduleEntity> result = new ArrayList<DeployScheduleEntity>();
        result.addAll(datas.values());
        return result;
    }

    private static Object[] read(Object[] pks, IDataEntityType dt) {
        try {
            return (Object[])ScheduleEntityReader.getLoadMethod().invoke(businessDataReader, pks, dt);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getLoadMethod() throws ClassNotFoundException, NoSuchMethodException {
        if (businessDataReader == null) {
            businessDataReader = Class.forName("kd.bos.data.BusinessDataReader");
        }
        if (businessDataReader_load == null) {
            businessDataReader_load = businessDataReader.getMethod("load", Object[].class, IDataEntityType.class);
        }
        return businessDataReader_load;
    }
}

