/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.schedule.ScheduleConst;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.message.SchThreadPoolWrapper;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public abstract class AbstractService
implements Service {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.message.AbstractService");
    public static final int DEFAULT_SESSION_TIMEOUT = 5000;
    protected ObjectFactory objectFactory = null;
    protected boolean isStart = false;
    protected ActiveKeyValueStore zkStore = null;
    public static final String SCHEDULE_ENV_KEY = "Schedule.Env";
    public static final String SCHEDULE_MESSAGE_MODE_KEY = "Schedule.Message.Mode";
    public static final String SCHEDULE_EXECUTOR_SERVER_NAME_KEY = "Schedule.Executor.Server.Name";
    private RunMode runMode = RunMode.Product;
    private String ipAddress = null;
    private static ConcurrentHashMap<MessageType, SchThreadPoolWrapper> threadPools = new ConcurrentHashMap(8);

    public RunMode getRunMode() {
        return this.runMode;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void start() {
        this.zkStore = ActiveKeyValueStore.create();
        String scheduleRootPath = ZkConfig.getScheduleRootPath();
        if (RunMode.Dev == ZkConfig.getRunMode()) {
            this.ipAddress = this.getIpAddress();
            this.runMode = RunMode.Dev;
        }
        this.zkStore.ensureExisted(ZkConfig.getScheduleRootPath(), String.valueOf(System.currentTimeMillis()));
        this.zkStore.ensureExisted(ZkConfig.getMasterServerPath(), String.valueOf(System.currentTimeMillis()));
        if ("ZooKeeper".equalsIgnoreCase(ZkConfig.getMessageMode())) {
            this.objectFactory = this.createObjectFactory(ZkConfig.getMessageMode());
        } else if ("MQ".equalsIgnoreCase(ZkConfig.getMessageMode())) {
            this.objectFactory = this.createObjectFactory(ZkConfig.getMessageMode());
        } else {
            ErrorCode ec = new ErrorCode("NOT_SUPPORT_MESSAGE_MODE", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u6a21\u5f0f", (String)"AbstractService_0", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        this.objectFactory.init();
        this.zkStore.ensureExisted(scheduleRootPath, String.valueOf(System.currentTimeMillis()));
    }

    public static String getRunServerName() {
        String serverName = null;
        String hostName = System.getProperty("HOSTNAME");
        String host = System.getProperty("HOST");
        String dubbo_port = System.getProperty("DUBBO_PORT");
        serverName = dubbo_port != null ? host + "_" + dubbo_port : hostName;
        if (serverName == null) {
            serverName = ZkConfig.getExecutorServerName();
        }
        return serverName;
    }

    public static String getHostIpAddress() {
        return ZkConfig.getHostIpAddress();
    }

    protected abstract ObjectFactory createObjectFactory(String var1);

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void stop() {
        this.isStart = false;
    }

    public boolean isStarted() {
        return this.isStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SchThreadPoolWrapper getThreadPool(MessageType messageType) {
        SchThreadPoolWrapper threadPool = threadPools.get(messageType);
        if (threadPool == null) {
            ConcurrentHashMap<MessageType, SchThreadPoolWrapper> concurrentHashMap = threadPools;
            synchronized (concurrentHashMap) {
                threadPool = threadPools.get(messageType);
                if (threadPool == null) {
                    int threadSize = ZkConfig.getMaxNumOfWorkThread(messageType);
                    String poolName = ScheduleConst.getThreadPoolName(messageType);
                    ThreadPool executor = ZkConfig.isPigeon() && Configs.isScheduleResourceBalanceEnable() ? new TenantFairPoolExecutor(poolName, threadSize, threadSize) : (MessageType.WorkFlowJOB == messageType && Configs.isWorkFlowResourceBalanceEnable() ? new TenantFairPoolExecutor(poolName, threadSize, threadSize) : ThreadPools.newFixedThreadPool((String)poolName, (int)threadSize));
                    threadPool = new SchThreadPoolWrapper(executor);
                    threadPools.put(messageType, threadPool);
                    log.info("Schedule***\u540e\u53f0\u4e8b\u52a1\u6267\u884c\u7ebf\u7a0b\u6570:" + threadSize);
                }
            }
        }
        return threadPool;
    }

    void setPoolSize(MessageType messageType, int i) {
    }

    static class TenantFairPoolExecutor
    implements ThreadPool {
        private final KDThreadPoolExecutor executor;

        public TenantFairPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize) {
            this.executor = KDThreadPoolFactory.getOrCreate((String)poolName, (int)corePoolSize, (int)maximumPoolSize);
        }

        public void execute(Runnable command) {
            this.executor.execute(command);
        }

        public void execute(Runnable command, RequestContext rc) {
            this.execute(command);
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        public <T> Future<T> submit(Callable<T> task, RequestContext rc) {
            return this.executor.submit(task);
        }

        public void close() {
            this.executor.shutdown();
        }

        public void executeIncludeRequestContext(Runnable command) {
            this.executor.execute(command);
        }

        public void executeIncludeRequestContext(Runnable command, RequestContext rc) {
            this.executor.execute(command);
        }
    }

    public static enum RunMode {
        Dev,
        Product;

    }
}

