/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageSender;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.SchEntityType;
import kd.bos.schedule.api.StrategyType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.dao.dbImpl.TaskCache;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.utils.ErrorProcessUtils;
import kd.bos.schedule.utils.ScheduleDataEntityUtils;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.trace.util.TraceIdUtil;

public class JobProcessor
implements Callable<Boolean>,
Runnable {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.message.JobProcessor");
    private MessageHandler handler;
    private MessageInfo message;
    private ObjectFactory objectFactory = null;
    private MessageAcker acker;
    private boolean isCancle = false;
    private boolean isTimeOut = false;
    private Throwable exception = null;
    private boolean taskFinished = false;
    private boolean isErrorInfoWrited = false;
    private static String lockKey = "schedule-";
    private static final String JOB_PROCESSOR_ERROR = "jobprocessor error:jobprocessor error:";
    private static final String BOS_SCHEDULE_MESSAGE = "bos-schedule-message";

    public Throwable getCancleReason() {
        return this.exception;
    }

    public void setCancleReason(Throwable exception) {
        this.exception = exception;
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public void setCancle(boolean isCancle) {
        this.isCancle = isCancle;
    }

    public boolean isTimeOut() {
        return this.isTimeOut;
    }

    public void setTimeOut(boolean timeOut) {
        this.isTimeOut = timeOut;
    }

    public MessageAcker getAcker() {
        return this.acker;
    }

    public void setAcker(MessageAcker acker) {
        this.acker = acker;
    }

    public MessageHandler getHandler() {
        return this.handler;
    }

    public void setHandler(MessageHandler handler) {
        this.handler = handler;
    }

    public MessageInfo getMessage() {
        return this.message;
    }

    public void setMessage(MessageInfo message) {
        this.message = message;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private MessageSender getMessageSender() {
        if (this.getObjectFactory() == null) {
            throw new IllegalArgumentException(" Schedule: Object Factory is null");
        }
        MessageSender sender = this.getObjectFactory().getMessageSender();
        if (sender == null) {
            throw new IllegalArgumentException(" Schedule: MessageSender is null");
        }
        return sender;
    }

    private void caughtException() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable throwable) {
                String error = String.format("Schedule***Background transaction error,AppName: %s,InstanceId: %s,taskId: %s ,errorInfo: %s", Instance.getAppName(), Instance.getInstanceId(), JobProcessor.this.message.getTaskId(), throwable.getMessage());
                log.error(JobProcessor.JOB_PROCESSOR_ERROR + error, throwable);
                JobProcessor.this.isCancle = true;
                JobProcessor.this.exception = throwable;
                JobProcessor.this.failed(JobProcessor.this.message, throwable);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void process() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkJob(JobInfo jobInfo) {
        if (jobInfo.isFromScheduler() && StringUtils.isNotBlank((CharSequence)jobInfo.getScheduleId())) {
            DynamicObject schObj = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Schedule, (Object)jobInfo.getScheduleId(), "status");
            String skipMsg = null;
            if (schObj == null) {
                this.isCancle = true;
                skipMsg = String.format("The current plan has been deleted,history task skipped execution,scheduleId=%s,jobId=%s", jobInfo.getScheduleId(), jobInfo.getId());
                this.skip(this.message, "SKIP_BY_SCH_DEL");
            } else if (!schObj.getBoolean("status")) {
                this.isCancle = true;
                skipMsg = String.format("The current plan has been disabled,history task skipped execution,scheduleId=%s,jobId=%s", jobInfo.getScheduleId(), jobInfo.getId());
                this.skip(this.message, "SKIP_BY_SCH_DISABLE");
            }
            if (!this.isCancle && StringUtils.isNotBlank((CharSequence)jobInfo.getId())) {
                DynamicObject jobObj = ScheduleDataEntityUtils.getInvoker().loadSingleFromCache(SchEntityType.Job, (Object)jobInfo.getId(), "status");
                if (jobObj == null) {
                    this.isCancle = true;
                    skipMsg = String.format("The current job has been deleted,history task skipped execution,scheduleId=%s,jobId=%s", jobInfo.getScheduleId(), jobInfo.getId());
                    this.skip(this.message, "SKIP_BY_JOB_DEL");
                } else if (!jobObj.getBoolean("status")) {
                    this.isCancle = true;
                    skipMsg = String.format("The current job has been disabled,history task skipped execution,scheduleId=%s,jobId=%s", jobInfo.getScheduleId(), jobInfo.getId());
                    this.skip(this.message, "SKIP_BY_JOB_DISABLE");
                }
            }
            if (this.isCancle) {
                if (this.acker != null) {
                    this.acker.ack(this.message.getMessageMQId());
                }
                log.info("Schedule***{},taskId={},jobNumber={}", new Object[]{skipMsg, this.message.getTaskId(), jobInfo.getNumber()});
                return false;
            }
        }
        return true;
    }

    private void handlerBroadcastMessage() {
        JobInfo jobInfo = this.message.fetchJobInfo();
        String taskId = this.message.getTaskId();
        TaskInfo taskInfo = this.createTaskInfo(taskId, jobInfo, this.message);
        this.message.fetchJobInfo().setTaskId(taskId);
        JobInfo jobInfos = (JobInfo)this.message.getJobInfo();
        jobInfos.setTaskId(taskId);
        if (jobInfos.getRetryTime() > 0) {
            ActiveKeyValueStore activeKeyValueStore = ActiveKeyValueStore.create();
            activeKeyValueStore.initAppIdExeServerMap(jobInfo.getAppId());
            TreeMap<String, Integer> exeServerMap = activeKeyValueStore.getExeServerMap();
            jobInfos.setExecuteTime(exeServerMap.size());
        }
        this.message.setJobInfo(jobInfos);
        this.objectFactory.getTaskDao().save(taskInfo);
    }

    private String genenateTaskId(JobInfo jobInfo) {
        boolean isBroadcast;
        boolean bl = isBroadcast = jobInfo.getRouteMode() == RouteMode.SHARDINGBROADCAST;
        if (jobInfo.getTaskId() == null || isBroadcast) {
            jobInfo.setTaskId(String.valueOf(DB.genLongId((String)"T_SCH_TASK")));
        }
        return jobInfo.getTaskId();
    }

    public JobInfo convertMessage(MessageInfo message) {
        return message.fetchJobInfo();
    }

    private void executeTask(JobInfo jobInfo) {
        if (this.acker != null) {
            this.acker.ack(this.message.getMessageMQId());
        }
        if (jobInfo.getJobType() == JobType.DETECT) {
            return;
        }
        if (JobType.BIZ != jobInfo.getJobType() && JobType.REALTIME != jobInfo.getJobType() || jobInfo.isRunConcurrently()) {
            this.handler.handle(this.message);
            return;
        }
        boolean isCover = StrategyType.COVERBEFORETASK.getValue().equals(jobInfo.getStrategy());
        String jobLockKey = JobProcessor.getJobLockKey(jobInfo);
        if (isCover) {
            this.handlerTaskCover(jobInfo, jobLockKey);
            return;
        }
        try (DLock lock = DLock.create((String)jobLockKey, (String)jobInfo.getTaskId());){
            if (lock.tryLock(0L)) {
                this.handler.handle(this.message);
            } else {
                this.isCancle = true;
                this.skip(this.message, "SKIP_RUNORDER_SERIAL");
            }
        }
    }

    public static String getJobLockKey(JobInfo jobInfo) {
        boolean isSharding;
        StringBuilder jobLockKey = new StringBuilder();
        jobLockKey.append(lockKey).append(jobInfo.getScheduleId()).append("-").append(jobInfo.getId());
        boolean isBroadcast = RouteMode.SHARDINGBROADCAST == jobInfo.getRouteMode();
        boolean bl = isSharding = RouteMode.SHARDINGTASK == jobInfo.getRouteMode();
        if (isBroadcast) {
            String serverName = AbstractService.getRunServerName();
            jobLockKey.append(serverName);
        }
        if (isSharding) {
            jobLockKey.append("_").append(jobInfo.getShareIndex());
        }
        if (log.isDebugEnabled()) {
            log.debug("Schedule***{}:{},taskId={},jobNumber={}", new Object[]{"jobLockKey", jobLockKey, jobInfo.getTaskId(), jobInfo.getNumber()});
        }
        return jobLockKey.toString();
    }

    private void handlerTaskCover(JobInfo jobInfo, String jobLockKey) {
        String jobInfoTaskId = jobInfo.getTaskId();
        String taskIdOld = TaskCache.getTaskId(jobLockKey);
        if (StringUtils.isNotBlank((CharSequence)taskIdOld)) {
            this.getObjectFactory().getTaskDao().setStop(taskIdOld);
        }
        TaskCache.putTaskId(jobLockKey, jobInfoTaskId);
        this.handler.handle(this.message);
    }

    private boolean begin(MessageInfo msg) {
        MessageInfo message = MessageCreator.createStatusMessage(msg.getTaskId(), "BEGIN", null);
        message.setTarget(ZkConfig.getExecutorServerName());
        message.setInstanceId(Instance.getInstanceId());
        message.setTraceId(TraceIdUtil.getCurrentTraceIdString());
        boolean ret = this.getMessageSender().udpateStorage(message);
        if (ret) {
            if (this.convertMessage(msg).isTaskTrace()) {
                log.info(String.format("Schedule***%s with handler- %s\uff1a%s", "begin to process message", this.handler.getClass().getSimpleName(), message));
            } else {
                log.debug(String.format("Schedule***%s with handler- %s\uff1a%s", "begin to process message", this.handler.getClass().getSimpleName(), message));
            }
            ObservableModel beginModel = new ObservableModel(msg.getTenantId(), msg.getAccountId(), "Client", "beginExecuteTask", (Object)msg);
            ObservableLogHandler.collectData((ObservableModel)beginModel);
        }
        return ret;
    }

    private void complete(MessageInfo msg) {
        MessageInfo message = MessageCreator.createStatusMessage(msg, "COMPLETED", null);
        message.setTarget(ZkConfig.getExecutorServerName());
        this.getMessageSender().send(message);
        this.deleteJob(msg);
        ObservableModel completeModel = new ObservableModel(msg.getTenantId(), msg.getAccountId(), "Server", "completeTaskSuccess", (Object)msg);
        ObservableLogHandler.collectData((ObservableModel)completeModel);
    }

    private void deleteJob(MessageInfo msg) {
        try {
            JobInfo jobInfo;
            if (msg != null && msg.getMessageType() == MessageType.WorkFlowJOB && (jobInfo = msg.fetchJobInfo()) != null && StringUtils.isNotEmpty((CharSequence)jobInfo.getId())) {
                this.getObjectFactory().getJobDao().delete(jobInfo.getId());
            }
        }
        catch (Throwable e) {
            log.error("Schedule**deleteJob error taskid : " + msg.getTaskId(), e);
        }
    }

    private void abort(MessageInfo msg) {
        this.taskFinished = true;
        MessageInfo message = MessageCreator.createStatusMessage(msg.getTaskId(), "ABORTED", "ABORTED_BY_USER", null);
        message.setTarget(ZkConfig.getExecutorServerName());
        this.getMessageSender().send(message);
        ObservableModel abortModel = new ObservableModel(msg.getTenantId(), msg.getAccountId(), "Client", "abortTaskByUser", (Object)msg);
        ObservableLogHandler.collectData((ObservableModel)abortModel);
    }

    private void skip(MessageInfo msg, String statusDesc) {
        this.taskFinished = true;
        MessageInfo message = MessageCreator.createStatusMessage(msg.getTaskId(), "SKIP", statusDesc, null);
        message.setTarget(ZkConfig.getExecutorServerName());
        this.getMessageSender().send(message);
        ObservableModel skipModel = new ObservableModel(msg.getTenantId(), msg.getAccountId(), "Client", "skipTask", (Object)msg);
        ObservableLogHandler.collectData((ObservableModel)skipModel);
    }

    public void timeout(MessageInfo msg) {
        this.taskFinished = true;
        MessageInfo message = MessageCreator.createStatusMessage(msg, "TIMEOUT", null);
        message.setTarget(ZkConfig.getExecutorServerName());
        this.getMessageSender().send(message);
        ObservableModel timeoutModel = new ObservableModel(msg.getTenantId(), msg.getAccountId(), "Client", "timeoutTask", (Object)msg);
        ObservableLogHandler.collectData((ObservableModel)timeoutModel);
    }

    private void failed(MessageInfo msg, Throwable exp) {
        this.taskFinished = true;
        if (this.isErrorInfoWrited) {
            return;
        }
        if (exp == null) {
            return;
        }
        MessageInfo message = MessageCreator.createStatusMessage(msg, "FAILED", exp.getMessage());
        message.setTarget(ZkConfig.getExecutorServerName());
        this.getMessageSender().send(message);
        JobInfo jobInfo = msg.fetchJobInfo();
        ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo(jobInfo, exp);
        JobDao jobDao = this.objectFactory.getJobDao();
        this.isErrorInfoWrited = true;
        jobDao.writeErrorJobInfo(errorJobInfo);
        ObservableModel model = new ObservableModel(message.getTenantId(), message.getAccountId(), "Client", "threadPoolError", (Object)msg);
        ObservableLogHandler.collectData((ObservableModel)model);
        try {
            if (JobType.BIZ != jobInfo.getJobType() && !jobDao.isExist(jobInfo.getId())) {
                jobDao.save(jobInfo);
            }
        }
        catch (Exception e) {
            log.error(JOB_PROCESSOR_ERROR + ErrorProcessUtils.buildSchErrMsg(message.getTaskId(), exp.getMessage()), exp);
            log.error("Schedule***save errjobinfo error: {},taskId={},jobNumber={}", new Object[]{jobInfo, message.getTaskId(), jobInfo.getNumber(), e});
        }
    }

    @Override
    public Boolean call() throws Exception {
        long beginJobTime = System.currentTimeMillis();
        this.caughtException();
        this.process();
        long endJobTime = System.currentTimeMillis();
        long taskSuccessTime = endJobTime - beginJobTime;
        HashMap<String, Long> taskSuccessMap = new HashMap<String, Long>(2);
        taskSuccessMap.put("time", taskSuccessTime);
        taskSuccessMap.put("messageType", (Long)this.message.getMessageType());
        ObservableModel model = new ObservableModel(this.message.getTenantId(), this.message.getAccountId(), "Client", "taskSuccessTime", taskSuccessMap);
        ObservableLogHandler.collectData((ObservableModel)model);
        return true;
    }

    @Override
    public void run() {
        long beginJobTime = System.currentTimeMillis();
        this.caughtException();
        this.process();
        long endJobTime = System.currentTimeMillis();
        long taskSuccessTime = endJobTime - beginJobTime;
        HashMap<String, Long> taskSuccessMap = new HashMap<String, Long>(2);
        taskSuccessMap.put("time", taskSuccessTime);
        taskSuccessMap.put("messageType", (Long)this.message.getMessageType());
        ObservableModel model = new ObservableModel(this.message.getTenantId(), this.message.getAccountId(), "Client", "taskSuccessTime", taskSuccessMap);
        ObservableLogHandler.collectData((ObservableModel)model);
    }

    private TaskInfo createTaskInfo(String taskId, JobInfo jobInfo, MessageInfo message) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setId(taskId);
        taskInfo.setData(null);
        taskInfo.setDispachTime(System.currentTimeMillis());
        taskInfo.setEndTime(0L);
        taskInfo.setJobId(jobInfo.getId());
        taskInfo.setScheduleId(jobInfo.getScheduleId());
        taskInfo.setProgress(0);
        taskInfo.setRunAt(message.getTarget());
        taskInfo.setRunTime(0L);
        taskInfo.setStatus("SCHEDULED");
        taskInfo.setTimeOut(jobInfo.getTimeout());
        taskInfo.setRetryTime(jobInfo.getRetryTime());
        taskInfo.setGroupId(jobInfo.getGroupId());
        taskInfo.setRouteMode(String.valueOf(jobInfo.getRouteMode()));
        taskInfo.setCanStop(StringUtils.isBlank((Object)jobInfo.getCanStop()) ? Boolean.FALSE : jobInfo.getCanStop());
        taskInfo.setJobType(jobInfo.getJobType());
        taskInfo.setAppid(jobInfo.getAppId());
        taskInfo.setScheduleTime(jobInfo.getScheduleTime());
        return taskInfo;
    }
}

