/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.filter.ExecutorServerStatusFilter;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.utils.ScheduleAccountUtils;
import kd.bos.schedule.zk.ZkConfig;

public class ReadyTasks {
    private static final Log log = LogFactory.getLog(ReadyTasks.class);
    private static final Map<MessageType, ReadyTasks> maps = ReadyTasks.initMaps();
    private static ObjectFactory objectFactory = null;
    private AtomicInteger atomicIndex = new AtomicInteger(0);
    private Object inLock = new Object();
    private AtomicInteger taskSize = new AtomicInteger(0);
    private boolean isMultiAccount = false;
    private final MessageType messageType;
    private Map<String, Queue<MessageInfo>> map = new ConcurrentHashMap<String, Queue<MessageInfo>>(8);

    private ReadyTasks(MessageType messageType) {
        this.messageType = messageType;
    }

    public Integer getTaskSize() {
        return this.taskSize.get();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    private static ConcurrentHashMap<MessageType, ReadyTasks> initMaps() {
        ConcurrentHashMap<MessageType, ReadyTasks> map = new ConcurrentHashMap<MessageType, ReadyTasks>(8);
        for (MessageType value : MessageType.values()) {
            ReadyTasks readyTasks = new ReadyTasks(value);
            readyTasks.init();
            map.put(value, readyTasks);
        }
        try {
            ObservableLogHandler.addFilter((String)ExecutorServerStatusFilter.class.getName());
        }
        catch (Exception e) {
            log.error("Schedule***\u521d\u59cb\u5316\u6267\u884c\u673a\u8fc7\u6ee4\u5668\u5931\u8d25\uff0cclass={}", (Object)ExecutorServerStatusFilter.class.getName());
        }
        return map;
    }

    public static ReadyTasks getInstance(MessageType messageType) {
        return maps.get(messageType);
    }

    public static ObjectFactory getObjectFactory() {
        return objectFactory;
    }

    public static void setObjectFactory(ObjectFactory objectFactory) {
        ReadyTasks.objectFactory = objectFactory;
    }

    void init() {
        List<Account> accounts;
        try {
            accounts = ReadyTasks.getAllAccounts();
            if (accounts.size() > 2) {
                this.isMultiAccount = true;
            }
        }
        catch (Throwable t) {
            log.error("Schedule***getAllAccountsOfCurrentEnv error", t);
            accounts = new ArrayList<Account>(6);
        }
        for (Account account : accounts) {
            this.getAccountQueue(account.getAccountId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean in(MessageInfo messageInfo, long timeout) {
        Object object;
        if (messageInfo == null) {
            return true;
        }
        int maxSize = this.getMaxReadyTasksSize();
        if (this.isExceed(maxSize)) {
            boolean isExceed = true;
            int i = 0;
            while ((long)i < timeout / 1000L) {
                ++i;
                object = this.inLock;
                synchronized (object) {
                    try {
                        this.inLock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e);
                    }
                }
                if (this.isExceed(maxSize)) continue;
                isExceed = false;
                break;
            }
            if (isExceed) {
                return false;
            }
        }
        boolean ret = false;
        try {
            try {
                ret = ReadyTasks.getObjectFactory().getTaskDao().updateStatus(messageInfo.getTaskId(), "READY");
            }
            catch (Throwable t) {
                log.error("Schedule*** updateStatus READY error, messageInfo : " + messageInfo + " is abandon", t);
                return true;
            }
            if (ret) {
                Queue<MessageInfo> queue = this.getAccountQueue(messageInfo.getAccountId());
                object = this;
                synchronized (object) {
                    queue.offer(messageInfo);
                    this.taskSize.incrementAndGet();
                    log.debug("Schedule*** readyTask[{}] in,taskId={}", (Object)this.getMessageType(), (Object)messageInfo.getTaskId());
                    this.notify();
                }
            } else {
                log.warn("Schedule*** readyTask in updateStatus DB return false,this task has been done and task will drop ,messageInfo={}", (Object)messageInfo);
                return true;
            }
            SchObservableCollectData.collectData((String)messageInfo.getTenantId(), (String)messageInfo.getAccountId(), (String)"Client", (String)"pushLocalReadyQueue", (Object)messageInfo);
        }
        catch (Throwable t) {
            log.error("Schedule*** in error. messageInfo : " + messageInfo, t);
        }
        return ret;
    }

    private boolean isExceed(int maxSize) {
        return this.size() >= maxSize;
    }

    public MessageInfo take() {
        return this.take(30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageInfo take(long timeout) {
        MessageInfo messageInfo;
        while ((messageInfo = this.scanNext()) == null) {
            ReadyTasks readyTasks = this;
            synchronized (readyTasks) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return messageInfo;
    }

    private synchronized MessageInfo scanNext() {
        MessageInfo messageInfo = null;
        try {
            Set<String> accountSet = this.map.keySet();
            if (accountSet.isEmpty()) {
                return null;
            }
            ArrayList<String> accounts = new ArrayList<String>(accountSet);
            Collections.sort(accounts);
            int size = accounts.size();
            for (int i = 0; i < size; ++i) {
                messageInfo = this.next(accounts);
                if (messageInfo == null) continue;
            }
            if (messageInfo != null && this.isExceed(this.getMaxReadyTasksSize())) {
                this._notify();
            }
        }
        catch (Throwable t) {
            log.error("Schedule***messageType:{},ReadyTasks scan message error", (Object)this.messageType, (Object)t);
        }
        return messageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _notify() {
        ReadyTasks readyTasks = this;
        synchronized (readyTasks) {
            this.notify();
        }
    }

    private MessageInfo next(List<String> accounts) {
        Queue<MessageInfo> queue;
        MessageInfo messageInfo;
        int accountSize;
        int runningSize;
        this.atomicIndex.compareAndSet(Integer.MAX_VALUE, 0);
        int index = this.atomicIndex.getAndIncrement() % accounts.size();
        String account = accounts.get(index);
        if (this.isLimitAccountTask() && (runningSize = RunningTasks.getInstance(this.getMessageType()).getMessageInfos(account).length) >= (accountSize = Integer.parseInt(System.getProperty("Schedule.Executor.NumOfWorkThreadAccount", String.valueOf(ZkConfig.getMaxNumOfWorkThread(this.getMessageType()) / 2))))) {
            int newIndex = index == accounts.size() - 1 ? 0 : index + 1;
            account = accounts.get(newIndex);
        }
        if ((messageInfo = (queue = this.getAccountQueue(account)).poll()) != null) {
            this.taskSize.decrementAndGet();
            SchObservableCollectData.collectData((String)messageInfo.getTenantId(), (String)messageInfo.getAccountId(), (String)"Client", (String)"popLocalReadyQueue", (Object)messageInfo);
        }
        return messageInfo;
    }

    int size() {
        return this.taskSize.get();
    }

    int realSize() {
        int i = 0;
        for (Queue<MessageInfo> queue : this.map.values()) {
            i += queue.size();
        }
        return i;
    }

    MessageInfo[] getMessageInfos() {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>(6);
        for (Queue<MessageInfo> queue : this.map.values()) {
            list.addAll(queue);
        }
        return list.toArray(new MessageInfo[0]);
    }

    private static List<Account> getAllAccounts() {
        try {
            return ScheduleAccountUtils.getAllAccountsOfCurrentEnv(false);
        }
        catch (Throwable t) {
            log.error("Schedule***getAllAccountsOfCurrentEnv error", t);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<MessageInfo> getAccountQueue(String account) {
        Queue<MessageInfo> queue = this.map.get(account);
        if (queue == null) {
            Map<String, Queue<MessageInfo>> map = this.map;
            synchronized (map) {
                queue = this.map.get(account);
                if (queue == null) {
                    queue = new ConcurrentLinkedQueue<MessageInfo>();
                    this.map.put(account, queue);
                }
            }
        }
        return queue;
    }

    private int getMaxReadyTasksSize() {
        return ZkConfig.getReadyTasksSize() - 1;
    }

    private boolean isLimitAccountTask() {
        return false;
    }
}

