/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.dao.dbImpl.DbTaskDAO;
import kd.bos.schedule.message.ReadyTasks;

public class RunningTasks {
    private static Log log = LogFactory.getLog(RunningTasks.class);
    private static final Map<MessageType, RunningTasks> maps = RunningTasks.initMaps();
    private static final String CACHE_TYPE = "RunningTasks";
    private static final String BOS_SCHEDULE_MESSAGE = "bos-schedule-message";
    private ConcurrentHashMap<String, MessageInfo> map = new ConcurrentHashMap();
    private static final Counter activeComsumer = MetricSystem.counter((String)"kd.metrics.schedule.consumer.activeThreads");
    private final MessageType messageType;

    private RunningTasks(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    private static ConcurrentHashMap<MessageType, RunningTasks> initMaps() {
        ConcurrentHashMap<MessageType, RunningTasks> map = new ConcurrentHashMap<MessageType, RunningTasks>(8);
        for (MessageType value : MessageType.values()) {
            map.put(value, new RunningTasks(value));
        }
        return map;
    }

    public static RunningTasks getInstance(MessageType messageType) {
        return maps.get(messageType);
    }

    public synchronized boolean put(MessageInfo messageInfo) {
        if (messageInfo == null || messageInfo.getId() == null) {
            return true;
        }
        this.map.put(RunningTasks.buildCacheKey(messageInfo.getAccountId(), messageInfo.getId()), messageInfo);
        activeComsumer.inc();
        if (log.isDebugEnabled()) {
            log.debug("Schedule*** runningtasks put,messageInfo:{}", (Object)messageInfo);
        }
        return true;
    }

    public synchronized void dispose(MessageInfo messageInfo) {
        if (messageInfo == null || messageInfo.getId() == null) {
            return;
        }
        activeComsumer.dec();
        MessageInfo ret = this.map.remove(RunningTasks.buildCacheKey(messageInfo.getAccountId(), messageInfo.getId()));
        if (ret == null) {
            log.warn("Schedule*** runningtasks dispose warn. messageInfo : {}", (Object)messageInfo);
        }
        if (log.isDebugEnabled()) {
            log.debug("Schedule*** runningtasks dispose. messageInfo : {}", (Object)messageInfo);
        }
        ReadyTasks.getInstance(this.getMessageType())._notify();
    }

    public int size() {
        return this.map.size();
    }

    public MessageInfo[] getMessageInfos() {
        return this.map.values().toArray(new MessageInfo[0]);
    }

    public static String getThreadDump(MessageType messageType, String accountId, String messageId) {
        RunningTasks instance = RunningTasks.getInstance(messageType);
        MessageInfo messageInfo = instance.map.get(RunningTasks.buildCacheKey(accountId, messageId));
        if (messageInfo != null && messageInfo.getThread() != null) {
            return RunningTasks.formatThreadDump(messageInfo, 1);
        }
        return "";
    }

    public static List<String> getAllThreadDump(MessageType messageType) {
        RunningTasks instance = RunningTasks.getInstance(messageType);
        ArrayList<String> allThreadDump = new ArrayList<String>(instance.map.size());
        int messageTaskIndex = 1;
        for (Map.Entry<String, MessageInfo> entry : instance.map.entrySet()) {
            MessageInfo messageInfo = entry.getValue();
            allThreadDump.add(RunningTasks.formatThreadDump(messageInfo, messageTaskIndex++));
        }
        return allThreadDump;
    }

    private static String formatThreadDump(MessageInfo messageInfo, int messageTaskIndex) {
        String taskId = messageInfo.getTaskId();
        String tenantId = messageInfo.getTenantId();
        Thread taskThread = messageInfo.getThread();
        String threadName = taskThread.getName();
        DbTaskDAO dbTaskDAO = new DbTaskDAO();
        TaskInfo taskInfo = dbTaskDAO.get(taskId);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long runtime = taskInfo.getRunTime();
        if (runtime == 0L) {
            runtime = System.currentTimeMillis();
        }
        String startTime = formatter.format(new Date(runtime));
        StringBuilder sb = new StringBuilder(1024);
        StackTraceElement[] stack = taskThread.getStackTrace();
        String taskDesc = String.format("<p><strong>%s.The task is {%s}, tenantId is {%s}</strong></p>", messageTaskIndex, taskId, tenantId);
        String threadDesc = String.format("<p>and was started at <strong>%s</strong></p>", threadName);
        String startTimeDesc = String.format(ResManager.loadKDString((String)"<p>\u542f\u52a8\u65f6\u95f4\uff1a%s</p>", (String)"RunningTasks_0", (String)BOS_SCHEDULE_MESSAGE, (Object[])new Object[0]), startTime);
        long exeTime = System.currentTimeMillis() - taskInfo.getRunTime();
        String durationDesc = String.format(ResManager.loadKDString((String)"<p>\u5df2\u8fd0\u884c\uff1a%s\u79d2</p>", (String)"RunningTasks_1", (String)BOS_SCHEDULE_MESSAGE, (Object[])new Object[0]), (System.currentTimeMillis() - runtime) / 1000L);
        String dumpDesc = String.format(ResManager.loadKDString((String)"%1$s\u5806\u6808\u4fe1\u606f%2$s", (String)"RunningTasks_2", (String)BOS_SCHEDULE_MESSAGE, (Object[])new Object[0]), "<p><span style=\"color:#3399ff;\"><strong>\u3010", "\u3011</strong></span><br/>");
        sb.append(taskDesc).append(threadDesc).append(startTimeDesc).append(durationDesc).append(dumpDesc);
        for (StackTraceElement se : stack) {
            sb.append("at ").append(se.getClassName()).append('.').append(se.getMethodName()).append('(').append(se.getFileName()).append(':').append(se.getLineNumber()).append(")<br/>");
        }
        sb.append("</p>");
        return sb.toString();
    }

    MessageInfo[] getMessageInfos(String account) {
        ArrayList<MessageInfo> ret = new ArrayList<MessageInfo>(this.map.size());
        for (MessageInfo messageInfo : this.map.values()) {
            if (!account.equals(messageInfo.getAccountId())) continue;
            ret.add(messageInfo);
        }
        return ret.toArray(new MessageInfo[0]);
    }

    private static String buildCacheKey(String accountId, String messageId) {
        return new StringBuffer(CACHE_TYPE).append(".").append(accountId).append(".").append(messageId).toString();
    }
}

