/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.JobProcessor;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPool;

public class SchThreadPoolWrapper {
    private static Log log = LogFactory.getLog(SchThreadPoolWrapper.class);
    private final ThreadPool threadPool;

    SchThreadPoolWrapper(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void execute(JobProcessor jobProcessor) {
        MessageInfo message = jobProcessor.getMessage();
        if (!(ZkConfig.isPigeon() || MessageType.WorkFlowJOB == message.getMessageType() && Configs.isWorkFlowResourceBalanceEnable() || message.getMessageMQId() == null && message.getMessageType() != MessageType.BROADCASTJOB)) {
            RunningTasks.getInstance(message.getMessageType()).put(message);
        }
        if (log.isDebugEnabled()) {
            log.debug("Schedule***message:{}", (Object)message);
        }
        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"submitThreadPool", (Object)message);
        this.threadPool.execute((Runnable)jobProcessor);
    }
}

