/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.mq;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.AbstractMessageSender;
import kd.bos.schedule.message.mq.MQHelper;
import kd.bos.schedule.next.observable.util.SchObservableCollectData;
import kd.bos.schedule.utils.ErrorProcessUtils;

public class MQMessageSender
extends AbstractMessageSender {
    private static Log log = LogFactory.getLog(MQMessageSender.class);
    private SecureRandom random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageInfo message) throws KDException {
        block26: {
            try (MessagePublisher publisher = null;){
                String msgStr = SerializationUtils.toJsonString((Object)message);
                if (message.getMessageType() == MessageType.BIZJOB || message.getMessageType() == MessageType.REALTIMEJOB || message.getMessageType() == MessageType.WorkFlowJOB) {
                    JobInfo jobInfo = message.fetchJobInfo();
                    if (jobInfo != null && jobInfo.isTaskTrace()) {
                        log.info("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ \uff1a{}", (Object)message);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ \uff1a,taskId={},{}", (Object)message.getTaskId(), (Object)msgStr);
                    }
                    try {
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"beginSendMQ", (Object)message);
                        publisher = this.scheduleTargetMQ(message);
                        publisher.publish(msgStr);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"sendMQSuccess", (Object)message);
                        break block26;
                    }
                    catch (Throwable e) {
                        log.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ\u5931\u8d25 \uff1a,message={}", (Object)message, (Object)e);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"sendMQERROR", (Object)message);
                        TXHandle handle = TX.requiresNew();
                        Throwable throwable = null;
                        try {
                            try {
                                try {
                                    ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo(jobInfo, e);
                                    this.getObjectFactory().getJobDao().writeErrorJobInfo(errorJobInfo);
                                    this.getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), "FAILED", null);
                                }
                                catch (Exception exp) {
                                    log.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ\u5931\u8d25\uff0c\u4e14\u5199\u5165\u65e5\u5fd7\u5931\u8d25 \uff1amessage={}", (Object)message, (Object)exp);
                                }
                                finally {
                                    throw e;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (handle != null) {
                                if (throwable != null) {
                                    try {
                                        handle.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    handle.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                }
                if (message.getMessageType() != MessageType.BIZ_TASK_FEEDBACK && message.getMessageType() != MessageType.WorkFlow_TASK_FEEDBACK) break block26;
                try {
                    this.udpateStorage(message);
                }
                catch (Throwable e) {
                    log.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25 \uff1amessage={}", (Object)message, (Object)e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] send(List<MessageInfo> messageList) throws KDException {
        int i;
        log.info("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ \uff1a{}", messageList);
        HashMap<String, MessagePublisher> map = new HashMap<String, MessagePublisher>(8);
        int[] ret = new int[messageList.size()];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = 0;
        }
        try {
            for (i = 0; i < messageList.size(); ++i) {
                MessageInfo message = messageList.get(i);
                if (message.getMessageType() == MessageType.BIZJOB || message.getMessageType() == MessageType.REALTIMEJOB || message.getMessageType() == MessageType.WorkFlowJOB) {
                    String appId;
                    JobInfo jobInfo = message.fetchJobInfo();
                    if (jobInfo == null || StringUtils.isEmpty((CharSequence)(appId = jobInfo.getAppId()))) continue;
                    try {
                        OperationContext oc = new OperationContext();
                        oc.setAppId(jobInfo.getAppId());
                        oc.setFormId(jobInfo.getNumber());
                        oc.setFormName(jobInfo.getTaskClassname());
                        OperationContext.set((OperationContext)oc);
                        String msgStr = SerializationUtils.toJsonString((Object)message);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"beginSendMQ", (Object)message);
                        MessagePublisher publisher = (MessagePublisher)map.get(appId);
                        if (publisher == null) {
                            publisher = this.scheduleTargetMQ(message);
                            map.put(appId, publisher);
                        }
                        publisher.publish(msgStr);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"sendMQSuccess", (Object)message);
                        ret[i] = 1;
                        continue;
                    }
                    catch (Throwable e) {
                        log.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u6d88\u606f\u5230MQ\u5931\u8d25 \uff1a,message={}", (Object)message, (Object)e);
                        SchObservableCollectData.collectData((String)message.getTenantId(), (String)message.getAccountId(), (String)"Server", (String)"sendMQERROR", (Object)message);
                        try (TXHandle handle = TX.requiresNew();){
                            try {
                                ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo(jobInfo, e);
                                this.getObjectFactory().getJobDao().writeErrorJobInfo(errorJobInfo);
                                this.getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), "FAILED", null);
                            }
                            catch (Exception exp) {
                                log.error("Schedule***batchdispatch:\u5199\u5165\u65e5\u5fd7\u5931\u8d25 \uff1ataskId={}", (Object)message.getTaskId(), (Object)exp);
                            }
                            continue;
                        }
                    }
                }
                if (message.getMessageType() != MessageType.BIZ_TASK_FEEDBACK && message.getMessageType() != MessageType.WorkFlow_TASK_FEEDBACK) continue;
                try {
                    this.udpateStorage(message);
                    continue;
                }
                catch (Throwable e) {
                    log.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25 \uff1amessage={}", (Object)message, (Object)e);
                    throw e;
                }
            }
            int[] nArray = ret;
            return nArray;
        }
        finally {
            for (MessagePublisher publisher : map.values()) {
                if (publisher == null) continue;
                publisher.close();
            }
        }
    }

    private MessagePublisher scheduleTargetMQ(MessageInfo messageInfo) {
        MessagePublisher publisher = null;
        MessageType msgType = messageInfo.getMessageType();
        if (msgType == MessageType.BIZJOB || msgType == MessageType.REALTIMEJOB || msgType == MessageType.WorkFlowJOB) {
            JobInfo jobInfo = messageInfo.fetchJobInfo();
            this.ensureJobAppId(jobInfo);
            publisher = MQHelper.getJobMessagePulisher(messageInfo);
        } else if (msgType == MessageType.BIZ_TASK_FEEDBACK || msgType == MessageType.WorkFlow_TASK_FEEDBACK) {
            publisher = MQHelper.getTaskStausPulisher();
        }
        if (publisher == null) {
            ErrorCode ec = new ErrorCode("DISPATCH_JOB_FAILED", ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u7684\u6d88\u606f\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u5e03\u8005:%s", (String)"MQMessageSender_1", (String)"bos-schedule-message", (Object[])new Object[0]));
            throw new KDException(ec, new Object[]{messageInfo.toString()});
        }
        return publisher;
    }

    private MessagePublisher getRandomPublisher(List<MessagePublisher> publishers) {
        int size = publishers.size();
        if (size == 1) {
            return publishers.get(0);
        }
        if (size < 1) {
            return null;
        }
        MessagePublisher publisher = publishers.get(this.random.nextInt(size));
        return publisher;
    }

    private void ensureJobAppId(JobInfo jobInfo) {
        if (StringUtils.isBlank((CharSequence)jobInfo.getAppId())) {
            jobInfo.setAppId("bos");
        }
    }
}

