/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.mq;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.Subscriber;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.message.mq.AsynCallBackExecutor;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import org.apache.curator.shaded.com.google.common.base.Objects;

public class MQSubscriber
implements Subscriber {
    ConcurrentHashMap<String, MessageHandler> subscriberContain = new ConcurrentHashMap();
    private static final Log log = LogFactory.getLog(MQSubscriber.class);
    ObjectFactory objectFactory;
    AtomicBoolean isStart = new AtomicBoolean(false);
    Thread thread;
    private static final String TWO_PLACEHOLDER = "%s#%s";

    public void start() {
        if (!this.isStart.get()) {
            ThreadPools.executeOnce((String)"BOSSchedule-jobClient-monitor", (Runnable)new Monitor());
            this.isStart.compareAndSet(false, true);
        }
    }

    public void stop() {
        if (this.isStart.get()) {
            this.isStart.compareAndSet(true, false);
        }
    }

    public void subscribe(String taskId, MessageHandler handler) throws KDException {
        if (!this.isStart.get()) {
            this.start();
        }
        String accountId = RequestContext.get().getAccountId();
        this.subscriberContain.put(String.format(TWO_PLACEHOLDER, accountId, taskId), handler);
    }

    public void unSubscribe(String taskId) {
        String accountId = RequestContext.get().getAccountId();
        this.subscriberContain.remove(String.format(TWO_PLACEHOLDER, accountId, taskId));
    }

    public void setObjectFactory(ObjectFactory mqObjectFactory) {
        this.objectFactory = mqObjectFactory;
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        public void execute() {
            log.info("ScheduleMonitor is running.");
            while (MQSubscriber.this.isStart.get()) {
                long sleeptime;
                int circleInteval = ZkConfig.getCircle4JobCallBack() * 1000;
                long beginat = System.currentTimeMillis();
                try {
                    this.oneCycle();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                if ((sleeptime = (long)circleInteval - (System.currentTimeMillis() - beginat)) <= 0L) continue;
                try {
                    Thread.sleep(sleeptime);
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
            }
        }

        public void oneCycle() {
            TaskDao taskDao = MQSubscriber.this.objectFactory.getTaskDao();
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            for (Account account : accounts) {
                String accountId = account.getAccountId();
                List taskIds = MQSubscriber.this.subscriberContain.keySet().stream().filter(key -> {
                    String[] taskMsgs = key.split("#");
                    return Objects.equal((Object)accountId, (Object)taskMsgs[0]);
                }).map(key -> key.split("#")[1]).collect(Collectors.toList());
                if (taskIds.isEmpty()) continue;
                try {
                    RequestContextUtils.createRequestContext(account.getTenantId(), accountId, null);
                    List taskInfos = taskDao.get(taskIds);
                    for (TaskInfo taskInfo : taskInfos) {
                        this.processTaskCallBack(taskInfo);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }

        private void processTaskCallBack(TaskInfo taskInfo) {
            RequestContext rc = RequestContext.get();
            String accountId = rc.getAccountId();
            String taskId = taskInfo.getId();
            MessageInfo message = MessageCreator.createStatusMessage(taskInfo);
            MessageHandler handler = MQSubscriber.this.subscriberContain.get(String.format(MQSubscriber.TWO_PLACEHOLDER, accountId, taskId));
            AsynCallBackExecutor.get().executeCallBack(handler, message);
            if ("TASK_STATUS".equals(message.getTitle()) && TaskStatusConstant.isEnd((String)taskInfo.getStatus())) {
                MQSubscriber.this.unSubscribe(taskId);
            }
        }

        @Override
        public void run() {
            this.execute();
        }
    }
}

