/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.message.zk;

import com.alibaba.fastjson.JSON;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageSender;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.api.TaskResult;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.zk.ActiveKeyValueStore;
import kd.bos.schedule.zk.ZkConfig;
import org.apache.zookeeper.ZooKeeper;

public class ZkMessageSender
implements MessageSender {
    private static Log log = LogFactory.getLog((String)"kd.bos.schedule.message.zk.ZkMessageSender");
    private static final String BROADCAST_FAIL = "SECHDULE_BROADCAST_FAIL";
    private static String SEPARATOR = "/";
    protected ZooKeeper zkClient = null;
    protected ActiveKeyValueStore zkStore = null;
    protected ObjectFactory objectFactory = null;

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setZooKeeper() {
        this.zkStore = ActiveKeyValueStore.create();
    }

    public ActiveKeyValueStore getZkStore() {
        return this.zkStore;
    }

    public void send(MessageInfo message) throws KDException {
        if (log.isInfoEnabled()) {
            log.info("send message:{}", (Object)message);
        }
        if (message.getMessageType() == MessageType.BIZJOB || message.getMessageType() == MessageType.WorkFlowJOB) {
            String taskStatusPath = ZkConfig.getTaskStatusPath(message.getTaskId());
            MessageInfo statusMessage = MessageCreator.createStatusMessage(message.getTaskId(), "SCHEDULED", null);
            statusMessage.setTarget(message.getTarget());
            this.zkStore.write(taskStatusPath, JSON.toJSONString((Object)statusMessage));
            String path = ZkConfig.getJobPath(message);
            String value = JSON.toJSONString((Object)message);
            this.zkStore.write(path, value);
        } else if (message.getMessageType() == MessageType.BIZ_TASK_FEEDBACK || message.getMessageType() == MessageType.WorkFlow_TASK_FEEDBACK) {
            String taskStatusPath = ZkConfig.getTaskStatusPath(message.getTaskId());
            this.udpateStorage(message);
            this.zkStore.write(taskStatusPath, JSON.toJSONString((Object)message));
        }
    }

    public boolean udpateStorage(MessageInfo message) {
        boolean ret = true;
        TaskResult taskResult = message.fectchTaskResult();
        if (TaskResult.ResultTypeEnum.STATUS == taskResult.getResultType()) {
            ret = this.getObjectFactory().getTaskDao().updateStatus(message.getTaskId(), taskResult.getStatus());
        } else if (TaskResult.ResultTypeEnum.PROGRESS == taskResult.getResultType()) {
            this.getObjectFactory().getTaskDao().updateProgress(message.getTaskId(), taskResult.getProgress());
        } else if (TaskResult.ResultTypeEnum.CUSTOMDATA == taskResult.getResultType()) {
            this.getObjectFactory().getTaskDao().updateCustomData(message.getTaskId(), taskResult.getCustomData());
        }
        return ret;
    }

    public void broadcastMsg(MessageInfo message) throws KDException {
        String appId = message.fetchJobInfo().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            ErrorCode ec = new ErrorCode(BROADCAST_FAIL, "broadcast not configured appId");
            throw new KDException(ec, new Object[0]);
        }
        String accountId = RequestContext.get().getAccountId();
        ActiveKeyValueStore activeKeyValueStore = ActiveKeyValueStore.create();
        activeKeyValueStore.initAppIdExeServerMap(appId);
        TreeMap<String, Integer> exeServerMap = activeKeyValueStore.getExeServerMap();
        String broadcastPath = ZkConfig.getJobRootPath() + SEPARATOR + accountId + SEPARATOR + appId;
        this.broadCast(message, exeServerMap, broadcastPath);
    }

    private void broadCast(MessageInfo message, TreeMap<String, Integer> exeServerMap, String broadcastPath) {
        try (DLock lock = DLock.create((String)broadcastPath);){
            if (lock.tryLock(0L)) {
                String msg = SerializationUtils.toJsonString((Object)message);
                log.info("\u540e\u53f0\u4e8b\u52a1\u5e7f\u64ad\u6d88\u606f- " + broadcastPath + "\uff1a" + msg);
                for (String exeServerName : exeServerMap.keySet()) {
                    this.zkStore.publishBroadcastMsg(broadcastPath + SEPARATOR + exeServerName, msg);
                }
            } else {
                this.waitTime(1000L);
                this.broadCast(message, exeServerMap, broadcastPath);
            }
        }
    }

    private void waitTime(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage());
        }
    }
}

