/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.LogQueryUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ErrorJobInfo;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.api.ServerManager;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.schedule.dao.dbImpl.DbTaskDAO;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.observable.filter.DetectTaskDataFilter;
import kd.bos.schedule.next.observable.filter.ExecutorServerStatusFilter;
import kd.bos.schedule.next.observable.filter.SchTaskJobTypeNumFilter;
import kd.bos.schedule.next.observable.filter.SchTaskStatusNumFilter;
import kd.bos.schedule.utils.AppUtils;
import kd.bos.schedule.utils.ErrorProcessUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.util.JSONUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;

public class ClientObservableUtils {
    private static Log logger = LogFactory.getLog(ClientObservableUtils.class);
    private static ServerManager sm = (ServerManager)ServiceFactory.getService(ServerManager.class);
    private static final String TRACE_LOG_KEY = "observable-tracelog";
    private static final DistributeSessionlessCache traceCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-tracelog", new DistributeCacheHAPolicy(true, true));

    public static Map getTraceLog(String tenantId, String accountId, String scheduleId) {
        return traceCache.hgetAll(tenantId + "$" + accountId + "$" + scheduleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDetectTask(MessageInfo info) throws Exception {
        String msgStr = SerializationUtils.toJsonString((Object)info);
        logger.debug("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u63a2\u6d4b\u4efb\u52a1\u5230\u4e3b\u8282\u70b9\uff1a{}", (Object)info);
        try {
            RPCHelper.dispatchToTaskStatus(msgStr);
        }
        catch (Throwable t) {
            logger.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u63a2\u6d4b\u4efb\u52a1\u5230\u4e3b\u8282\u70b9\u5931\u8d25\uff1a{}", (Object)info, (Object)t);
            try {
                JobInfo jobInfo = info.fetchJobInfo();
                ErrorJobInfo errorJobInfo = ErrorProcessUtils.buildErrorJobInfo(jobInfo, t);
                new DbJobDao().writeErrorJobInfo(errorJobInfo);
                new DbTaskDAO().updateStatus(info.getTaskId(), "FAILED", null);
            }
            catch (Exception exp) {
                logger.error("Schedule***\u540e\u53f0\u4e8b\u52a1-\u53d1\u9001\u63a2\u6d4b\u4efb\u52a1\u5931\u8d25\uff0c\u4e14\u5199\u5165\u65e5\u5fd7\u5931\u8d25\uff1a{}", (Object)info, (Object)exp);
            }
            finally {
                throw t;
            }
        }
    }

    public static void sendDelayTask(MessageInfo info) throws Exception {
        throw new UnsupportedOperationException("unsupport : " + info);
    }

    public static void openTrace(String tenantId, String accountId, String scheduleId, boolean open) {
        if (open) {
            traceCache.remove(tenantId + "$" + accountId + "$" + scheduleId);
            traceCache.hset(tenantId + "$" + accountId + "$" + scheduleId, "ENABLE_TRACE".getBytes(), "OPEN".getBytes(), 180);
        } else {
            traceCache.hset(tenantId + "$" + accountId + "$" + scheduleId, "ENABLE_TRACE".getBytes(), "CLOSE".getBytes(), 180);
        }
    }

    public static List<ExecutorServerInfo> queryExecutorServerStatus() {
        return sm.queryExecutorServerStatus();
    }

    public static List<ExecutorServerInfo> queryExecutorServerStatus(String appId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.BIZ);
        return ClientObservableUtils.queryExecutorServerStatus(jobInfo, false);
    }

    public static List<ExecutorServerInfo> queryExecutorServerStatus(JobInfo jobInfo, boolean isFilterAccessType) {
        List clients = sm.queryExecutorServerStatus();
        if (clients == null) {
            return Collections.emptyList();
        }
        if (isFilterAccessType) {
            Iterator itn = clients.iterator();
            while (itn.hasNext()) {
                List accessType;
                ExecutorServerInfo info = (ExecutorServerInfo)itn.next();
                String accessJobMsgTypeStr = (String)info.getDetail().get("AccessJobMsgType");
                if (!StringUtils.isNotEmpty((CharSequence)accessJobMsgTypeStr) || !(accessType = SerializationUtils.fromJsonStringToList((String)accessJobMsgTypeStr, String.class)).isEmpty()) continue;
                itn.remove();
            }
        }
        if (!Instance.isAppSplit()) {
            return clients;
        }
        String appId = jobInfo.getAppId();
        if (AppUtils.isBOSApp(appId)) {
            appId = "bos";
        }
        appId = AppUtils.getRealRouteAppIdByAppId(appId, ClientObservableUtils.convertType(jobInfo.getJobType()));
        Iterator itn = clients.iterator();
        while (itn.hasNext()) {
            ExecutorServerInfo info = (ExecutorServerInfo)itn.next();
            if (info.getAppIds().contains(appId)) continue;
            itn.remove();
        }
        return clients;
    }

    public static JSONArray logQuery(String traceId, String size, String like) {
        SimpleDateFormat sdf = LogQueryUtils.getSimpleDateFormat();
        try {
            LogQueryRequest queryRequest = new LogQueryRequest();
            ArrayList<String> times = new ArrayList<String>();
            Calendar instance = Calendar.getInstance();
            instance.add(5, -1);
            Date date = instance.getTime();
            times.add(sdf.format(date));
            times.add(sdf.format(new Date()));
            queryRequest.setTraceId(traceId);
            queryRequest.setTime(times);
            queryRequest.setKeyword(like);
            if (StringUtils.isNotEmpty((CharSequence)size)) {
                int count = Integer.parseInt(size);
                queryRequest.setSize(count > 5000 ? 5000 : count);
            } else {
                queryRequest.setSize(100);
            }
            RequestContext requestContext = RequestContext.get();
            if (requestContext != null) {
                queryRequest.setAccountId(requestContext.getAccountId());
                queryRequest.setTenantId(requestContext.getTenantId());
            }
            JSONArray result = LogQueryUtils.jsonToDataArray((String)LogQueryUtils.query((LogQueryRequest)queryRequest));
            return result;
        }
        catch (Exception e) {
            logger.error("logquery error ", (Throwable)e);
            return null;
        }
    }

    private static List<EyeNodeInfo> getSortedNodeInfos() {
        ArrayList<EyeNodeInfo> list = new ArrayList<EyeNodeInfo>();
        try {
            String hosts = System.getProperty("configUrl");
            CuratorFramework client = ZKFactory.getZKClient((String)hosts);
            String path = ClientObservableUtils.getRootPath();
            List child = (List)client.getChildren().forPath(path);
            for (String hk : child) {
                String json = new String((byte[])client.getData().forPath(path + "/" + hk), Charset.forName("UTF-8"));
                EyeNodeInfo nodeInfo = (EyeNodeInfo)JSONUtils.cast((String)json, EyeNodeInfo.class, (boolean)true);
                nodeInfo.setAppName(nodeInfo.getShowAppName());
                list.add(nodeInfo);
            }
            Comparator<EyeNodeInfo> byAppName = Comparator.comparing(EyeNodeInfo::getAppName);
            Comparator<EyeNodeInfo> byStartTime = Comparator.comparing(EyeNodeInfo::getStartTimestamp);
            list.sort(byAppName.thenComparing(byStartTime));
        }
        catch (Exception er) {
            throw new RuntimeException("Get monitor node error", er);
        }
        return list;
    }

    private static String getRootPath() {
        String hosts = System.getProperty("configUrl");
        return ZKFactory.getZkRootPath((String)hosts) + Instance.getClusterName() + "/runtime/monitor/nodes";
    }

    public static Map getNodeInfo() {
        List<EyeNodeInfo> serverNodes = ClientObservableUtils.getSortedNodeInfos();
        String clusterName = Instance.getClusterName();
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("appNameList", serverNodes);
        data.put("clusterName", clusterName);
        return data;
    }

    public static Map<String, JSONObject> getExecutorServerStatus() {
        return ExecutorServerStatusFilter.getExecutorServerStatus();
    }

    public static JSONObject getExecutorServerStatus(String ip) {
        return (JSONObject)RPCHelper.remoteGetExecutorServerStatus(ip, ip);
    }

    public static Map<String, Integer> getTodayTaskStatusNum() {
        return SchTaskStatusNumFilter.getTaskStatusNum();
    }

    public static Map<String, Map<Integer, Integer>> getTodayTaskJobTypeNum() {
        return SchTaskJobTypeNumFilter.getTaskJobTypeNum();
    }

    public static String getDetectTaskData(String tenantId, String accountId, String taskId, String setCacheKey) {
        return DetectTaskDataFilter.getDetectTaskData(tenantId, accountId, taskId, setCacheKey);
    }

    public static MessageType convertType(JobType jobType) {
        if (jobType == JobType.REALTIME) {
            return MessageType.REALTIMEJOB;
        }
        if (jobType == JobType.BIZ || jobType == JobType.DETECT) {
            return MessageType.BIZJOB;
        }
        if (jobType == JobType.WORKFLOW) {
            return MessageType.WorkFlowJOB;
        }
        return MessageType.BIZJOB;
    }

    public static JobType convertType(MessageType messageType) {
        if (messageType == MessageType.BIZJOB) {
            return JobType.BIZ;
        }
        if (messageType == MessageType.REALTIMEJOB) {
            return JobType.REALTIME;
        }
        if (messageType == MessageType.WorkFlowJOB) {
            return JobType.WORKFLOW;
        }
        return JobType.BIZ;
    }
}

