/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.extension.ExtensionFactory;
import kd.bos.eye.api.mq.MqMgr;
import kd.bos.eye.util.ApiResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.allocator.ResourceBalanceController;
import kd.bos.schedule.ScheduleConst;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.MessageType;
import kd.bos.schedule.message.ReadyTasks;
import kd.bos.schedule.message.RunningTasks;
import kd.bos.schedule.zk.ZkConfig;

public class ExeMachineObservableInfo {
    private static final String V_HOST = "vhost";
    private static final String MQ_TYPE_KEY = "type";
    private static final String RABBIT_MQ = "rabbitmq";
    private static final String EXEMACHINE_KEY = "observable-exemachine";
    private static final DistributeSessionlessCache exeMachineCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-exemachine", new DistributeCacheHAPolicy(true, true));
    private static final Log logger = LogFactory.getLog(ExeMachineObservableInfo.class);
    private static ExtensionFactory<MqMgr> mqMgrExtensionFactory = ExtensionFactory.getExtensionFacotry(MqMgr.class);
    public static AtomicLong throughPutOneHour = new AtomicLong(0L);
    public static String instanceId;
    public static AtomicLong inQueueOneMin;
    public static AtomicLong outQueueOneMin;
    public static AtomicLong mqFunction;
    public static boolean isError;
    public static Map<String, String> exeMachineLocalQueueStatus;
    public static Map<MessageType, ThreadPoolStatusItem> threadPoolStatus;

    public static String buildStatusJson() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("throughPutOneHour", throughPutOneHour);
        result.put("inQueueOneMin", inQueueOneMin);
        result.put("instanceId", instanceId);
        result.put("outQueueOneMin", outQueueOneMin);
        result.put("mqFunction", mqFunction);
        result.put("threadPoolStatus", ExeMachineObservableInfo.buildThreadPoolStatus());
        exeMachineLocalQueueStatus = ExeMachineObservableInfo.getExeMachineLocalQueueStatus();
        result.put("exeMachineLocalQueueStatus", exeMachineLocalQueueStatus);
        return JSON.toJSONString(result);
    }

    private static JSONObject getMqManagerInfo() {
        ApiResponse response = new ApiResponse();
        String mqType = "";
        Properties prop = new Properties();
        try {
            String property = System.getProperty("mq.server");
            StringReader reader = new StringReader(property);
            prop.load(reader);
            String vhost = prop.getProperty(V_HOST);
            mqType = QueueManager.getMQType((String)"NotExistRegion##@@!!");
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("action", "queues");
            params.put("page", "1");
            params.put("name", "schedule");
            params.put("sort", "messages_ready");
            params.put("asc", "des");
            params.put("page_size", "1");
            params.put(V_HOST, vhost);
            JSONObject data = ((MqMgr)mqMgrExtensionFactory.getExtension(mqType)).process(params);
            data.put(V_HOST, (Object)vhost);
            return data;
        }
        catch (Exception e) {
            logger.error("Schedule***MqMgrHandlerError:", (Throwable)e);
            return null;
        }
    }

    private static Map<String, String> getExeMachineLocalQueueStatus() {
        LinkedHashMap<String, String> queueStatus = new LinkedHashMap<String, String>();
        Set<MessageType> messageTypes = threadPoolStatus.keySet();
        for (MessageType value : messageTypes) {
            if (value != MessageType.BIZJOB && value != MessageType.REALTIMEJOB && value != MessageType.WorkFlowJOB) continue;
            Integer taskSize = null;
            if (ZkConfig.isPigeon() && Configs.isScheduleResourceBalanceEnable() || MessageType.WorkFlowJOB == value && Configs.isWorkFlowResourceBalanceEnable()) {
                int threadSize = ZkConfig.getMaxNumOfWorkThread(value);
                String poolName = ScheduleConst.getThreadPoolName(value);
                ResourceBalanceController resCtl = KDThreadPoolFactory.getOrCreate((String)poolName, (int)threadSize, (int)threadSize).getResourceBalanceController();
                taskSize = resCtl.getWorkQueue().size(RequestContext.get().getAccountId());
            } else {
                taskSize = ReadyTasks.getInstance(value).getTaskSize();
            }
            queueStatus.put(value.name(), String.valueOf(taskSize));
        }
        return queueStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<MessageType, ThreadPoolStatusItem> getThreadPoolStatus() {
        Map<MessageType, ThreadPoolStatusItem> map = threadPoolStatus;
        synchronized (map) {
            List<MessageType> accessJobMsgType = ZkConfig.getAccessJobMsgType();
            if (threadPoolStatus.size() == 0) {
                for (MessageType messageType : accessJobMsgType) {
                    ThreadPoolStatusItem threadPoolStatusItem = new ThreadPoolStatusItem();
                    threadPoolStatusItem.setMaxNum(ZkConfig.getMaxNumOfWorkThread(messageType));
                    threadPoolStatusItem.setRunningNum(0);
                    threadPoolStatusItem.setThreadError(new AtomicInteger(0));
                    threadPoolStatusItem.setThreadTaskSuccess(new AtomicInteger(0));
                    threadPoolStatusItem.setThreadTaskSuccessFunc(0L);
                    threadPoolStatus.put(messageType, threadPoolStatusItem);
                }
            }
            return threadPoolStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, Object>> buildThreadPoolStatus() {
        Map<MessageType, ThreadPoolStatusItem> map = threadPoolStatus;
        synchronized (map) {
            List<MessageType> accessJobMsgType = ZkConfig.getAccessJobMsgType();
            LinkedHashMap<String, Map<String, Object>> buildThreadPoolStatus = new LinkedHashMap<String, Map<String, Object>>(accessJobMsgType.size());
            if (threadPoolStatus.size() == 0) {
                for (MessageType messageType : accessJobMsgType) {
                    HashMap<String, Object> buildThreadPoolStatusItem = new HashMap<String, Object>();
                    buildThreadPoolStatusItem.put("maxNum", ZkConfig.getMaxNumOfWorkThread(messageType));
                    buildThreadPoolStatusItem.put("runningNum", RunningTasks.getInstance(messageType).size());
                    buildThreadPoolStatusItem.put("threadError", "0");
                    buildThreadPoolStatusItem.put("threadTaskSuccess", "0");
                    buildThreadPoolStatusItem.put("threadTaskSuccessTime", "0");
                    buildThreadPoolStatus.put(messageType.name(), buildThreadPoolStatusItem);
                    ThreadPoolStatusItem threadPoolStatusItem = new ThreadPoolStatusItem();
                    threadPoolStatusItem.setMaxNum(ZkConfig.getMaxNumOfWorkThread(messageType));
                    threadPoolStatusItem.setRunningNum(0);
                    threadPoolStatusItem.setThreadError(new AtomicInteger(0));
                    threadPoolStatusItem.setThreadTaskSuccess(new AtomicInteger(0));
                    threadPoolStatusItem.setThreadTaskSuccessFunc(0L);
                    threadPoolStatus.put(messageType, threadPoolStatusItem);
                }
                return buildThreadPoolStatus;
            }
            for (Map.Entry<MessageType, ThreadPoolStatusItem> entry : threadPoolStatus.entrySet()) {
                ThreadPoolStatusItem threadPoolStatusItem = entry.getValue();
                MessageType messageType = entry.getKey();
                HashMap<String, Number> buildThreadPoolStatusItem = new HashMap<String, Number>(5);
                buildThreadPoolStatusItem.put("maxNum", threadPoolStatusItem.getMaxNum());
                buildThreadPoolStatusItem.put("runningNum", RunningTasks.getInstance(messageType).size());
                buildThreadPoolStatusItem.put("threadError", threadPoolStatusItem.getThreadError().get());
                buildThreadPoolStatusItem.put("threadTaskSuccess", threadPoolStatusItem.getThreadTaskSuccess().get());
                buildThreadPoolStatusItem.put("threadTaskSuccessTime", threadPoolStatusItem.getThreadTaskSuccessFunc());
                buildThreadPoolStatus.put(messageType.name(), buildThreadPoolStatusItem);
                RunningTasks runningTasks = RunningTasks.getInstance(messageType);
                MessageInfo[] messageInfos = runningTasks.getMessageInfos();
                if (messageInfos == null || messageInfos.length <= 0) continue;
                ArrayList<String> taskIds = new ArrayList<String>(messageInfos.length);
                for (MessageInfo messageInfo : messageInfos) {
                    if (messageInfo == null) continue;
                    taskIds.add(messageInfo.getTaskId());
                }
                logger.info("Schedule***RunningTask[{}].size: {},data:{}", new Object[]{runningTasks.getMessageType(), taskIds.size(), taskIds});
            }
            return buildThreadPoolStatus;
        }
    }

    static {
        inQueueOneMin = new AtomicLong(0L);
        outQueueOneMin = new AtomicLong(0L);
        mqFunction = new AtomicLong(0L);
        isError = false;
        exeMachineLocalQueueStatus = new LinkedHashMap<String, String>();
        threadPoolStatus = new LinkedHashMap<MessageType, ThreadPoolStatusItem>();
    }

    public static class ThreadPoolStatusItem {
        private Integer maxNum;
        private Integer runningNum;
        private AtomicInteger threadError;
        private AtomicInteger threadTaskSuccess;
        private Long threadTaskSuccessFunc;

        public Integer getMaxNum() {
            return this.maxNum;
        }

        public void setMaxNum(Integer maxNum) {
            this.maxNum = maxNum;
        }

        public Integer getRunningNum() {
            return this.runningNum;
        }

        public void setRunningNum(Integer runningNum) {
            this.runningNum = runningNum;
        }

        public AtomicInteger getThreadError() {
            return this.threadError;
        }

        public void setThreadError(AtomicInteger threadError) {
            this.threadError = threadError;
        }

        public AtomicInteger getThreadTaskSuccess() {
            return this.threadTaskSuccess;
        }

        public void setThreadTaskSuccess(AtomicInteger threadTaskSuccess) {
            this.threadTaskSuccess = threadTaskSuccess;
        }

        public Long getThreadTaskSuccessFunc() {
            return this.threadTaskSuccessFunc;
        }

        public void setThreadTaskSuccessFunc(Long threadTaskSuccessFunc) {
            this.threadTaskSuccessFunc = threadTaskSuccessFunc;
        }
    }
}

