/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleTypeNextEnums;
import kd.bos.schedule.next.observable.IObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.model.TimerPulse;
import kd.bos.schedule.zk.ZkConfig;

public class DetectTaskDataFilter
implements IObservableDataFilter {
    private static final String CACHE_KEY = "observable-detectTask";
    private static final DistributeSessionlessCache detectTaskCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-detectTask", new DistributeCacheHAPolicy(true, true));
    private static final Log log = LogFactory.getLog(DetectTaskDataFilter.class);
    private static final Integer expireTime = 600;

    public void handle(ObservableModel model) {
        ScheduleInfo scheduleInfo = null;
        if (model.getData() instanceof ScheduleInfo) {
            scheduleInfo = (ScheduleInfo)model.getData();
        } else if (model.getData() instanceof TimerPulse) {
            TimerPulse timerPulse = (TimerPulse)model.getData();
            scheduleInfo = timerPulse.getInfo();
        } else {
            return;
        }
        try {
            if (scheduleInfo != null && scheduleInfo.getScheduleType() == ScheduleTypeNextEnums.Detect) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:sss");
                String nowTime = sdf.format(new Date());
                String cacheKey = DetectTaskDataFilter.getCacheKey(scheduleInfo.getTenantId(), scheduleInfo.getAccountId(), scheduleInfo.getJobInfo().getTaskId());
                switch (model.getClassfiy()) {
                    case "generateTime": {
                        detectTaskCache.hset(cacheKey, "generateTime".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                    case "allowFire": {
                        detectTaskCache.hset(cacheKey, "allowFire".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                    case "dispatchJobSuccess": {
                        detectTaskCache.hset(cacheKey, "dispatchJobSuccess".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                    case "timeIsExpire": {
                        detectTaskCache.hset(cacheKey, "dispatchJobSuccess".getBytes(), ResManager.loadKDString((String)"\u751f\u6210\u7684\u65f6\u95f4\u70b9\u8fc7\u671f\u3002", (String)"DetectTaskDataFilter_0", (String)"bos-schedule-message", (Object[])new Object[0]).getBytes(), expireTime.intValue());
                        break;
                    }
                    case "receiveTaskSuccess": {
                        detectTaskCache.hset(cacheKey, "instanceId".getBytes(), Instance.getInstanceId().getBytes(), expireTime.intValue());
                        detectTaskCache.hset(cacheKey, "instanceIp".getBytes(), ZkConfig.getHostIpAddress().getBytes(), expireTime.intValue());
                        detectTaskCache.hset(cacheKey, "receiveTaskSuccess".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                    case "executeTask": {
                        detectTaskCache.hset(cacheKey, "executeTask".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                    case "completeTask": {
                        detectTaskCache.hset(cacheKey, "completeTask".getBytes(), nowTime.getBytes(), expireTime.intValue());
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Schedule***DetectTaskDataFilter error", t);
        }
    }

    private static String getCacheKey(String tenantId, String accountId, String taskId) {
        return tenantId + "$" + accountId + "$" + taskId;
    }

    public void handle(Object data) {
    }

    public void init() {
    }

    public static String getDetectTaskData(String tenantId, String accountId, String taskId, String taskTime) {
        byte[] dataByte = detectTaskCache.hget(DetectTaskDataFilter.getCacheKey(tenantId, accountId, taskId), taskTime.getBytes());
        return dataByte != null ? new String(dataByte) : "";
    }
}

