/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.next.observable.filter.AbstractObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class SchTaskJobTypeNumFilter
extends AbstractObservableDataFilter {
    private final Map<String, Item> localData = new ConcurrentHashMap<String, Item>(8);
    private static final Log logger = LogFactory.getLog(SchTaskJobTypeNumFilter.class);
    private static final String CACHE_KEY = "observable-SchTaskJobTypeNumFilter";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-SchTaskJobTypeNumFilter", new DistributeCacheHAPolicy(true, true));
    private static final JobType[] JOBTYPES = new JobType[]{JobType.BIZ, JobType.WORKFLOW, JobType.REALTIME};
    private Date cacheDate = SchTaskJobTypeNumFilter.getToDayStartTime();

    public void handle(ObservableModel model) {
        if ("taskCreate".equals(model.getClassfiy()) && model.getData() instanceof TaskInfo) {
            TaskInfo info = (TaskInfo)model.getData();
            Date date = SchTaskJobTypeNumFilter.getToDayStartTime(new Date(info.getDispachTime()));
            String jobType = String.valueOf(info.getJobType());
            Item item = this.getItem(model.getTenantId(), model.getAccountId(), date, jobType);
            this.getNum(item, SchTaskJobTypeNumFilter.getNowHour()).incrementAndGet();
        }
    }

    private AtomicInteger getNum(Item item, int hour) {
        AtomicInteger num = item.getData().get(hour);
        if (num == null) {
            num = new AtomicInteger(0);
            item.getData().put(hour, num);
        }
        return num;
    }

    private static int getNowHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    @Override
    public void handle(Object data) {
    }

    public void init() {
        ThreadPools.executeOnce((String)"BOSSchedule-SchTaskStatusNumFilter.init", this::innerInit);
    }

    private void innerInit() {
        List<Account> list = SchTaskJobTypeNumFilter.getAllAccountsOfCurrentEnv();
        Date date = SchTaskJobTypeNumFilter.getToDayStartTime();
        for (Account account : list) {
            try {
                RequestContextCreator.createBatch((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                String cacheKey = SchTaskJobTypeNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, "BIZ");
                String cacheStr = (String)cache.get(cacheKey + 0);
                if (StringUtils.isNotEmpty((String)cacheStr)) continue;
                String sql = "select count(1) num, hour(fdispatchtime) val,fjobtype jobtype from t_sch_task where fdispatchtime > ? group by val,fjobtype order by val";
                Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)date)};
                Map res = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
                    LinkedHashMap result = new LinkedHashMap(8);
                    for (JobType jobtypeEnum : SchTaskJobTypeNumFilter.getJobTypes()) {
                        result.put(String.valueOf(jobtypeEnum), new HashMap(24));
                    }
                    while (resultSet.next()) {
                        String jobtype = resultSet.getString("jobtype");
                        int num = resultSet.getInt("num");
                        int val = resultSet.getInt("val");
                        Map map = (Map)result.get(jobtype);
                        if (map == null) continue;
                        map.put(val, new AtomicInteger(num));
                    }
                    return result;
                });
                block3: for (Map.Entry entry : res.entrySet()) {
                    String jobType = (String)entry.getKey();
                    cacheKey = SchTaskJobTypeNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, jobType);
                    for (Map.Entry data : ((Map)entry.getValue()).entrySet()) {
                        if (StringUtils.isNotEmpty((String)((String)cache.get(cacheKey + data.getKey())))) continue block3;
                        cache.put(cacheKey + data.getKey(), (Object)String.valueOf(((AtomicInteger)data.getValue()).get()), 86400, TimeUnit.SECONDS);
                    }
                }
                logger.info("Schedule***ScheduleTaskStatFilter init success");
            }
            catch (Throwable e) {
                logger.error("Schedule***ScheduleTaskStatFilter init error", e);
            }
        }
    }

    @Override
    public void submitData() {
        Date today = SchTaskJobTypeNumFilter.getToDayStartTime();
        if (this.cacheDate.compareTo(today) != 0) {
            this.clearCache(this.cacheDate);
            this.cacheDate = today;
            return;
        }
        for (Map.Entry<String, Item> entry : this.localData.entrySet()) {
            Item localItem = entry.getValue();
            if (localItem.getData().isEmpty()) continue;
            String cacheKey = entry.getKey();
            for (Map.Entry<Integer, AtomicInteger> data : localItem.getData().entrySet()) {
                int incrNum = data.getValue().get();
                if (incrNum <= 0) continue;
                cache.incrBy(cacheKey + data.getKey(), incrNum);
                data.getValue().getAndAdd(-incrNum);
                cache.expireAfter(cacheKey + data.getKey(), 86400, TimeUnit.SECONDS);
            }
        }
    }

    private void clearCache(Date date) {
        this.localData.clear();
        List<Account> accounts = SchTaskJobTypeNumFilter.getAllAccountsOfCurrentEnv();
        ArrayList<String> cacheKeys = new ArrayList<String>(accounts.size());
        for (Account account : accounts) {
            for (JobType jobType : SchTaskJobTypeNumFilter.getJobTypes()) {
                String cacheKey = SchTaskJobTypeNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, String.valueOf(jobType));
                for (int i = 0; i < 24; ++i) {
                    cacheKeys.add(cacheKey + i);
                }
            }
        }
        if (!cacheKeys.isEmpty()) {
            cache.remove(cacheKeys.toArray(new String[0]));
        }
    }

    private static JobType[] getJobTypes() {
        return JOBTYPES;
    }

    private static String getCacheKeyAccount(String tenantId, String accountId, Date date, String jobType) {
        String str = "observable-SchTaskJobTypeNumFilter&&" + tenantId + "&&" + accountId + "&&" + date.getTime() + "&&" + jobType;
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            str = str + ZkConfig.getHostIpAddress();
        }
        return str + SchTaskJobTypeNumFilter.getCacheKeyVersion();
    }

    public static Map<String, Map<Integer, Integer>> getTaskJobTypeNum() {
        int hour = SchTaskJobTypeNumFilter.getNowHour();
        HashMap<String, Map<Integer, Integer>> result = new HashMap<String, Map<Integer, Integer>>(8);
        RequestContext rc = RequestContext.get();
        for (JobType jobTypeEnum : SchTaskJobTypeNumFilter.getJobTypes()) {
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>(8);
            String jobType = String.valueOf(jobTypeEnum);
            String cacheKey = SchTaskJobTypeNumFilter.getCacheKeyAccount(rc.getTenantId(), rc.getAccountId(), SchTaskJobTypeNumFilter.getToDayStartTime(), jobType);
            for (int i = 0; i <= hour; ++i) {
                int num = 0;
                String content = (String)cache.get(cacheKey + i);
                if (StringUtils.isNotEmpty((String)content)) {
                    num = Integer.parseInt(content);
                }
                map.put(i, num);
            }
            result.put(jobType, map);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getItem(String tenantId, String accountId, Date date, String jobType) {
        String key = SchTaskJobTypeNumFilter.getCacheKeyAccount(tenantId, accountId, date, jobType);
        Item info = this.localData.get(key);
        if (info == null) {
            Map<String, Item> map = this.localData;
            synchronized (map) {
                info = this.localData.get(key);
                if (info == null) {
                    info = new Item();
                    info.setAccountId(accountId);
                    info.setTenantId(tenantId);
                    info.setDate(date);
                    info.setJobType(jobType);
                    this.localData.put(key, info);
                }
            }
        }
        return info;
    }

    static class Item {
        private String tenantId;
        private String accountId;
        private String jobType;
        private Date date;
        private Map<Integer, AtomicInteger> data = new ConcurrentHashMap<Integer, AtomicInteger>(8);

        Item() {
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Map<Integer, AtomicInteger> getData() {
            return this.data;
        }

        public void setData(Map<Integer, AtomicInteger> data) {
            this.data = data;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getJobType() {
            return this.jobType;
        }

        public void setJobType(String jobType) {
            this.jobType = jobType;
        }
    }
}

