/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.api.TaskStatusConstant;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.next.observable.filter.AbstractObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class SchTaskStatusNumFilter
extends AbstractObservableDataFilter {
    private Map<String, Item> localData = new ConcurrentHashMap<String, Item>(8);
    private final Log logger = LogFactory.getLog(SchTaskStatusNumFilter.class);
    private static final String CACHE_KEY = "observable-SchTaskStatusStatsFilter";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("observable-SchTaskStatusStatsFilter", new DistributeCacheHAPolicy(true, true));
    private Date cacheDate = SchTaskStatusNumFilter.getToDayStartTime();

    public void handle(ObservableModel model) {
        if (!(model.getData() instanceof TaskInfo)) {
            return;
        }
        if ("taskUpdateStatus".equals(model.getClassfiy())) {
            Date date;
            TaskInfo info = (TaskInfo)model.getData();
            if (info.getDispachTime() == 0L) {
                date = SchTaskStatusNumFilter.getToDayStartTime();
                this.logger.warn("task dispatchtime is 0, taskid:{},date : {} ,tenantid:{},AccountId:{}", new Object[]{info.getId(), date, model.getTenantId(), model.getAccountId()});
            } else {
                date = SchTaskStatusNumFilter.getToDayStartTime(new Date(info.getDispachTime()));
            }
            Item item = this.getItem(model.getTenantId(), model.getAccountId(), date);
            String status = info.getStatus();
            if (TaskStatusConstant.isEnd((String)status)) {
                this.getNum(item, status).incrementAndGet();
            }
        }
    }

    private AtomicInteger getNum(Item item, String status) {
        AtomicInteger num = item.getData().get(status);
        if (num == null) {
            num = new AtomicInteger(0);
            item.getData().put(status, num);
        }
        return num;
    }

    @Override
    public void handle(Object data) {
    }

    public void init() {
        ThreadPools.executeOnce((String)"BOSSchedule-SchTaskStatusNumFilter.init", () -> this.innerInit());
    }

    private void innerInit() {
        List<Account> list = SchTaskStatusNumFilter.getAllAccountsOfCurrentEnv();
        Date date = SchTaskStatusNumFilter.getToDayStartTime();
        for (Account account : list) {
            try {
                RequestContextCreator.createBatch((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                String cacheKey = SchTaskStatusNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, "COMPLETED");
                String cacheStr = (String)cache.get(cacheKey);
                if (StringUtils.isNotEmpty((String)cacheStr)) continue;
                String sql = "select count(fstatus) num,fstatus  from t_sch_task tst  where fdispatchtime >= ?  and fstatus not in (?,?,?) group by fstatus";
                Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)date), new SqlParameter(":fstatus", 12, (Object)"SCHEDULED"), new SqlParameter(":fstatus", 12, (Object)"BEGIN"), new SqlParameter(":fstatus", 12, (Object)"READY")};
                Map res = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
                    HashMap<String, Integer> result = new HashMap<String, Integer>(8);
                    while (resultSet.next()) {
                        String status = resultSet.getString("fstatus");
                        int num = resultSet.getInt("num");
                        result.put(status, num);
                    }
                    return result;
                });
                for (Map.Entry entry : res.entrySet()) {
                    String status = (String)entry.getKey();
                    Integer num = (Integer)entry.getValue();
                    cacheKey = SchTaskStatusNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, status);
                    cache.put(cacheKey, (Object)String.valueOf(num), 86400, TimeUnit.SECONDS);
                }
                this.logger.info("Schedule***ScheduleTaskStatFilter init success");
            }
            catch (Throwable e) {
                this.logger.error("Schedule***ScheduleTaskStatFilter init error", e);
            }
        }
    }

    @Override
    public void submitData() {
        Date today = SchTaskStatusNumFilter.getToDayStartTime();
        if (this.cacheDate.compareTo(today) != 0) {
            this.clearCache(this.cacheDate);
            this.cacheDate = today;
            return;
        }
        for (Map.Entry<String, Item> entry : this.localData.entrySet()) {
            Item localItem = entry.getValue();
            if (localItem.getData().isEmpty()) continue;
            for (Map.Entry<String, AtomicInteger> data : localItem.getData().entrySet()) {
                String status = data.getKey();
                int incrNum = data.getValue().get();
                String cacheKey = SchTaskStatusNumFilter.getCacheKeyAccount(localItem.getTenantId(), localItem.getAccountId(), localItem.getDate(), status);
                if (incrNum <= 0) continue;
                cache.incrBy(cacheKey, incrNum);
                cache.expireAfter(cacheKey, 86400, TimeUnit.SECONDS);
                data.getValue().getAndAdd(-incrNum);
            }
        }
    }

    private void clearCache(Date date) {
        this.localData.clear();
        List<Account> accounts = SchTaskStatusNumFilter.getAllAccountsOfCurrentEnv();
        ArrayList<String> cacheKeys = new ArrayList<String>(accounts.size());
        for (Account account : accounts) {
            for (String stutus : SchTaskStatusNumFilter.getTaskEndStatus()) {
                String cacheKey = SchTaskStatusNumFilter.getCacheKeyAccount(account.getTenantId(), account.getAccountId(), date, stutus);
                cacheKeys.add(cacheKey);
            }
        }
        if (!cacheKeys.isEmpty()) {
            cache.remove(cacheKeys.toArray(new String[0]));
        }
    }

    private static String[] getTaskEndStatus() {
        return new String[]{"COMPLETED", "ABORTED", "FAILED", "TIMEOUT", "SKIP"};
    }

    private static String getCacheKeyAccount(String tenantId, String accountId, Date date, String status) {
        String str = "observable-SchTaskStatusStatsFilter&&" + tenantId + "&&" + accountId + "&&" + date.getTime() + "&&" + status;
        if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
            str = str + ZkConfig.getHostIpAddress();
        }
        return str + SchTaskStatusNumFilter.getCacheKeyVersion();
    }

    public static Map<String, Integer> getTaskStatusNum() {
        RequestContext rc = RequestContext.get();
        HashMap<String, Integer> result = new HashMap<String, Integer>(8);
        for (String status : SchTaskStatusNumFilter.getTaskEndStatus()) {
            String cacheKey = SchTaskStatusNumFilter.getCacheKeyAccount(rc.getTenantId(), rc.getAccountId(), SchTaskStatusNumFilter.getToDayStartTime(), status);
            int num = 0;
            String numStr = (String)cache.get(cacheKey);
            if (StringUtils.isNotEmpty((String)numStr)) {
                num = Integer.parseInt(numStr);
            }
            result.put(status, num);
        }
        String sql = "select count(fstatus) num,fstatus  from t_sch_task tst  where fdispatchtime >= ?  and fstatus in (?,?,?) group by fstatus";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)SchTaskStatusNumFilter.getToDayStartTime()), new SqlParameter(":fstatus", 12, (Object)"SCHEDULED"), new SqlParameter(":fstatus", 12, (Object)"BEGIN"), new SqlParameter(":fstatus", 12, (Object)"READY")};
        Map res = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
            HashMap<String, Integer> ret = new HashMap<String, Integer>(8);
            while (resultSet.next()) {
                String status = resultSet.getString("fstatus");
                int num = resultSet.getInt("num");
                ret.put(status, num);
            }
            return ret;
        });
        result.putAll(res);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getItem(String tenantId, String accountId, Date date) {
        String key = SchTaskStatusNumFilter.getCacheKeyAccount(tenantId, accountId, date, null);
        Item info = this.localData.get(key);
        if (info == null) {
            Map<String, Item> map = this.localData;
            synchronized (map) {
                info = this.localData.get(key);
                if (info == null) {
                    info = new Item();
                    info.setAccountId(accountId);
                    info.setTenantId(tenantId);
                    info.setDate(date);
                    this.localData.put(key, info);
                }
            }
        }
        return info;
    }

    static class Item {
        private String tenantId;
        private String accountId;
        private Date date;
        private Map<String, AtomicInteger> data = new ConcurrentHashMap<String, AtomicInteger>(8);

        Item() {
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Map<String, AtomicInteger> getData() {
            return this.data;
        }

        public void setData(Map<String, AtomicInteger> data) {
            this.data = data;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

