/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule.next.observable.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.message.AbstractService;
import kd.bos.schedule.message.rpc.RPCHelper;
import kd.bos.schedule.next.observable.ObservableLogHandler;
import kd.bos.schedule.next.observable.filter.AbstractObservableDataFilter;
import kd.bos.schedule.next.observable.model.ObservableModel;
import kd.bos.schedule.next.observable.model.SchTaskNumInfo;
import kd.bos.schedule.zk.ZkConfig;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class Top5ScheduleTaskNumFilter
extends AbstractObservableDataFilter {
    private Map<String, Item> localData = new ConcurrentHashMap<String, Item>(8);
    private static final Log logger = LogFactory.getLog(Top5ScheduleTaskNumFilter.class);

    public void handle(ObservableModel model) {
        if (!"taskCreate".equals(model.getClassfiy()) || !(model.getData() instanceof TaskInfo)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)model.getData();
        String scheduleId = taskInfo.getScheduleId();
        if (taskInfo.getJobType() != JobType.BIZ || StringUtils.isEmpty((String)scheduleId)) {
            return;
        }
        if (taskInfo.getGroupId() != 0L) {
            return;
        }
        Date date = Top5ScheduleTaskNumFilter.getToDayStartTime(new Date(taskInfo.getDispachTime()));
        Item item = this.getItem(model.getAccountId(), model.getAccountId(), date);
        AtomicInteger num = this.getScheduleNum(scheduleId, item);
        num.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicInteger getScheduleNum(String scheduleId, Item item) {
        AtomicInteger num = item.getData().get(scheduleId);
        if (num == null) {
            Item item2 = item;
            synchronized (item2) {
                num = item.getData().get(scheduleId);
                if (num == null) {
                    num = new AtomicInteger(0);
                    item.getData().put(scheduleId, num);
                }
            }
        }
        return num;
    }

    public void init() {
        this.clearCache();
        ThreadPools.executeOnce((String)"BOSSchedule-SchTaskStatusNumFilter.init", this::innerInit);
    }

    private void innerInit() {
        List<Account> list = Top5ScheduleTaskNumFilter.getAllAccountsOfCurrentEnv();
        Date date = Top5ScheduleTaskNumFilter.getToDayStartTime();
        for (Account account : list) {
            try {
                RequestContextCreator.createBatch((String)account.getTenantId(), (String)account.getAccountId(), (String)"0");
                StringBuilder sb = new StringBuilder("select count(1) as tasknum,tss.fnumber,tst.fscheduleid  from t_sch_task tst  left join t_sch_schedule tss on  tst.fscheduleid = tss.fid  ").append(" where tst.fscheduleid is not null and fjobtype = 'BIZ' and tst.fdispatchtime >= ? ");
                if (AbstractService.RunMode.Dev == ZkConfig.getRunMode()) {
                    sb.append(String.format(" and tst.frunat = '%s' ", AbstractService.getHostIpAddress()));
                }
                sb.append(" group by tst.fscheduleid, tss.fnumber;");
                Object[] params = new SqlParameter[]{new SqlParameter(":fdispatchtime", 93, (Object)date)};
                Map res = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sb.toString(), (Object[])params, resultSet -> {
                    ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>(16);
                    while (resultSet.next()) {
                        String fscheduleid = resultSet.getString("fscheduleid");
                        if (StringUtils.isEmpty((String)fscheduleid)) continue;
                        int num = resultSet.getInt("tasknum");
                        result.put(fscheduleid, num);
                    }
                    return result;
                });
                Item item = this.getItem(account.getAccountId(), account.getTenantId(), date);
                for (Map.Entry entry : res.entrySet()) {
                    String scheduleId = (String)entry.getKey();
                    Integer num = (Integer)entry.getValue();
                    this.getScheduleNum(scheduleId, item).addAndGet(num);
                }
                logger.info("Schedule***Top5ScheduleTaskNumFilter init success");
            }
            catch (Throwable e) {
                logger.error("Schedule***ScheduleTaskStatFilter init error", e);
            }
        }
    }

    @Override
    public void submitData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkDateChange(Date date, Item item) {
        Date cacheDate = item.getDate();
        if (cacheDate == null) {
            return false;
        }
        if (cacheDate.compareTo(date) == 0) return false;
        Class<Top5ScheduleTaskNumFilter> clazz = Top5ScheduleTaskNumFilter.class;
        synchronized (Top5ScheduleTaskNumFilter.class) {
            if (cacheDate.compareTo(date) == 0) return false;
            this.clearCache(item.getAccountId());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return true;
        }
    }

    private void clearCache() {
        this.localData.clear();
        logger.info("Top5ScheduleTaskNum.clearCache");
    }

    private void clearCache(String accountId) {
        this.localData.remove(accountId);
        logger.info("Top5ScheduleTaskNum.clearCache accountId", (Object)accountId);
    }

    public static List<SchTaskNumInfo> getSchTaskNumList() {
        String masterRpcIp = RPCHelper.getMasterRpcIp();
        return (List)EndPointDispatchServiceHelper.invoke((String)masterRpcIp, (String)"kd.bos.schedule.next.observable.filter.Top5ScheduleTaskNumFilter", (String)"_getSchTaskNumList", (Object[])new Object[0]);
    }

    public static List<SchTaskNumInfo> _getSchTaskNumList() {
        RequestContext rc = RequestContext.get();
        Top5ScheduleTaskNumFilter filter = (Top5ScheduleTaskNumFilter)ObservableLogHandler.getFilters((String)Top5ScheduleTaskNumFilter.class.getName());
        Item item = filter.getItem(rc.getAccountId(), rc.getTenantId(), Top5ScheduleTaskNumFilter.getToDayStartTime());
        Map<String, AtomicInteger> map = item.getData();
        ArrayList<SchTaskNumInfo> allList = new ArrayList<SchTaskNumInfo>(map.size());
        for (Map.Entry<String, AtomicInteger> entry : map.entrySet()) {
            String scheduleId = entry.getKey();
            int num = entry.getValue().get();
            SchTaskNumInfo info = new SchTaskNumInfo();
            info.setScheduleId(scheduleId);
            info.setNum(Integer.valueOf(num));
            allList.add(info);
        }
        allList.sort(Comparator.comparingInt(o -> o.getNum()));
        Collections.reverse(allList);
        int top = Math.min(allList.size(), 5);
        List<SchTaskNumInfo> top5List = allList.subList(0, top);
        return top5List;
    }

    private Item getItem(String accountId, String tenantId, Date date) {
        Item item = this._getItem(accountId, tenantId, date);
        if (this.checkDateChange(date, item)) {
            item = this._getItem(accountId, tenantId, date);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item _getItem(String accountId, String tenantId, Date date) {
        String key = accountId;
        Item info = this.localData.get(key);
        if (info == null) {
            Map<String, Item> map = this.localData;
            synchronized (map) {
                info = this.localData.get(key);
                if (info == null) {
                    info = new Item();
                    info.setAccountId(accountId);
                    info.setTenantId(tenantId);
                    info.setDate(date);
                    this.localData.put(key, info);
                }
            }
        }
        return info;
    }

    public void stop() {
        this.clearCache();
    }

    public String getFilterType() {
        return "master";
    }

    static class Item {
        private String tenantId;
        private String accountId;
        private Date date;
        private Map<String, AtomicInteger> data = new ConcurrentHashMap<String, AtomicInteger>(8);

        Item() {
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Map<String, AtomicInteger> getData() {
            return this.data;
        }

        public void setData(Map<String, AtomicInteger> data) {
            this.data = data;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }
}

